/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.AgedMob;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.MobAge;
import net.minecraft.core.entity.animal.MobAnimal;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.item.tool.ItemToolShears;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobChicken
extends MobAnimal
implements AgedMob {
    public float flap = 0.0f;
    public float flapSpeed = 0.0f;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    public int eggTimer;
    public int featherTimer;
    @NotNull
    private final MobAge age;

    public MobChicken(World world) {
        super(world);
        this.setTextureIdentifier("minecraft", "chicken");
        this.setSize(0.4f, 0.8f);
        this.eggTimer = this.random.nextInt(6000) + 6000;
        this.featherTimer = this.random.nextInt(3000) + 3000;
        this.mobDrops.add(new WeightedRandomLootObject(Items.FEATHER_CHICKEN.getDefaultStack(), 0, 2));
        this.age = MobAge.newRandom(this, 168, 14, 140);
    }

    @Override
    @NotNull
    public MobAge getMobAge() {
        return this.age;
    }

    @Override
    public int getMaxHealth() {
        return 4;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.onGround ? -1 : 4) * 0.3);
        if (this.flapSpeed < 0.0f) {
            this.flapSpeed = 0.0f;
        }
        if (this.flapSpeed > 1.0f) {
            this.flapSpeed = 1.0f;
        }
        if (!this.onGround && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        if (!this.onGround && this.yd < 0.0) {
            this.yd *= 0.6;
        }
        this.flap += this.flapping * 2.0f;
        if (!this.world.isClientSide && --this.eggTimer <= 0) {
            this.world.playSoundAtEntity(null, this, "mob.chickenplop", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.dropItem(Items.EGG_CHICKEN.id, 1);
            this.eggTimer = this.random.nextInt(6000) + 6000;
        }
        if (!this.world.isClientSide && --this.featherTimer <= 0) {
            this.dropItem(Items.FEATHER_CHICKEN.id, 1);
            this.featherTimer = this.random.nextInt(3000) + 3000;
        }
        this.getMobAge().tick(this.world);
    }

    @Override
    public boolean interact(@NotNull Player player) {
        if (super.interact(player)) {
            return true;
        }
        @Nullable ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof ItemToolShears && this.getHealth() > 0 && this.hurtTime <= 0 && !this.world.isClientSide) {
            int count = 1 + this.random.nextInt(2);
            for (int j = 0; j < count; ++j) {
                @NotNull EntityItem feather = this.dropItem(new ItemStack(Items.FEATHER_CHICKEN, 1), 1.0f);
                feather.yd += (double)(this.random.nextFloat() * 0.05f);
                feather.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                feather.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            }
            heldItem.damageItem(1, player);
            if (heldItem.stackSize <= 0) {
                player.destroyCurrentEquippedItem();
            }
            this.hurt(player, 1, DamageType.COMBAT);
            return true;
        }
        return false;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.age.readTag(tag);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.age.writeTag(tag);
    }

    @Override
    protected void causeFallDamage(float distance) {
    }

    @Override
    public String getLivingSound() {
        return "mob.chicken";
    }

    @Override
    protected String getHurtSound() {
        return "mob.chickenhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.chickenhurt";
    }

    @Override
    public boolean isFavouriteItem(ItemStack itemStack) {
        return itemStack != null && itemStack.getItem().hasTag(ItemTags.CHICKENS_FAVOURITE_ITEM);
    }
}

