/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicBrazier;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.BlockLogicTNT;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFireStriker
extends Item {
    public ItemFireStriker(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 1;
        this.setMaxDamage(ToolMaterial.iron.getDurability() / 2);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (world.isAirBlock(blockPos = blockPos.add(side.getDirection(), new TilePos()))) {
            if (world.setBlockTypeNotify(blockPos, Blocks.FIRE)) {
                world.playSoundEffect(player, SoundCategory.WORLD_SOUNDS, (double)blockPos.x() + 0.5, (double)blockPos.y() + 0.5, (double)blockPos.z() + 0.5, "fire.ignite", 1.0f, itemRand.nextFloat() * 0.4f + 0.8f);
                selfStack.damageItem(1, player);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        if (!this.onUseOnBlock(selfStack, world, null, blockPos, direction.getSide(), 0.5, 0.5)) {
            BlockLogicBrazier brazier;
            blockPos = blockPos.add(direction, new TilePos());
            TilePos queryPos = new TilePos();
            Block<?> b = world.getBlockType(blockPos);
            BlockLogic blockLogic = Block.getLogicClass(b);
            if (blockLogic instanceof BlockLogicBrazier && !(brazier = (BlockLogicBrazier)blockLogic).isBurning()) {
                if (Block.hasLogicClass(world.getBlockType(blockPos.east(queryPos)), BlockLogicFluid.class) || Block.hasLogicClass(world.getBlockType(blockPos.west(queryPos)), BlockLogicFluid.class) || Block.hasLogicClass(world.getBlockType(blockPos.south(queryPos)), BlockLogicFluid.class) || Block.hasLogicClass(world.getBlockType(blockPos.north(queryPos)), BlockLogicFluid.class)) {
                    return;
                }
                world.setBlockTypeNotify(blockPos, Blocks.BRAZIER_ACTIVE);
                selfStack.damageItem(1, null);
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)blockPos.x() + 0.5, (double)blockPos.y() + 0.5, (double)blockPos.z() + 0.5, "fire.ignite", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
            } else {
                blockLogic = Block.getLogicClass(b);
                if (blockLogic instanceof BlockLogicTNT) {
                    BlockLogicTNT tnt = (BlockLogicTNT)blockLogic;
                    tnt.ignite(world, new TilePos(blockPos), true);
                }
            }
        }
    }
}

