/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.menu;

import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.slot.Slot;
import org.jetbrains.annotations.NotNull;

public class MenuDispenser
extends MenuAbstract {
    private static final int NUM_DISPENSER_COLUMNS = 3;
    private static final int NUM_DISPENSER_ROWS = 3;
    private static final int DISPENSER_SLOTS_START = 0;
    private static final int INVENTORY_SLOTS_START = 9;
    private static final int HOTBAR_SLOTS_START = 36;
    public TileEntityDispenser dispenser;

    public MenuDispenser(Container container, TileEntityDispenser dispenser) {
        int x;
        int y;
        this.dispenser = dispenser;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.addSlot(new Slot(dispenser, x + y * 3, 62 + x * 18, 17 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlot(new Slot(container, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot(container, i, 8 + i * 18, 142));
        }
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return this.dispenser.stillValid(player);
    }

    @Override
    public IntList getMoveSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        if (slot.index >= 0 && slot.index < 9) {
            return this.getSlots(0, 9, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.index >= 9 && slot.index < 36) {
                return this.getSlots(9, 27, false);
            }
            if (slot.index >= 36) {
                return this.getSlots(36, 9, false);
            }
        }
        if (action == InventoryAction.MOVE_SIMILAR && slot.index >= 9) {
            return this.getSlots(9, 36, false);
        }
        return null;
    }

    @Override
    public IntList getTargetSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        if (slot.index >= 0 && slot.index < 9) {
            return this.getSlots(9, 36, false);
        }
        return this.getSlots(0, 9, false);
    }
}

