/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.LevelStorageBase;
import net.minecraft.core.world.save.LevelStorageCore;
import net.minecraft.core.world.save.SaveFile;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class SaveFormatBase
implements ISaveFormat {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final File savesDir;
    @NotNull
    public LevelStorageBase.SaveHandlerFactory factory = LevelStorageCore::new;

    public SaveFormatBase(File savesDir) {
        if (!savesDir.exists()) {
            savesDir.mkdirs();
        }
        this.savesDir = savesDir;
    }

    @Override
    public LevelData getLevelData(String worldDirName) {
        CompoundTag tag = this.getLevelDataRaw(worldDirName);
        if (tag == null) {
            return null;
        }
        return LevelData.deserialize(tag);
    }

    @Override
    public CompoundTag getLevelDataRaw(String worldDirName) {
        File worldDir = new File(this.savesDir, worldDirName);
        if (!worldDir.exists()) {
            return null;
        }
        File worldLevelDat = new File(worldDir, "level.dat");
        if (worldLevelDat.exists()) {
            try {
                CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                CompoundTag nbtRootData = nbtRoot.getCompound("Data");
                return nbtRootData;
            }
            catch (Exception ex) {
                LOGGER.error("Exception loading level dat for world '{}'!", (Object)worldDirName, (Object)ex);
            }
        }
        if ((worldLevelDat = new File(worldDir, "level.dat_old")).exists()) {
            try {
                CompoundTag oldNbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                CompoundTag oldNbtRootData = oldNbtRoot.getCompound("Data");
                return oldNbtRootData;
            }
            catch (Exception ex) {
                LOGGER.error("Exception loading level dat old for world '{}'!", (Object)worldDirName, (Object)ex);
            }
        }
        return null;
    }

    @Override
    public DimensionData getDimensionData(@NotNull String worldDirName, @NotNull Dimension dimension) {
        CompoundTag tag = this.getDimensionDataRaw(worldDirName, dimension);
        if (tag == null) {
            return null;
        }
        return DimensionData.fromCompoundTag(tag, dimension);
    }

    @Override
    public CompoundTag getDimensionDataRaw(@NotNull String worldDirName, @NotNull Dimension dimension) {
        File worldDir = new File(this.savesDir, worldDirName);
        if (!worldDir.exists()) {
            return null;
        }
        File dimensionsDir = new File(worldDir, "dimensions");
        File dimensionDir = new File(dimensionsDir, "" + dimension.id);
        File dimensionDat = new File(dimensionDir, "dimension.dat");
        if (dimensionDat.exists()) {
            try {
                CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(dimensionDat.toPath(), new OpenOption[0]));
                CompoundTag nbtRootData = nbtRoot.getCompound("Data");
                return nbtRootData;
            }
            catch (Exception ex) {
                LOGGER.error("Exception loading dimension dat '{}' for world '{}'!", dimension, worldDirName, ex);
            }
        }
        if ((dimensionDat = new File(dimensionDir, "dimension.dat_old")).exists()) {
            try {
                CompoundTag oldNbtRoot = NbtIo.readCompressed(Files.newInputStream(dimensionDat.toPath(), new OpenOption[0]));
                CompoundTag oldNbtRootData = oldNbtRoot.getCompound("Data");
                return oldNbtRootData;
            }
            catch (Exception ex) {
                LOGGER.error("Exception loading dimension dat old '{}' for world '{}'!", dimension, worldDirName, ex);
            }
        }
        return null;
    }

    @Override
    public List<SaveFile> getSaveFileList() {
        ArrayList<SaveFile> saveFileList = new ArrayList<SaveFile>();
        File[] saveDirFiles = this.savesDir.listFiles();
        if (saveDirFiles != null) {
            for (File file : saveDirFiles) {
                long size;
                long lastTimePlayed;
                String worldName;
                if (!file.isDirectory()) continue;
                String worldDirName = file.getName();
                LevelData levelData = this.getLevelData(worldDirName);
                Int2ObjectArrayMap<DimensionData> dimensionData = new Int2ObjectArrayMap<DimensionData>();
                boolean needsConversion = false;
                if (levelData == null) {
                    worldName = I18n.getInstance().translateKey("save.data.missing.data");
                    lastTimePlayed = System.currentTimeMillis();
                    size = -1L;
                } else {
                    lastTimePlayed = levelData.getLastTimePlayed();
                    size = levelData.getSizeOnDisk();
                    needsConversion = levelData.getSaveVersion() != this.getSaveVersion();
                    worldName = levelData.getWorldName();
                    if (worldName == null || MathHelper.stringNullOrLengthZero(worldName)) {
                        worldName = worldDirName;
                    }
                    for (Dimension dimension : Dimension.getDimensionList().values()) {
                        dimensionData.put(dimension.id, this.getDimensionData(worldDirName, dimension));
                    }
                }
                saveFileList.add(new SaveFile(worldDirName, worldName, levelData, dimensionData, lastTimePlayed, size, needsConversion));
            }
        }
        return saveFileList;
    }

    @Override
    public void renameWorld(String worldDirName, String newName) {
        File worldDir = new File(this.savesDir, worldDirName);
        if (!worldDir.exists()) {
            return;
        }
        File worldLevelDat = new File(worldDir, "level.dat");
        if (worldLevelDat.exists()) {
            try {
                CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(worldLevelDat.toPath(), new OpenOption[0]));
                CompoundTag nbtRootData = nbtRoot.getCompound("Data");
                nbtRootData.putString("LevelName", newName);
                NbtIo.writeCompressed(nbtRoot, Files.newOutputStream(worldLevelDat.toPath(), new OpenOption[0]));
            }
            catch (Exception exception) {
                LOGGER.error("Failed to rename world '{}' to '{}'!", worldDirName, newName, exception);
            }
        }
    }

    @Override
    public void deleteSave(String worldDirName) {
        File[] worldDirFiles;
        File worldDir = new File(this.savesDir, worldDirName);
        if (worldDir.exists() && (worldDirFiles = worldDir.listFiles()) != null) {
            SaveFormatBase.deleteFilesRecursively(worldDirFiles);
            worldDir.delete();
        }
    }

    @Override
    public LevelStorage getLevelStorage(String worldDirName, boolean isMultiplayer) {
        return this.factory.apply(this, this.savesDir, worldDirName);
    }

    protected static void deleteFilesRecursively(File[] dirFiles) {
        for (File file : dirFiles) {
            File[] subDirFiles;
            if (file.isDirectory() && (subDirFiles = file.listFiles()) != null) {
                SaveFormatBase.deleteFilesRecursively(subDirFiles);
            }
            file.delete();
        }
    }
}

