/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.helpers.IntegerCoordinates;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.generate.feature.WorldFeatureAlgae;
import net.minecraft.core.world.generate.feature.WorldFeatureCactus;
import net.minecraft.core.world.generate.feature.WorldFeatureClay;
import net.minecraft.core.world.generate.feature.WorldFeatureDeadBush;
import net.minecraft.core.world.generate.feature.WorldFeatureDungeon;
import net.minecraft.core.world.generate.feature.WorldFeatureFire;
import net.minecraft.core.world.generate.feature.WorldFeatureFlowers;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneA;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneB;
import net.minecraft.core.world.generate.feature.WorldFeatureGrassPatch;
import net.minecraft.core.world.generate.feature.WorldFeatureInterface;
import net.minecraft.core.world.generate.feature.WorldFeatureLabyrinth;
import net.minecraft.core.world.generate.feature.WorldFeatureLake;
import net.minecraft.core.world.generate.feature.WorldFeatureLiquid;
import net.minecraft.core.world.generate.feature.WorldFeatureMeadow;
import net.minecraft.core.world.generate.feature.WorldFeatureMudPatch;
import net.minecraft.core.world.generate.feature.WorldFeatureNetherLava;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;
import net.minecraft.core.world.generate.feature.WorldFeaturePermaice;
import net.minecraft.core.world.generate.feature.WorldFeaturePumice;
import net.minecraft.core.world.generate.feature.WorldFeaturePumpkin;
import net.minecraft.core.world.generate.feature.WorldFeatureRichScorchedDirt;
import net.minecraft.core.world.generate.feature.WorldFeatureSpinifexPatch;
import net.minecraft.core.world.generate.feature.WorldFeatureSponge;
import net.minecraft.core.world.generate.feature.WorldFeatureSugarCane;
import net.minecraft.core.world.generate.feature.WorldFeatureSugarCaneTall;
import net.minecraft.core.world.generate.feature.WorldFeatureTallGrass;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureCherryTreeFancy;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTree;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeCaatinga;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeCherry;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeEucalyptus;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeFancy;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeFancyRainforest;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreePalm;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeShapeSwamp;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeShrub;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeTaigaBushy;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeTaigaTall;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeTall;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeThorn;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTree;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeBamboo;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeCone;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeMangrove;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeNormal;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreePalm;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeProcedural;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeRainforest;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeRound;
import net.minecraft.core.world.generate.feature.tree.spooner.WorldFeatureSpoonerTreeStick;
import org.jetbrains.annotations.NotNull;

public class CommandHelper {
    public static final Map<String, Class<? extends WorldFeatureInterface>> WORLD_FEATURES = new HashMap<String, Class<? extends WorldFeatureInterface>>();
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> NO_SUGGESTIONS = (builder, consumer) -> builder.buildFuture();
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> SUGGEST_BLOCKS = (builder, consumer) -> {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (Block<?> block : Blocks.blocksList) {
            if (block == null) continue;
            CommandHelper.getStringToSuggest(block.getKey(), remaining).ifPresent(builder::suggest);
        }
        return builder.buildFuture();
    };

    public static CompletableFuture<Suggestions> suggest(String string, SuggestionsBuilder suggestionsBuilder) {
        String stringRemaining = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        if (CommandHelper.matchesSubStr(stringRemaining, string.toLowerCase(Locale.ROOT))) {
            suggestionsBuilder.suggest(string);
        }
        return suggestionsBuilder.buildFuture();
    }

    public static CompletableFuture<Suggestions> suggest(Iterable<String> iterable, SuggestionsBuilder suggestionsBuilder) {
        String string = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string2 : iterable) {
            if (!CommandHelper.matchesSubStr(string, string2.toLowerCase(Locale.ROOT))) continue;
            suggestionsBuilder.suggest(string2);
        }
        return suggestionsBuilder.buildFuture();
    }

    public static boolean matchesSubStr(String string, String string2) {
        int i = 0;
        while (!string2.startsWith(string, i)) {
            if ((i = string2.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Optional<String> getStringToSuggest(String checkedString, String input) {
        if (checkedString.toLowerCase(Locale.ROOT).startsWith(input.toLowerCase(Locale.ROOT))) {
            return Optional.of(checkedString);
        }
        if (checkedString.contains(":") && checkedString.length() - 1 >= checkedString.indexOf(58) + 1) {
            if (checkedString.toLowerCase(Locale.ROOT).substring(checkedString.indexOf(58) + 1).startsWith(input.toLowerCase(Locale.ROOT))) {
                return Optional.of(checkedString.substring(checkedString.indexOf(58) + 1));
            }
            return Optional.empty();
        }
        if (checkedString.contains(".") && checkedString.length() - 1 >= checkedString.indexOf(46) + 1 && checkedString.toLowerCase(Locale.ROOT).substring(checkedString.indexOf(46) + 1).startsWith(input.toLowerCase(Locale.ROOT))) {
            return Optional.of(checkedString.substring(checkedString.indexOf(46) + 1));
        }
        return Optional.empty();
    }

    public static boolean matchesKeyString(String checkedString, String input) {
        if (checkedString.equals(input)) {
            return true;
        }
        if (checkedString.contains(":") && checkedString.length() - 1 >= checkedString.indexOf(58) + 1) {
            return checkedString.substring(checkedString.indexOf(58) + 1).equals(input);
        }
        return checkedString.contains(".") && checkedString.length() - 1 >= checkedString.indexOf(46) + 1 && checkedString.substring(checkedString.indexOf(46) + 1).equals(input);
    }

    public static boolean matchesNamespaceId(NamespaceID namespaceID, String input) {
        if (input.contains(":")) {
            return namespaceID.toString().equalsIgnoreCase(input);
        }
        if (namespaceID.namespace().equals("minecraft")) {
            return namespaceID.value().equalsIgnoreCase(input);
        }
        return false;
    }

    public static String getEntityName(Entity entity) {
        return Entity.getNameFromEntity(entity, true);
    }

    public static int getVolume(CommandSource source, IntegerCoordinates first, IntegerCoordinates second) throws CommandSyntaxException {
        return (int)(MathHelper.abs(first.getX(source) - second.getX(source)) * MathHelper.abs(first.getY(source, true) - second.getY(source, true)) * MathHelper.abs(first.getZ(source) - second.getZ(source)));
    }

    public static float linearInterpolation(float factor, float min, float max) {
        return min + factor * (max - min);
    }

    public static boolean blockEntitiesAreEqual(CompoundTag first, CompoundTag second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        for (Map.Entry entry : ((Map)first.getValue()).entrySet()) {
            if (((String)entry.getKey()).equals("x") || ((String)entry.getKey()).equals("y") || ((String)entry.getKey()).equals("z") || ((Map)second.getValue()).containsKey(entry.getKey()) && (((Map)second.getValue()).get(entry.getKey()) == entry.getValue() || ((Tag)((Map)second.getValue()).get(entry.getKey())).equals(entry.getValue()) || ((Tag)((Map)second.getValue()).get(entry.getKey())).getValue().equals(((Tag)entry.getValue()).getValue()))) continue;
            return false;
        }
        for (Map.Entry entry : ((Map)second.getValue()).entrySet()) {
            if (((String)entry.getKey()).equals("x") || ((String)entry.getKey()).equals("y") || ((String)entry.getKey()).equals("z") || ((Map)first.getValue()).containsKey(entry.getKey()) && (((Map)first.getValue()).get(entry.getKey()) == entry.getValue() || ((Tag)((Map)first.getValue()).get(entry.getKey())).equals(entry.getValue()) || ((Tag)((Map)first.getValue()).get(entry.getKey())).getValue().equals(((Tag)entry.getValue()).getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void setTileEntity(WorldSource world, int x, int y, int z, CompoundTag tag) {
        if (tag == null || world.getTileEntity(x, y, z) == null) {
            return;
        }
        tag.putInt("x", x);
        tag.putInt("y", y);
        tag.putInt("z", z);
        world.getTileEntity(x, y, z).readFromNBT(tag);
    }

    public static void setTileEntity(WorldSource world, int x, int y, int z, TileEntity tileEntity) {
        CommandHelper.setTileEntity(world, x, y, z, CommandHelper.tagFrom(tileEntity));
    }

    public static CompoundTag tagFrom(TileEntity tileEntity) {
        CompoundTag tag = new CompoundTag();
        if (tileEntity != null) {
            tileEntity.writeToNBT(tag);
        }
        return tag;
    }

    public static void init() {
        CommandHelper.registerWorldFeatureClass(WorldFeatureAlgae.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureCactus.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureClay.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureDeadBush.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureDungeon.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureFire.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureFlowers.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureGlowstoneA.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureGlowstoneB.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureGrassPatch.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureLabyrinth.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureLake.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureLiquid.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureMeadow.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureMudPatch.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureNetherLava.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureOre.class);
        CommandHelper.registerWorldFeatureClass(WorldFeaturePermaice.class);
        CommandHelper.registerWorldFeatureClass(WorldFeaturePumice.class);
        CommandHelper.registerWorldFeatureClass(WorldFeaturePumpkin.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureRichScorchedDirt.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpinifexPatch.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSponge.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSugarCane.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSugarCaneTall.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTallGrass.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureCherryTreeFancy.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTree.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeCaatinga.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeCherry.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeEucalyptus.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeFancy.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeFancyRainforest.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreePalm.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeShapeSwamp.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeShrub.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeTaigaBushy.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeTaigaTall.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeTall.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureTreeThorn.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTree.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTreeBamboo.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTreeCone.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTreeMangrove.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTreeNormal.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTreePalm.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTreeProcedural.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTreeRainforest.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTreeRound.class);
        CommandHelper.registerWorldFeatureClass(WorldFeatureSpoonerTreeStick.class);
    }

    public static <T extends WorldFeatureInterface> void registerWorldFeatureClass(@NotNull Class<T> tClass) {
        CommandHelper.registerWorldFeatureClass(tClass, tClass.getSimpleName().substring(12));
    }

    public static <T extends WorldFeatureInterface> void registerWorldFeatureClass(@NotNull Class<T> tClass, @NotNull String name) {
        WORLD_FEATURES.put(name, tClass);
    }
}

