/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import net.minecraft.core.data.gamerule.GameRuleCollection;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.config.spawning.SpawnerConfig;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.SettingNodesValues;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;

public class LevelDimensionDataWrapper
implements WorldConfigurationReader {
    @NotNull
    private final Dimension dimension;
    @NotNull
    private final LevelData levelData;
    @NotNull
    private final DimensionData dimensionData;

    public LevelDimensionDataWrapper(@NotNull Dimension dimension, @NotNull LevelData levelData, @NotNull DimensionData dimensionData) {
        this.dimension = dimension;
        this.levelData = levelData;
        this.dimensionData = dimensionData;
    }

    @Override
    public long getFinalNumericSeed() {
        return this.levelData.getRandomSeed();
    }

    @Override
    @NotNull
    public String getFinalWorldName() {
        return this.levelData.getWorldName();
    }

    @Override
    @NotNull
    public GameRuleCollection getGameRules() {
        return this.levelData.getGameRules();
    }

    @Override
    @NotNull
    public SpawnerConfig getSpawnerConfig() {
        return this.levelData.getSpawnerConfig();
    }

    @Override
    public boolean getCheatsEnabled() {
        return this.levelData.getCheatsEnabled();
    }

    @Override
    @NotNull
    public WorldType getWorldType(@NotNull Dimension dimension) {
        if (this.dimension.equals(dimension)) {
            return this.dimensionData.getWorldType();
        }
        throw new RuntimeException("Tried to read un-wrapped dimension data!");
    }

    @Override
    @NotNull
    public SettingNodesValues getDimensionSettings(@NotNull Dimension dimension) {
        if (this.dimension.equals(dimension)) {
            return this.dimensionData.getDimensionSettings();
        }
        throw new RuntimeException("Tried to read un-wrapped dimension data!");
    }
}

