/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.KeyedSettingNode;
import net.minecraft.core.world.settings.SettingNodeChildrenProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SettingNode {
    @Nullable
    public SettingNodeChildrenProvider getChildrenProvider();

    public boolean isVisible(@NotNull Dimension var1, @NotNull WorldConfigurationReader var2);

    public boolean areChildrenVisible(@NotNull Dimension var1, @NotNull WorldConfigurationReader var2);

    @NotNull
    public SettingNode withChild(@NotNull SettingNode var1);

    @Nullable
    default public KeyedSettingNode getChildByKey(@NotNull String key) {
        @Nullable SettingNodeChildrenProvider childrenProvider = this.getChildrenProvider();
        if (childrenProvider != null) {
            @Nullable KeyedSettingNode myChild = childrenProvider.getChildByKey(key);
            if (myChild != null) {
                return myChild;
            }
            for (SettingNode child : childrenProvider) {
                @Nullable KeyedSettingNode childsChild = child.getChildByKey(key);
                if (childsChild == null) continue;
                return childsChild;
            }
        }
        return null;
    }
}

