/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.menu;

import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.crafting.ContainerListener;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.slot.Slot;
import org.jetbrains.annotations.NotNull;

public class MenuActivator
extends MenuAbstract {
    public static final int ID_SELECTOR = 0;
    public static final int ID_LOCKED_SLOTS = 1;
    public static final int ACTIVATOR_INVENTORY_SIZE = 9;
    public static final int ACTIVATOR_SLOTS_START = 0;
    public static final int INVENTORY_SLOTS_START = 9;
    public static final int HOTBAR_SLOTS_START = 36;
    public TileEntityActivator activator;
    private int selectorSlot;
    private int lockedSlots;

    public MenuActivator(Container container, TileEntityActivator activator) {
        int i;
        this.activator = activator;
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(activator, i, 8 + i * 18, 35));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot(container, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(container, i, 8 + i * 18, 142));
        }
        this.selectorSlot = 0;
        this.lockedSlots = 0;
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        for (ContainerListener crafter : this.containerListeners) {
            if (this.selectorSlot != this.activator.stackSelector) {
                crafter.updateCraftingInventoryInfo(this, 0, this.activator.stackSelector);
            }
            if (this.lockedSlots == this.activator.lockedSlotBitSet) continue;
            crafter.updateCraftingInventoryInfo(this, 1, this.activator.lockedSlotBitSet);
        }
        this.selectorSlot = this.activator.stackSelector;
        this.lockedSlots = this.activator.lockedSlotBitSet;
    }

    @Override
    public void setData(int id, int value) {
        if (id == 0) {
            this.activator.stackSelector = value;
        } else if (id == 1) {
            this.activator.lockedSlotBitSet = (short)value;
        }
    }

    @Override
    public ItemStack clicked(@NotNull InventoryAction action, int @NotNull [] args2, @NotNull Player player) {
        if (action == InventoryAction.LOCK) {
            this.activator.lockSlot(args2[0], !this.activator.locked(args2[0]));
            return null;
        }
        return super.clicked(action, args2, player);
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return this.activator.stillValid(player);
    }

    @Override
    public IntList getMoveSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        if (slot.index >= 0 && slot.index < 9) {
            return this.getSlots(0, 9, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.index >= 9 && slot.index < 36) {
                return this.getSlots(9, 27, false);
            }
            if (slot.index >= 36) {
                return this.getSlots(36, 9, false);
            }
        }
        if (action == InventoryAction.MOVE_SIMILAR && slot.index >= 9) {
            return this.getSlots(9, 36, false);
        }
        return null;
    }

    @Override
    public IntList getTargetSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        if (slot.index >= 9 && slot.index < 9) {
            return this.getSlots(9, 36, false);
        }
        return this.getSlots(0, 9, false);
    }
}

