/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.container;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.enums.IArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.player.inventory.InventorySorter;
import net.minecraft.core.player.inventory.container.Container;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerInventory
implements Container {
    public static final int MAIN_INVENTORY_SIZE = 36;
    public static final int ARMOR_INVENTORY_SIZE = HumanArmorShape.values().length;
    public static final int HOTBAR_SIZE = 9;
    private static final int NBT_ARMOR_SLOT_OFFSET = 100;
    @NotNull
    public final Player player;
    public final @Nullable ItemStack @NotNull [] mainInventory = new ItemStack[36];
    public final @Nullable ItemStack @NotNull [] armorInventory = new ItemStack[ARMOR_INVENTORY_SIZE];
    private int currentSlot = 0;
    @Nullable
    private ItemStack heldItem = null;
    private int hotbarOffset = 0;

    public ContainerInventory(@NotNull Player player) {
        this.player = player;
    }

    @Override
    @Nullable
    public ItemStack getItem(int slot) {
        @Nullable ItemStack @NotNull [] inventory = this.mainInventory;
        if (slot >= 36) {
            inventory = this.armorInventory;
            slot -= 36;
        }
        return inventory[slot];
    }

    @Override
    public void setItem(int slot, @Nullable ItemStack stack) {
        @Nullable ItemStack @NotNull [] inventory = this.mainInventory;
        if (slot >= 36) {
            inventory = this.armorInventory;
            slot -= 36;
        }
        inventory[slot] = stack;
    }

    public int getHotbarOffset() {
        return this.hotbarOffset;
    }

    public void setHotbarOffset(int offset, boolean overrideLock) {
        if (!overrideLock && this.currentSlotLocked()) {
            return;
        }
        this.hotbarOffset = offset;
    }

    @Nullable
    public ItemStack getCurrentItem() {
        if (this.currentSlot >= this.hotbarOffset && this.currentSlot < this.hotbarOffset + 9) {
            return this.mainInventory[this.currentSlot];
        }
        return null;
    }

    public int setCurrentItem(@Nullable ItemStack stack) {
        if (this.currentSlotLocked()) {
            return this.currentSlot;
        }
        if (stack != null) {
            if (stack.itemID < Blocks.blocksList.length ? Objects.requireNonNull(Blocks.blocksList[stack.itemID]).hasTag(BlockTags.NOT_IN_CREATIVE_MENU) : Objects.requireNonNull(Item.itemsList[stack.itemID]).hasTag(ItemTags.NOT_IN_CREATIVE_MENU)) {
                return this.currentSlot;
            }
            for (int i = this.hotbarOffset; i < this.hotbarOffset + 9; ++i) {
                @Nullable ItemStack hotbarStack = this.mainInventory[i];
                if (hotbarStack == null || hotbarStack.itemID != stack.itemID) continue;
                this.currentSlot = i;
                return this.currentSlot;
            }
        }
        this.mainInventory[this.currentSlot] = stack;
        return this.currentSlot;
    }

    public int getCurrentSlot() {
        return this.currentSlot;
    }

    public void setCurrentSlot(int slot, boolean overrideLock) {
        if (!overrideLock && this.currentSlotLocked()) {
            return;
        }
        this.currentSlot = slot;
    }

    public void setHeldItemStack(@Nullable ItemStack itemstack) {
        this.heldItem = itemstack;
        if (itemstack != null && itemstack.stackSize <= 0) {
            this.heldItem = null;
        }
    }

    @Nullable
    public ItemStack getHeldItemStack() {
        return this.heldItem;
    }

    private int getFirstSlotContaining(int itemId) {
        for (int i = 0; i < this.mainInventory.length; ++i) {
            @Nullable ItemStack stack = this.mainInventory[i];
            if (stack == null || stack.itemID != itemId) continue;
            return i;
        }
        return -1;
    }

    public void insertItem(@NotNull ItemStack stackToAdd, boolean useHotbarOffset) {
        if (!this.player.getGamemode().canInteract()) {
            return;
        }
        for (int stage = 0; stage < 2; ++stage) {
            for (int i = 0; i < this.mainInventory.length; ++i) {
                int slotId;
                int n = slotId = useHotbarOffset ? (i + this.hotbarOffset) % this.mainInventory.length : i;
                if (this.locked(slotId)) continue;
                ItemStack stackInSlot = this.mainInventory[slotId];
                if (stage == 0) {
                    if (stackInSlot != null && stackInSlot.canStackWith(stackToAdd)) {
                        transferAmount = Math.min(stackToAdd.stackSize, stackInSlot.getMaxStackSize() - stackInSlot.stackSize);
                        if ((transferAmount = Math.min(transferAmount, stackToAdd.getMaxStackSize())) == 0) continue;
                        stackInSlot.stackSize += transferAmount;
                        stackToAdd.stackSize -= transferAmount;
                        stackInSlot.animationsToGo = 5;
                    }
                } else if (stage == 1 && stackInSlot == null) {
                    transferAmount = Math.min(stackToAdd.stackSize, stackToAdd.getMaxStackSize());
                    @NotNull ItemStack stackCopy = stackToAdd.copy();
                    stackCopy.stackSize = transferAmount;
                    stackCopy.animationsToGo = 5;
                    this.mainInventory[slotId] = stackCopy;
                    stackToAdd.stackSize -= transferAmount;
                }
                if (stackToAdd.stackSize > 0) continue;
                return;
            }
        }
    }

    public void changeCurrentSlot(int offset) {
        if (this.currentSlotLocked()) {
            return;
        }
        if (offset > 0) {
            offset = 1;
        }
        if (offset < 0) {
            offset = -1;
        }
        this.currentSlot -= offset;
        while (this.currentSlot < this.hotbarOffset) {
            this.currentSlot += 9;
        }
        while (this.currentSlot >= this.hotbarOffset + 9) {
            this.currentSlot -= 9;
        }
    }

    public void decrementAnimations() {
        ItemStack stack;
        int i;
        for (i = 0; i < this.mainInventory.length; ++i) {
            stack = this.mainInventory[i];
            if (stack == null) continue;
            stack.updateAnimation(this.player.world, this.player, i, this.currentSlot == i);
        }
        for (i = 0; i < this.armorInventory.length; ++i) {
            stack = this.armorInventory[i];
            if (stack == null) continue;
            stack.updateAnimation(this.player.world, this.player, 100 + i, false);
        }
    }

    public boolean consumeInventoryItem(int itemId) {
        int slot = this.getFirstSlotContaining(itemId);
        if (slot < 0) {
            return false;
        }
        if (this.player.getGamemode().hasBlockConsumption()) {
            @NotNull ItemStack stack = Objects.requireNonNull(this.mainInventory[slot]);
            --stack.stackSize;
            if (stack.stackSize <= 0) {
                this.mainInventory[slot] = null;
            }
        }
        return true;
    }

    public boolean currentSlotLocked() {
        return this.player.getHeldObject() != null;
    }

    @Override
    public boolean locked(int slot) {
        return this.currentSlotLocked() && slot == this.currentSlot;
    }

    @Override
    @Nullable
    public ItemStack removeItem(int slot, int takeAmount) {
        ItemStack currentStack;
        @Nullable ItemStack @NotNull [] inventory = this.mainInventory;
        if (slot >= 36) {
            inventory = this.armorInventory;
            slot -= 36;
        }
        if ((currentStack = inventory[slot]) != null) {
            if (currentStack.stackSize <= takeAmount) {
                inventory[slot] = null;
                return currentStack;
            }
            @NotNull ItemStack otherHalf = currentStack.splitStack(takeAmount);
            if (currentStack.stackSize <= 0) {
                inventory[slot] = null;
            }
            return otherHalf;
        }
        return null;
    }

    @NotNull
    public ListTag save(@NotNull ListTag parentTag) {
        CompoundTag itemTag;
        ItemStack stack;
        int i;
        for (i = 0; i < this.mainInventory.length; ++i) {
            stack = this.mainInventory[i];
            if (stack == null) continue;
            itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)i);
            stack.writeToNBT(itemTag);
            parentTag.addTag(itemTag);
        }
        for (i = 0; i < this.armorInventory.length; ++i) {
            stack = this.armorInventory[i];
            if (stack == null) continue;
            itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)(i + 100));
            stack.writeToNBT(itemTag);
            parentTag.addTag(itemTag);
        }
        return parentTag;
    }

    public void load(@NotNull ListTag parentTag) {
        this.clear();
        for (int i = 0; i < parentTag.tagCount(); ++i) {
            @NotNull CompoundTag itemTag = (CompoundTag)parentTag.tagAt(i);
            int slot = itemTag.getByte("Slot") & 0xFF;
            @Nullable ItemStack stack = ItemStack.readItemStackFromNbt(itemTag);
            if (stack == null) continue;
            if (slot < 36) {
                this.mainInventory[slot] = stack;
            }
            if (slot < 100 || slot >= ARMOR_INVENTORY_SIZE + 100) continue;
            this.armorInventory[slot - 100] = stack;
        }
    }

    private void clear() {
        Arrays.fill(this.mainInventory, null);
        Arrays.fill(this.armorInventory, null);
    }

    @Override
    public int getContainerSize() {
        return 36 + ARMOR_INVENTORY_SIZE;
    }

    @Override
    @NotNull
    public String getNameTranslationKey() {
        return "container.inventory.name";
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Nullable
    public ItemStack armorItemInSlot(@NotNull IArmorShape shape) {
        return this.armorInventory[shape.getSlotIndex()];
    }

    public int getTotalArmorPoints() {
        float armorDurability = 0.0f;
        float maxDurability = 0.0f;
        for (ItemStack stack : this.armorInventory) {
            if (stack == null || !(stack.getItem() instanceof IArmorItem)) continue;
            Item armor = stack.getItem();
            maxDurability += (float)armor.getMaxDamage();
            armorDurability += (float)(armor.getMaxDamage() - stack.getMetadata());
        }
        return (int)(20.0f * (armorDurability / maxDurability));
    }

    public void dropAllItems() {
        int i;
        for (i = 0; i < this.mainInventory.length; ++i) {
            @Nullable ItemStack stack = this.mainInventory[i];
            if (stack == null) continue;
            this.player.dropItem(stack, true);
            this.mainInventory[i] = null;
        }
        for (i = 0; i < ARMOR_INVENTORY_SIZE; ++i) {
            if (this.armorInventory[i] == null) continue;
            this.player.dropItem(this.armorInventory[i], true);
            this.armorInventory[i] = null;
        }
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        if (this.player.removed) {
            return false;
        }
        return player.distanceToSqr(this.player) <= 64.0;
    }

    public boolean containsItem(@NotNull ItemStack stack) {
        for (ItemStack inventoryStack : this.armorInventory) {
            if (inventoryStack == null || !inventoryStack.isStackEqual(stack)) continue;
            return true;
        }
        for (ItemStack inventoryStack : this.mainInventory) {
            if (inventoryStack == null || !inventoryStack.isStackEqual(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sort() {
        InventorySorter.sortInventory(this.mainInventory, 9, 35);
    }

    public void transferAllContents(@NotNull ContainerInventory inventory) {
        int i;
        for (i = 0; i < this.mainInventory.length; ++i) {
            this.mainInventory[i] = inventory.mainInventory[i];
            inventory.mainInventory[i] = null;
        }
        for (i = 0; i < this.armorInventory.length; ++i) {
            this.armorInventory[i] = inventory.armorInventory[i];
            inventory.armorInventory[i] = null;
        }
    }
}

