/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.List;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.MobButterfly;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemPlaceable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class ItemJar
extends ItemPlaceable {
    protected ItemJar(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id, Blocks.JAR_GLASS);
        this.setMaxStackSize(64);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (player != null && player.isSneaking()) {
            return super.onUseOnBlock(selfStack, world, player, blockPos, side, xHit, yHit);
        }
        if (player != null) {
            int count = selfStack.stackSize;
            ItemStack used = this.onUse(selfStack, world, player);
            if (used != null && used.stackSize != count) {
                return true;
            }
        }
        return super.onUseOnBlock(selfStack, world, player, blockPos, side, xHit, yHit);
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        if (player.isSneaking()) {
            return selfStack;
        }
        List<Entity> list = world.getEntitiesWithinAABBExcludingEntity(player, MathHelper.aabbGrow(player.bb, 2.0, 2.0, 2.0, new AABBd()));
        for (Entity entity : list) {
            if (entity instanceof MobFireflyCluster) {
                MobFireflyCluster fireflyCluster = (MobFireflyCluster)entity;
                MobFireflyCluster.FireflyColor colour = fireflyCluster.getColor();
                boolean didFillJar = colour == MobFireflyCluster.FireflyColor.BLUE ? ItemJar.fillJar(player, new ItemStack(Items.LANTERN_FIREFLY_BLUE, 1)) : (colour == MobFireflyCluster.FireflyColor.ORANGE ? ItemJar.fillJar(player, new ItemStack(Items.LANTERN_FIREFLY_ORANGE, 1)) : (colour == MobFireflyCluster.FireflyColor.RED ? ItemJar.fillJar(player, new ItemStack(Items.LANTERN_FIREFLY_RED, 1)) : ItemJar.fillJar(player, new ItemStack(Items.LANTERN_FIREFLY_GREEN, 1))));
                if (!world.isClientSide && didFillJar) {
                    fireflyCluster.setFireflyCount(fireflyCluster.getFireflyCount() - 1);
                    if (fireflyCluster.getFireflyCount() <= 0) {
                        fireflyCluster.remove();
                    }
                }
                return selfStack;
            }
            if (!(entity instanceof MobButterfly)) continue;
            MobButterfly butterfly = (MobButterfly)entity;
            MobButterfly.ButterflyEntry color = (MobButterfly.ButterflyEntry)MobButterfly.colorEntries.get(butterfly.getColor());
            boolean didFillJar = ItemJar.fillJar(player, new ItemStack(color.jarItem.get(), 1));
            if (!world.isClientSide && didFillJar) {
                butterfly.remove();
            }
            return selfStack;
        }
        return selfStack;
    }

    public static boolean fillJar(@NotNull Player player, @NotNull ItemStack itemToGive) {
        ItemStack currentItem = player.inventory.getCurrentItem();
        if (currentItem == null || currentItem.stackSize <= 1) {
            player.inventory.setItem(player.inventory.getCurrentSlot(), itemToGive);
        } else {
            player.inventory.insertItem(itemToGive, true);
        }
        if (itemToGive.stackSize < 1) {
            player.swingItem();
            player.inventory.getCurrentItem().consumeItem(player);
            return true;
        }
        return false;
    }
}

