/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeaturePillar
extends WorldFeature {
    private static final int MAX_RADIUS = 8;
    private static final int CIRCLE_SCALE = 4;
    private final int blockId;
    private final boolean doLava;
    private boolean[] buffer = new boolean[WorldFeaturePillar.diameter(8) * WorldFeaturePillar.diameter(8)];

    private static int diameter(int radius) {
        return radius * 2 + 1;
    }

    public WorldFeaturePillar(int blockId, boolean doLava) {
        this.blockId = blockId;
        this.doLava = doLava;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int y0 = y;
        while (this.isEmpty(world, x, y0, z)) {
            --y0;
        }
        int y1 = y;
        while (this.isEmpty(world, x, y1, z)) {
            ++y1;
        }
        int length = (y1 += 5) - (y0 -= 5);
        float r = random.nextFloat();
        int initRadiusTop = 1 + (int)(r * 6.0f);
        r = random.nextFloat();
        int initRadiusBottom = initRadiusTop + (int)(r * (float)(8 - initRadiusTop));
        int initRadiusMin = (int)(r * (float)Math.min(initRadiusBottom, initRadiusTop) * 0.75f);
        int randomSkip = random.nextInt(8);
        if (randomSkip == 0) {
            initRadiusTop = 0;
            initRadiusMin = 0;
        } else if (randomSkip == 1) {
            initRadiusBottom = 0;
            initRadiusMin = 0;
        }
        float bufferedRadius = initRadiusBottom;
        this.bufferCircle(random, initRadiusBottom);
        for (int dy = 0; dy <= length; ++dy) {
            float radMod;
            float p = (float)dy / (float)length;
            if (randomSkip == 0 && p > 0.5f) break;
            if (randomSkip == 1 && p < 0.5f) continue;
            float lerpedRadius = MathHelper.lerp(initRadiusBottom, initRadiusTop, p);
            float currentRadius = (float)((int)(lerpedRadius * (radMod = (MathHelper.cos(2.0f * p * (float)Math.PI) / 2.0f + 0.5f) * 0.75f + 0.25f) * 4.0f)) / 4.0f;
            if (currentRadius < (float)initRadiusMin) {
                currentRadius = initRadiusMin;
            }
            if (currentRadius != bufferedRadius) {
                this.bufferCircle(random, currentRadius);
                bufferedRadius = currentRadius;
            }
            for (int dx = 0; dx < WorldFeaturePillar.diameter(8); ++dx) {
                for (int dz = 0; dz < WorldFeaturePillar.diameter(8); ++dz) {
                    if (!this.getBufferPoint(dx, dz)) continue;
                    world.setBlockWithNotify(x - 8 + dx, y0 + dy, z - 8 + dz, this.blockId);
                }
            }
        }
        if (this.doLava) {
            int largerRadius = Math.max(initRadiusTop, initRadiusBottom);
            int numFeatures = 8 + random.nextInt(20);
            for (int i = 0; i < numFeatures; ++i) {
                int rx = random.nextInt(WorldFeaturePillar.diameter(largerRadius));
                int rz = random.nextInt(WorldFeaturePillar.diameter(largerRadius));
                int ry = random.nextInt(length);
                if (world.getBlockId(x - largerRadius + rx, y0 + ry, z - largerRadius + rz) != Blocks.COBBLE_NETHERRACK.id()) continue;
                world.setBlockWithNotify(x - largerRadius + rx, y0 + ry, z - largerRadius + rz, Blocks.FLUID_LAVA_FLOWING.id());
                world.scheduledUpdatesAreImmediate = true;
                Blocks.FLUID_LAVA_FLOWING.updateTick(world, x - largerRadius + rx, y0 + ry, z - largerRadius + rz, random, false);
                world.scheduledUpdatesAreImmediate = false;
            }
        }
        return true;
    }

    private boolean isEmpty(World world, int x, int y, int z) {
        if (y < 0 || y >= world.getHeightBlocks()) {
            return false;
        }
        return !Blocks.solid[world.getBlockId(x, y, z)];
    }

    private void bufferCircle(Random rand, float r) {
        Arrays.fill(this.buffer, false);
        if ((double)r <= 0.5) {
            return;
        }
        int ir = (int)(r * 4.0f);
        int x1 = 9;
        int y1 = 9;
        int x = 0;
        int y = ir;
        int p = 1 - ir;
        this.plotPoints(9, 9, x / 4, y / 4);
        while (x < y) {
            p = p < 0 ? (p += 2 * x + 1) : (p += 2 * (++x - --y) + 1);
            this.plotPoints(9, 9, x / 4, y / 4);
        }
    }

    private void drawLine(int x0, int x1, int y, boolean value) {
        for (int x = x0; x <= x1; ++x) {
            this.setBufferPoint(x, y, value);
        }
    }

    private void plotPoints(int cx, int cy, int x, int y) {
        this.drawLine(cx - x, cx + x, cy - y, true);
        this.drawLine(cx - x, cx + x, cy + y, true);
        this.drawLine(cx - y, cx + y, cy - x, true);
        this.drawLine(cx - y, cx + y, cy + x, true);
    }

    private void setBufferPoint(int x, int y, boolean value) {
        this.buffer[x * WorldFeaturePillar.diameter((int)8) + y] = value;
    }

    private boolean getBufferPoint(int x, int y) {
        return this.buffer[x * WorldFeaturePillar.diameter(8) + y];
    }
}

