/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureCrystalCeiling
extends WorldFeature {
    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int x1 = x + random.nextInt(2) - random.nextInt(2);
        int z1 = z + random.nextInt(2) - random.nextInt(2);
        int yF = y;
        double heightMod = 5.0;
        int checksForGround = 0;
        boolean canGenerate = false;
        while (true) {
            int blockBelow = world.getBlockId(x1, yF + 1, z1);
            if (checksForGround > 64 || yF >= world.getHeightBlocks()) break;
            if (Blocks.solid[blockBelow]) {
                canGenerate = true;
                break;
            }
            ++yF;
            ++checksForGround;
        }
        double currentHeight = heightMod + (double)random.nextInt(10);
        if (canGenerate && world.isAirBlock(x1, yF, z1)) {
            for (int xi = x - 1; xi < x + 1; ++xi) {
                for (int zi = z - 1; zi < z + 1; ++zi) {
                    int yi = yF;
                    while ((double)yi > (double)yF - currentHeight) {
                        world.setBlock(xi, yi, zi, Blocks.CRYSTAL.id());
                        --yi;
                    }
                    currentHeight = currentHeight * 0.25 + (double)random.nextInt(2);
                }
            }
        }
        return true;
    }
}

