/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise.operator;

import net.minecraft.core.world.noise.Noise2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2dc;

public class Rotate2D<T extends Noise2D>
implements Noise2D {
    @NotNull
    protected final T noise;
    protected final double sin;
    protected final double cos;

    public Rotate2D(@NotNull T noise, double yRot) {
        this.noise = noise;
        this.sin = Math.sin(yRot);
        this.cos = Math.cos(yRot);
    }

    @Override
    @NotNull
    public Vector2dc getRange2D() {
        return this.noise.getRange2D();
    }

    @Override
    public double getValue(double x, double z) {
        return this.noise.getValue(x * this.cos + z * this.sin, z * this.cos - x * this.sin);
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        throw new UnsupportedOperationException("Not implemented!");
    }
}

