/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public abstract class BlockLogicRotatable
extends BlockLogic {
    public static final int MASK_DIRECTION = 7;

    public BlockLogicRotatable(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
    }

    @NotNull
    public static Direction getDirectionFromMeta(int meta) {
        return Direction.getDirectionById(meta & 7);
    }

    public static int setDirection(int meta, Direction direction) {
        return meta & 0xFFFFFFF8 | direction.getId();
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        world.setBlockDataNotify(tilePos, mob.getHorizontalPlacementDirection(side).getOpposite().getId());
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        if (!side.isHorizontal()) {
            side = Side.SOUTH;
        }
        world.setBlockDataNotify(tilePos, BlockLogicRotatable.setDirection(0, side.getDirection()));
    }

    public static void setDefaultDirection(@NotNull World world, @NotNull TilePosc tilePos) {
        if (world.isClientSide) {
            return;
        }
        TilePos queryPos = new TilePos();
        @NotNull Block<?> bN = world.getBlockType(tilePos.north(queryPos));
        @NotNull Block<?> bS = world.getBlockType(tilePos.south(queryPos));
        @NotNull Block<?> bW = world.getBlockType(tilePos.west(queryPos));
        @NotNull Block<?> bE = world.getBlockType(tilePos.east(queryPos));
        Direction direction = Direction.NORTH;
        if (bN.solid() && !bS.solid()) {
            direction = Direction.SOUTH;
        }
        if (bS.solid() && !bN.solid()) {
            direction = Direction.NORTH;
        }
        if (bW.solid() && !bE.solid()) {
            direction = Direction.EAST;
        }
        if (bE.solid() && !bW.solid()) {
            direction = Direction.WEST;
        }
        world.setBlockDataNotify(tilePos, BlockLogicRotatable.setDirection(world.getBlockData(tilePos), direction));
    }
}

