/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;

public class PacketPlayerConfig
extends Packet {
    public int entityId;
    public short config;

    public PacketPlayerConfig() {
    }

    public PacketPlayerConfig(Player.PlayerConfig config) {
        this.entityId = -1;
        this.config = config.config;
    }

    public PacketPlayerConfig(int entityId, Player.PlayerConfig config) {
        this.entityId = entityId;
        this.config = config.config;
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.entityId = dis.readInt();
        this.config = dis.readShort();
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityId);
        dos.writeShort(this.config);
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handlePlayerConfig(this);
    }

    @Override
    public int getEstimatedSize() {
        return 5;
    }
}

