/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.lighting;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.lighting.LightingEngine;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LightingEngineLegacy
implements LightingEngine {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<LightUpdate> lightingToUpdate = new ObjectArrayList<LightUpdate>();
    private int lightingUpdatesCounter = 0;
    private int lightingUpdatesScheduled = 0;
    @NotNull
    protected final World world;

    public LightingEngineLegacy(@NotNull World world) {
        this.world = world;
    }

    @Override
    public boolean updatingLighting() {
        if (this.lightingUpdatesCounter >= 50) {
            return false;
        }
        ++this.lightingUpdatesCounter;
        try {
            for (int i = 499; !this.lightingToUpdate.isEmpty() && i >= 0; --i) {
                this.lightingToUpdate.remove(this.lightingToUpdate.size() - 1).performLightUpdate(this, this.world);
                if (i != 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            --this.lightingUpdatesCounter;
        }
    }

    @Override
    public int pendingUpdates() {
        return this.lightingToUpdate.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleLightingUpdate(LightLayer layer, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.world.getWorldType().hasCeiling() && layer == LightLayer.Sky) {
            return;
        }
        ++this.lightingUpdatesScheduled;
        try {
            if (this.lightingUpdatesScheduled == 50) {
                return;
            }
            int centerX = (maxX + minX) / 2;
            int centerZ = (maxZ + minZ) / 2;
            if (!this.world.isBlockLoaded(centerX, 0, centerZ)) {
                return;
            }
            if (this.world.getChunkFromBlockCoords(centerX, centerZ).isChunkEmpty()) {
                return;
            }
            int numLightingUpdates = this.lightingToUpdate.size();
            if (numLightingUpdates > 5) {
                numLightingUpdates = 5;
            }
            for (int i = 0; i < numLightingUpdates; ++i) {
                LightUpdate lightUpdate = this.lightingToUpdate.get(this.lightingToUpdate.size() - i - 1);
                if (lightUpdate.layer != layer || !lightUpdate.expandToContain(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return;
            }
            this.lightingToUpdate.add(new LightUpdate(layer, minX, minY, minZ, maxX, maxY, maxZ));
            if (this.lightingToUpdate.size() > 1000000) {
                LOGGER.warn("More than 1000000 updates, dropping first 500000 lighting updates");
                this.lightingToUpdate.subList(0, 500000).clear();
            }
        }
        finally {
            --this.lightingUpdatesScheduled;
        }
    }

    protected static class LightUpdate {
        public final LightLayer layer;
        public int minX;
        public int minY;
        public int minZ;
        public int maxX;
        public int maxY;
        public int maxZ;

        public LightUpdate(LightLayer layer, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.layer = layer;
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public void performLightUpdate(LightingEngine lightingEngine, World world) {
            int sizeX = this.maxX - this.minX + 1;
            int sizeY = this.maxY - this.minY + 1;
            int sizeZ = this.maxZ - this.minZ + 1;
            int area = sizeX * sizeY * sizeZ;
            if (area > 256 * world.getHeightBlocks()) {
                LOGGER.warn("Light too large, skipping!");
                return;
            }
            for (int x = this.minX; x <= this.maxX; ++x) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    Chunk chunk;
                    if (!world.isBlockLoaded(x, 0, z) || (chunk = world.getChunkFromBlockCoords(x, z)).isChunkEmpty()) continue;
                    if (this.minY < 0) {
                        this.minY = 0;
                    }
                    if (this.maxY >= world.getHeightBlocks()) {
                        this.maxY = world.getHeightBlocks() - 1;
                    }
                    for (int y = this.minY; y <= this.maxY; ++y) {
                        int newLightValue;
                        int savedLightValue = world.getSavedLightValue(this.layer, x, y, z);
                        int blockId = world.getBlockId(x, y, z);
                        int blockLightOpacity = Blocks.lightBlock[blockId];
                        if (blockLightOpacity == 0) {
                            blockLightOpacity = 1;
                        }
                        int blockLightValue = 0;
                        if (this.layer == LightLayer.Sky) {
                            if (world.canExistingBlockSeeTheSky(x, y, z)) {
                                blockLightValue = 15;
                            }
                        } else if (this.layer == LightLayer.Block) {
                            blockLightValue = Blocks.lightEmission[blockId];
                        }
                        if (blockLightOpacity >= 15 && blockLightValue == 0) {
                            newLightValue = 0;
                        } else {
                            int lightNegX = world.getSavedLightValue(this.layer, x - 1, y, z);
                            int lightPosX = world.getSavedLightValue(this.layer, x + 1, y, z);
                            int lightNegY = world.getSavedLightValue(this.layer, x, y - 1, z);
                            int lightPosY = world.getSavedLightValue(this.layer, x, y + 1, z);
                            int lightNegZ = world.getSavedLightValue(this.layer, x, y, z - 1);
                            int lightPosZ = world.getSavedLightValue(this.layer, x, y, z + 1);
                            newLightValue = lightNegX;
                            if (lightPosX > newLightValue) {
                                newLightValue = lightPosX;
                            }
                            if (lightNegY > newLightValue) {
                                newLightValue = lightNegY;
                            }
                            if (lightPosY > newLightValue) {
                                newLightValue = lightPosY;
                            }
                            if (lightNegZ > newLightValue) {
                                newLightValue = lightNegZ;
                            }
                            if (lightPosZ > newLightValue) {
                                newLightValue = lightPosZ;
                            }
                            if ((newLightValue -= blockLightOpacity) < 0) {
                                newLightValue = 0;
                            }
                            if (blockLightValue > newLightValue) {
                                newLightValue = blockLightValue;
                            }
                        }
                        if (savedLightValue == newLightValue) continue;
                        world.setLightValue(this.layer, x, y, z, newLightValue);
                        int propagatedLightValue = newLightValue - 1;
                        if (propagatedLightValue < 0) {
                            propagatedLightValue = 0;
                        }
                        LightUpdate.neighborLightPropagationChanged(lightingEngine, world, this.layer, x - 1, y, z, propagatedLightValue);
                        LightUpdate.neighborLightPropagationChanged(lightingEngine, world, this.layer, x, y - 1, z, propagatedLightValue);
                        LightUpdate.neighborLightPropagationChanged(lightingEngine, world, this.layer, x, y, z - 1, propagatedLightValue);
                        if (x + 1 >= this.maxX) {
                            LightUpdate.neighborLightPropagationChanged(lightingEngine, world, this.layer, x + 1, y, z, propagatedLightValue);
                        }
                        if (y + 1 >= this.maxY) {
                            LightUpdate.neighborLightPropagationChanged(lightingEngine, world, this.layer, x, y + 1, z, propagatedLightValue);
                        }
                        if (z + 1 < this.maxZ) continue;
                        LightUpdate.neighborLightPropagationChanged(lightingEngine, world, this.layer, x, y, z + 1, propagatedLightValue);
                    }
                }
            }
        }

        private static void neighborLightPropagationChanged(LightingEngine lightingEngine, World world, LightLayer lightLayer, int x, int y, int z, int lightValue) {
            int i1;
            if (world.getWorldType().hasCeiling() && lightLayer == LightLayer.Sky) {
                return;
            }
            if (!world.isBlockLoaded(x, y, z)) {
                return;
            }
            if (lightLayer == LightLayer.Sky) {
                if (world.canExistingBlockSeeTheSky(x, y, z)) {
                    lightValue = 15;
                }
            } else if (lightLayer == LightLayer.Block && Blocks.lightEmission[i1 = world.getBlockId(x, y, z)] > lightValue) {
                lightValue = Blocks.lightEmission[i1];
            }
            if (world.getSavedLightValue(lightLayer, x, y, z) != lightValue) {
                lightingEngine.scheduleLightingUpdate(lightLayer, x, y, z, x, y, z);
            }
        }

        public boolean expandToContain(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            if (minX >= this.minX && minY >= this.minY && minZ >= this.minZ && maxX <= this.maxX && maxY <= this.maxY && maxZ <= this.maxZ) {
                return true;
            }
            boolean range = true;
            if (minX >= this.minX - 1 && minY >= this.minY - 1 && minZ >= this.minZ - 1 && maxX <= this.maxX + 1 && maxY <= this.maxY + 1 && maxZ <= this.maxZ + 1) {
                int oldSizeZ;
                int oldSizeY;
                int oldSizeX;
                int oldArea;
                int newSizeZ;
                int newSizeY;
                int newSizeX;
                int newArea;
                if (minX > this.minX) {
                    minX = this.minX;
                }
                if (minY > this.minY) {
                    minY = this.minY;
                }
                if (minZ > this.minZ) {
                    minZ = this.minZ;
                }
                if (maxX < this.maxX) {
                    maxX = this.maxX;
                }
                if (maxY < this.maxY) {
                    maxY = this.maxY;
                }
                if (maxZ < this.maxZ) {
                    maxZ = this.maxZ;
                }
                if ((newArea = (newSizeX = maxX - minX) * (newSizeY = maxY - minY) * (newSizeZ = maxZ - minZ)) - (oldArea = (oldSizeX = this.maxX - this.minX) * (oldSizeY = this.maxY - this.minY) * (oldSizeZ = this.maxZ - this.minZ)) <= 2) {
                    this.minX = minX;
                    this.minY = minY;
                    this.minZ = minZ;
                    this.maxX = maxX;
                    this.maxY = maxY;
                    this.maxZ = maxZ;
                    return true;
                }
            }
            return false;
        }
    }
}

