/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.zip.DataFormatException;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.KeyedSettingNode;
import net.minecraft.core.world.settings.SettingNode;
import net.minecraft.core.world.settings.ValueSettingNode;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SettingNodesValues {
    @NotNull
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private final SettingNode rootNode;
    @NotNull
    private final Dimension dimension;
    @NotNull
    private final @NotNull Map<@NotNull ValueSettingNode<?>, @NotNull Object> keyedNodeValues = new Object2ObjectOpenHashMap();
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull ValueSettingNode<?>> nodesByKey = new Object2ObjectOpenHashMap();
    private boolean notificationsSuppressed = false;
    @Nullable
    private WorldConfiguration.ChangeListener changeListener;

    @NotNull
    public static CompoundTag serialize(@NotNull SettingNodesValues values2, @NotNull CompoundTag out) {
        values2.keyedNodeValues.forEach((key, value) -> {
            @NotNull ValueSettingNode nodeAsObject = key;
            out.put(key.getKey(), nodeAsObject.serializeValue(value));
        });
        return out;
    }

    @NotNull
    public static SettingNodesValues deserialize(@NotNull SettingNode rootNode, @NotNull Dimension dimension, @NotNull CompoundTag in) {
        @NotNull SettingNodesValues settingNodesValues = new SettingNodesValues(rootNode, dimension);
        for (Tag<?> tag : in.getValues()) {
            @NotNull String tagName = tag.getTagName();
            @Nullable KeyedSettingNode node = rootNode.getChildByKey(tagName);
            if (!(node instanceof ValueSettingNode)) continue;
            @NotNull ValueSettingNode objectValueNode = (ValueSettingNode)node;
            try {
                @Nullable T value = objectValueNode.deserializeValue(tag);
                settingNodesValues.setNodeValue(objectValueNode, value);
            }
            catch (DataFormatException e) {
                LOGGER.warn("Threw exception while deserializing setting node", e);
            }
        }
        return settingNodesValues;
    }

    public SettingNodesValues(@NotNull SettingNode rootNode, @NotNull Dimension dimension) {
        this.rootNode = rootNode;
        this.dimension = dimension;
    }

    public void setChangeListener(@Nullable WorldConfiguration.ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    private void notifyChanged() {
        if (this.changeListener != null && !this.notificationsSuppressed) {
            this.changeListener.onChanged();
        }
    }

    public void setAll(@NotNull SettingNodesValues src) {
        this.keyedNodeValues.clear();
        this.nodesByKey.clear();
        for (ValueSettingNode<?> node : src.keyedNodeValues.keySet()) {
            this.keyedNodeValues.put(node, Objects.requireNonNull(src.keyedNodeValues.get(node)));
            this.nodesByKey.put(node.getKey(), node);
        }
    }

    @NotNull
    public SettingNode getRootNode() {
        return this.rootNode;
    }

    @NotNull
    public <T> T getNodeValue(@NotNull ValueSettingNode<T> node, @NotNull WorldConfigurationReader worldConfigurationReader) {
        if (!this.keyedNodeValues.containsKey(node)) {
            this.keyedNodeValues.put(node, node.getDefaultValue(this.dimension, worldConfigurationReader));
        }
        return (T)Objects.requireNonNull(this.keyedNodeValues.get(node));
    }

    @NotNull
    public <T> T getNodeValueOr(@NotNull ValueSettingNode<T> node, @NotNull T or) {
        if (!this.keyedNodeValues.containsKey(node)) {
            return or;
        }
        return (T)Objects.requireNonNull(this.keyedNodeValues.get(node));
    }

    @NotNull
    public <T> T getNodeValue(@NotNull String key, @NotNull Class<T> valueClass, @NotNull WorldConfigurationReader worldConfigurationReader) {
        @Nullable ValueSettingNode node = this.nodesByKey.get(key);
        if (node == null) {
            @Nullable KeyedSettingNode keyedSettingNode = this.rootNode.getChildByKey(key);
            if (keyedSettingNode instanceof ValueSettingNode) {
                ValueSettingNode nodeByKeyFromRoot;
                node = nodeByKeyFromRoot = (ValueSettingNode)keyedSettingNode;
            } else {
                throw new IllegalArgumentException("Node does not have a value!");
            }
        }
        if (!valueClass.isAssignableFrom(node.getValueClass())) {
            throw new IllegalArgumentException("Node type " + node.getValueClass().getSimpleName() + " does not equal requested type " + valueClass.getSimpleName() + "!");
        }
        return (T)this.getNodeValue(node, worldConfigurationReader);
    }

    @NotNull
    public <T> T getNodeValueOr(@NotNull String key, @NotNull Class<T> valueClass, @NotNull T or) {
        @Nullable ValueSettingNode node = this.nodesByKey.get(key);
        if (node == null) {
            @Nullable KeyedSettingNode keyedSettingNode = this.rootNode.getChildByKey(key);
            if (keyedSettingNode instanceof ValueSettingNode) {
                ValueSettingNode nodeByKeyFromRoot;
                node = nodeByKeyFromRoot = (ValueSettingNode)keyedSettingNode;
            } else {
                throw new IllegalArgumentException("Node does not have a value!");
            }
        }
        if (!valueClass.isAssignableFrom(node.getValueClass())) {
            throw new IllegalArgumentException("Node type " + node.getValueClass().getSimpleName() + " does not equal requested type " + valueClass.getSimpleName() + "!");
        }
        return (T)this.getNodeValueOr(node, or);
    }

    public <T> void setNodeValue(@NotNull ValueSettingNode<T> node, @NotNull T value) {
        this.keyedNodeValues.put(node, value);
        this.nodesByKey.put(node.getKey(), node);
        this.notifyChanged();
    }

    public <T> void setNodeValue(@NotNull String key, @NotNull T value) {
        @Nullable ValueSettingNode node = this.nodesByKey.get(key);
        if (node == null) {
            @Nullable KeyedSettingNode keyedSettingNode = this.rootNode.getChildByKey(key);
            if (keyedSettingNode instanceof ValueSettingNode) {
                ValueSettingNode nodeByKeyFromRoot;
                node = nodeByKeyFromRoot = (ValueSettingNode)keyedSettingNode;
            } else {
                throw new IllegalArgumentException("Node does not have a value!");
            }
        }
        if (!value.getClass().isAssignableFrom(node.getValueClass())) {
            throw new IllegalArgumentException("Node type " + node.getValueClass().getSimpleName() + " does not equal requested type " + value.getClass().getSimpleName() + "!");
        }
        this.setNodeValue(node, value);
    }

    public void withNotificationsSuppressed(@NotNull @NotNull Consumer<@NotNull SettingNodesValues> consumer) {
        this.notificationsSuppressed = true;
        consumer.accept(this);
        this.notificationsSuppressed = false;
    }
}

