/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatValueFormatter;

final class DistanceValueFormatter
implements StatValueFormatter {
    public static double UNIT_CENTIMETER_TO_METER = 0.01;
    public static double UNIT_METER_TO_KILOMETER = 0.001;

    DistanceValueFormatter() {
    }

    @Override
    public String formatValue(int value) {
        double meters = (double)value * UNIT_CENTIMETER_TO_METER;
        double kilometers = meters * UNIT_METER_TO_KILOMETER;
        if (kilometers > 0.5) {
            return Stat.getDecimalFormat().format(kilometers) + " km";
        }
        if (meters > 0.5) {
            return Stat.getDecimalFormat().format(meters) + " m";
        }
        return value + " cm";
    }
}

