/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.NextTickListEntry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.ChunkSection;
import net.minecraft.core.world.chunk.MissingBlockFixer;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkPosc;
import net.minecraft.core.world.pos.ChunkSectionTilePos;
import net.minecraft.core.world.pos.ChunkTilePos;
import net.minecraft.core.world.pos.ChunkTilePosc;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;
import org.slf4j.Logger;

public class Chunk {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int CHUNK_SIZE_X = 16;
    public static final int CHUNK_MASK_X = 15;
    public static final int CHUNK_SHIFT_X = 4;
    public static final int CHUNK_SIZE_Z = 16;
    public static final int CHUNK_MASK_Z = 15;
    public static final int CHUNK_SHIFT_Z = 4;
    public static final int CHUNK_SECTIONS = 16;
    public static boolean isLit;
    public boolean isLoaded;
    @NotNull
    public final World world;
    public short @NotNull [] heightMap = new short[256];
    @NotNull
    public final ChunkPos pos;
    public long ticksOnUnload = -1L;
    @NotNull
    public final @NotNull Map<@NotNull ChunkTilePos, @NotNull TileEntity> tileEntityMap = new HashMap<ChunkTilePos, TileEntity>();
    public double @NotNull [] temperature = new double[256];
    public double @NotNull [] humidity = new double[256];
    public double @NotNull [] variety = new double[256];
    @NotNull
    public Int2ObjectMap<NextTickListEntry> tickList = new Int2ObjectArrayMap<NextTickListEntry>();
    public int averageBlockHeight;
    public boolean isTerrainPopulated = false;
    public boolean isModified = false;
    public boolean neverSave;
    public boolean hasEntities = false;
    public long lastSaveTime = 0L;
    @NotNull
    protected final @NotNull ChunkSection @NotNull [] sections = new ChunkSection[16];

    public Chunk(@NotNull World world, @NotNull ChunkPosc pos) {
        this.world = world;
        this.pos = new ChunkPos(pos);
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i] = new ChunkSection(this, i);
        }
    }

    @Deprecated
    public Chunk(@NotNull World world, int x, int z) {
        this(world, new ChunkPos(x, z));
    }

    public static int makeBlockIndex(@NotNull ChunkTilePosc chunkTilePos) {
        return chunkTilePos.y() * 16 * 16 + chunkTilePos.z() * 16 + chunkTilePos.x();
    }

    @Deprecated
    public static int makeBlockIndex(int x, int y, int z) {
        return y * 16 * 16 + z * 16 + x;
    }

    @NotNull
    public ChunkSection getSection(int index) {
        assert (index >= 0 && index < 16);
        return this.sections[index];
    }

    @NotNull
    public ChunkSection getSection(@NotNull ChunkTilePosc chunkTilePos) {
        return this.getSection(chunkTilePos.getSectionIndex());
    }

    public void init() {
        Arrays.fill(this.temperature, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.humidity, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.variety, Double.NEGATIVE_INFINITY);
    }

    public boolean isAtLocation(@NotNull ChunkPosc chunkPos) {
        return this.pos.equals(chunkPos);
    }

    @Deprecated
    public final boolean isAtLocation(int x, int z) {
        return x == this.pos.x && z == this.pos.z;
    }

    public int getHeightValue(int x, int z) {
        return this.heightMap[z * 16 + x];
    }

    private void setHeightValue(int x, int z, int y) {
        this.heightMap[z * 16 + x] = (short)y;
    }

    public void recalcHeightmapOnly() {
        int acc = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                for (y = 255; y > 0 && Blocks.lightBlock[this.getBlockID(x, y - 1, z)] == 0; --y) {
                }
                this.setHeightValue(x, z, y);
                acc += y;
            }
        }
        this.isModified = true;
        this.averageBlockHeight = acc / 256;
    }

    public void recalcHeightmapAndLightmap() {
        this.recalcHeightmapOnly();
        if (!this.world.getWorldType().hasCeiling()) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int skyLightValue = 15;
                    int lightY = 255;
                    do {
                        if ((skyLightValue -= Blocks.lightBlock[this.getBlockID(x, lightY, z) & 0x3FFF]) <= 0) continue;
                        this.setBrightness(LightLayer.Sky, x, lightY, z, skyLightValue);
                    } while (--lightY > 0 && skyLightValue > 0);
                }
            }
        }
        this.isModified = true;
    }

    public void checkForLightGaps() {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.lightGaps(x, z);
            }
        }
    }

    private void lightGaps(int x, int z) {
        int y = this.getHeightValue(x, z);
        int worldX = this.pos.x * 16 + x;
        int worldZ = this.pos.z * 16 + z;
        this.lightGap(worldX - 1, worldZ, y);
        this.lightGap(worldX + 1, worldZ, y);
        this.lightGap(worldX, worldZ - 1, y);
        this.lightGap(worldX, worldZ + 1, y);
    }

    private void lightGap(int x, int z, int y) {
        int blockHeight = this.world.getHeightValue(x, z);
        if (blockHeight > y) {
            this.world.scheduleLightingUpdate(LightLayer.Sky, x, y, z, x, blockHeight, z);
            this.isModified = true;
        } else if (blockHeight < y) {
            this.world.scheduleLightingUpdate(LightLayer.Sky, x, blockHeight, z, x, y, z);
            this.isModified = true;
        }
    }

    private void recalcHeight(@NotNull ChunkTilePosc tilePos) {
        int heightValue = this.getHeightValue(tilePos.x(), tilePos.z());
        @NotNull ChunkTilePos iPos = new ChunkTilePos(tilePos.x(), heightValue, tilePos.z());
        if (tilePos.y() > heightValue) {
            iPos.y = tilePos.y();
        }
        ChunkTilePos queryPos = new ChunkTilePos();
        while (iPos.y > 0 && Blocks.lightBlock[this.getBlockId(iPos.down(queryPos)) & 0x3FFF] == 0) {
            --iPos.y;
        }
        if (iPos.y == heightValue) {
            return;
        }
        this.world.markBlocksDirtyVertical(iPos.x, iPos.z, iPos.y, heightValue);
        this.setHeightValue(iPos.x, iPos.z, iPos.y);
        @NotNull TilePos worldPos = new TilePos(this.pos, tilePos);
        if (iPos.y < heightValue) {
            for (dy = iPos.y; dy < heightValue; ++dy) {
                this.setBrightness(LightLayer.Sky, iPos.x, dy, iPos.z, 15);
            }
        } else {
            this.world.scheduleLightingUpdate(LightLayer.Sky, new TilePos(worldPos.x, heightValue, worldPos.z), new TilePos(worldPos.x, iPos.y, worldPos.z));
            for (dy = heightValue; dy < iPos.y; ++dy) {
                this.setBrightness(LightLayer.Sky, iPos.x, dy, iPos.z, 0);
            }
        }
        int lightValue = 15;
        int lightY = iPos.y;
        while (iPos.y > 0 && lightValue > 0) {
            --iPos.y;
            int lightBlock = Blocks.lightBlock[this.getBlockId(iPos)];
            if (lightBlock == 0) {
                lightBlock = 1;
            }
            if ((lightValue -= lightBlock) < 0) {
                lightValue = 0;
            }
            this.setLightLevel(LightLayer.Sky, iPos, lightValue);
        }
        while (iPos.y > 0 && Blocks.lightBlock[this.getBlockId(iPos.down(queryPos))] == 0) {
            --iPos.y;
        }
        if (iPos.y != lightY) {
            this.world.scheduleLightingUpdate(LightLayer.Sky, new TilePos(worldPos.x - 1, iPos.y, worldPos.z - 1), new TilePos(worldPos.x + 1, lightY, worldPos.z + 1));
        }
        this.isModified = true;
    }

    public int getBlockId(@NotNull ChunkTilePosc tilePos) {
        if (!tilePos.inBounds()) {
            return 0;
        }
        return this.getSection(tilePos).getBlockId(new ChunkSectionTilePos(tilePos));
    }

    @Deprecated
    public final int getBlockID(int x, int y, int z) {
        return this.getBlockId(new ChunkTilePos(x, y, z));
    }

    @NotNull
    public Block<?> getBlock(@NotNull ChunkTilePosc tilePos) {
        return Blocks.getBlock(this.getBlockId(tilePos));
    }

    public boolean setBlockIdDataRaw(@NotNull ChunkTilePosc tilePos, int id, int data) {
        return this.setBlockIdData(tilePos, id, data, true);
    }

    public boolean setBlockIdData(@NotNull ChunkTilePosc tilePos, int id, int data) {
        return this.setBlockIdData(tilePos, id, data, false);
    }

    @Deprecated
    public final boolean setBlockIDWithMetadataRaw(int x, int y, int z, int id, int data) {
        return this.setBlockIdDataRaw(new ChunkTilePos(x, y, z), id, data);
    }

    private boolean setBlockIdData(@NotNull ChunkTilePosc tilePos, int id, int data, boolean raw) {
        if (!tilePos.inBounds()) {
            return false;
        }
        @NotNull ChunkSection section = this.getSection(tilePos);
        int heightValue = this.getHeightValue(tilePos.x(), tilePos.z());
        int currentId = section.getBlockId(new ChunkSectionTilePos(tilePos));
        int currentData = section.getData(new ChunkSectionTilePos(tilePos));
        @NotNull Block<?> currentBlock = Blocks.getBlock(currentId);
        @NotNull Block<?> newBlock = Blocks.getBlock(id);
        if (currentId == id && currentData == data) {
            return false;
        }
        section.setBlockId(new ChunkSectionTilePos(tilePos), id);
        section.setData(new ChunkSectionTilePos(tilePos), data);
        @NotNull TilePos worldPos = new TilePos(this.pos, tilePos);
        if (!raw && !this.world.isClientSide) {
            currentBlock.onRemoved(this.world, worldPos, currentData);
        }
        if (!this.world.getWorldType().hasCeiling()) {
            if (Blocks.lightBlock[id & 0x3FFF] != 0) {
                if (tilePos.y() >= heightValue) {
                    this.recalcHeight(tilePos.up(new ChunkTilePos()));
                }
            } else if (tilePos.y() == heightValue - 1) {
                this.recalcHeight(tilePos);
            }
            this.world.scheduleLightingUpdate(LightLayer.Sky, worldPos);
        }
        this.world.scheduleLightingUpdate(LightLayer.Block, worldPos);
        this.lightGaps(tilePos.x(), tilePos.z());
        if (!raw) {
            newBlock.onPlacedByWorld(this.world, worldPos);
        }
        this.isModified = true;
        return true;
    }

    @Deprecated
    public final boolean setBlockIDWithMetadata(int x, int y, int z, int id, int data) {
        return this.setBlockIdData(new ChunkTilePos(x, y, z), id, data);
    }

    public boolean setBlockId(@NotNull ChunkTilePosc tilePos, int id) {
        return this.setBlockIdData(tilePos, id, 0);
    }

    @Deprecated
    public final boolean setBlockID(int x, int y, int z, int id) {
        return this.setBlockId(new ChunkTilePos(x, y, z), id);
    }

    public int getBlockData(@NotNull ChunkTilePosc tilePos) {
        if (!tilePos.inBounds()) {
            return 0;
        }
        return this.getSection(tilePos).getData(new ChunkSectionTilePos(tilePos));
    }

    @Deprecated
    public final int getBlockMetadata(int x, int y, int z) {
        return this.getBlockData(new ChunkTilePos(x, y, z));
    }

    public boolean setBlockData(@NotNull ChunkTilePosc tilePos, int value) {
        if (!tilePos.inBounds()) {
            return false;
        }
        this.getSection(tilePos).setData(new ChunkSectionTilePos(tilePos), value);
        this.isModified = true;
        return true;
    }

    @Deprecated
    public final void setBlockMetadata(int x, int y, int z, int value) {
        this.setBlockData(new ChunkTilePos(x, y, z), value);
    }

    @Nullable
    public Biome getBlockBiome(@NotNull ChunkTilePosc tilePos) {
        if (!tilePos.inBounds()) {
            return null;
        }
        return this.getSection(tilePos).getBiome(new ChunkSectionTilePos(tilePos));
    }

    @Deprecated
    @Nullable
    public final Biome getBlockBiome(int x, int y, int z) {
        return this.getBlockBiome(new ChunkTilePos(x, y, z));
    }

    public boolean setBlockBiome(@NotNull ChunkTilePosc tilePos, @NotNull Biome biome) {
        if (!tilePos.inBounds()) {
            return false;
        }
        this.getSection(tilePos).setBiome(new ChunkSectionTilePos(tilePos), biome);
        this.isModified = true;
        return true;
    }

    @Deprecated
    public final boolean setBlockBiome(int x, int y, int z, @NotNull Biome biome) {
        return this.setBlockBiome(new ChunkTilePos(x, y, z), biome);
    }

    public double getBlockTemperature(@NotNull ChunkTilePosc tilePos) {
        if (!tilePos.inBounds()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.temperature[tilePos.x() * 16 + tilePos.z()];
    }

    @Deprecated
    public final double getBlockTemperature(int x, int z) {
        return this.getBlockTemperature(new ChunkTilePos(x, 0, z));
    }

    public void setBlockTemperature(@NotNull ChunkTilePosc tilePos, double temperature) {
        if (!tilePos.inBounds()) {
            return;
        }
        this.temperature[tilePos.x() * 16 + tilePos.z()] = temperature;
        this.isModified = true;
    }

    @Deprecated
    public final boolean setBlockTemperature(int x, int z, double temperature) {
        if (temperature == this.temperature[x * 16 + z]) {
            return false;
        }
        this.setBlockTemperature(new ChunkTilePos(x, 0, z), temperature);
        return true;
    }

    public double getBlockHumidity(@NotNull ChunkTilePosc tilePos) {
        if (!tilePos.inBounds()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.humidity[tilePos.x() * 16 + tilePos.z()];
    }

    @Deprecated
    public final double getBlockHumidity(int x, int z) {
        return this.getBlockHumidity(new ChunkTilePos(x, 0, z));
    }

    public void setBlockHumidity(@NotNull ChunkTilePosc tilePos, double humidity) {
        if (!tilePos.inBounds()) {
            return;
        }
        this.humidity[tilePos.x() * 16 + tilePos.z()] = humidity;
        this.isModified = true;
    }

    @Deprecated
    public final boolean setBlockHumidity(int x, int z, double humidity) {
        if (humidity == this.humidity[x * 16 + z]) {
            return false;
        }
        this.setBlockHumidity(new ChunkTilePos(x, 0, z), humidity);
        return true;
    }

    public double getBlockVariety(@NotNull ChunkTilePosc tilePos) {
        if (!tilePos.inBounds()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.variety[tilePos.x() * 16 + tilePos.z()];
    }

    @Deprecated
    public final double getBlockVariety(int x, int z) {
        return this.getBlockVariety(new ChunkTilePos(x, 0, z));
    }

    public void setBlockVariety(@NotNull ChunkTilePosc tilePos, double variety) {
        if (!tilePos.inBounds()) {
            return;
        }
        this.variety[tilePos.x() * 16 + tilePos.z()] = variety;
        this.isModified = true;
    }

    @Deprecated
    public final boolean setBlockVariety(int x, int z, double variety) {
        if (variety == this.variety[x * 16 + z]) {
            return false;
        }
        this.setBlockVariety(new ChunkTilePos(x, 0, z), variety);
        return true;
    }

    public int getLightLevel(@NotNull LightLayer lightLayer, @NotNull ChunkTilePosc tilePos) {
        if (!tilePos.inBounds()) {
            return 0;
        }
        return this.getSection(tilePos).getLightLevel(lightLayer, new ChunkSectionTilePos(tilePos));
    }

    public byte getLightIndex(@NotNull ChunkTilePosc tilePos) {
        if (!tilePos.inBounds()) {
            return 0;
        }
        return this.getSection(tilePos).getLightIndex(new ChunkSectionTilePos(tilePos));
    }

    @Deprecated
    public final int getBrightness(@NotNull LightLayer lightLayer, int x, int y, int z) {
        return this.getLightLevel(lightLayer, new ChunkTilePos(x, y, z));
    }

    public void setLightLevel(@NotNull LightLayer lightLayer, @NotNull ChunkTilePosc tilePos, int value) {
        if (!tilePos.inBounds()) {
            return;
        }
        this.getSection(tilePos).setLightLevel(lightLayer, new ChunkSectionTilePos(tilePos), value);
        this.isModified = true;
    }

    @Deprecated
    public final void setBrightness(@NotNull LightLayer lightLayer, int x, int y, int z, int value) {
        this.setLightLevel(lightLayer, new ChunkTilePos(x, y, z), value);
    }

    public int getRawSkyLightLevel(@NotNull ChunkTilePosc tilePos, int subtractedSkyLight) {
        if (!tilePos.inBounds()) {
            return 0;
        }
        int lightValue = this.getSection(tilePos).getRawSkyLightLevel(new ChunkSectionTilePos(tilePos), subtractedSkyLight);
        if (lightValue > 0) {
            isLit = true;
        }
        return lightValue;
    }

    @Deprecated
    public final int getRawBrightness(int x, int y, int z, int subtractedSkyLight) {
        return this.getRawSkyLightLevel(new ChunkTilePos(x, y, z), subtractedSkyLight);
    }

    public void addEntity(@NotNull Entity entity) {
        this.hasEntities = true;
        this.isModified = true;
        @NotNull ChunkPos entityChunkPos = new ChunkPos(entity);
        if (!entityChunkPos.equals(this.pos)) {
            LOGGER.warn("Wrong location! {}", (Object)entity);
            Thread.dumpStack();
        }
        int section = MathHelper.clamp(MathHelper.floor(entity.y / 16.0), 0, 15);
        entity.addedToChunk = true;
        entity.chunkCoordX = this.pos.x;
        entity.chunkCoordY = section;
        entity.chunkCoordZ = this.pos.z;
        this.getSection(section).addEntity(entity);
    }

    public void removeEntity(@NotNull Entity entity) {
        this.removeEntityAtIndex(entity, entity.chunkCoordY);
    }

    public void removeEntityAtIndex(@NotNull Entity entity, int index) {
        index = MathHelper.clamp(index, 0, 15);
        this.getSection(index).removeEntity(entity);
    }

    public boolean canBlockSeeSky(@NotNull ChunkTilePosc tilePos) {
        return tilePos.y() >= this.getHeightValue(tilePos.x(), tilePos.z());
    }

    @Deprecated
    public final boolean canBlockSeeTheSky(int x, int y, int z) {
        return this.canBlockSeeSky(new ChunkTilePos(x, y, z));
    }

    @Nullable
    public TileEntity getTileEntity(@NotNull ChunkTilePosc tilePos) {
        @Nullable TileEntity tileEntity = this.tileEntityMap.get(tilePos);
        if (tileEntity == null) {
            @Nullable Block<?> block = this.getBlock(tilePos);
            if (!block.isEntityTile) {
                return null;
            }
            block.onBlockPlacedByWorld(this.world, this.pos.x * 16 + tilePos.x(), tilePos.y(), this.pos.z * 16 + tilePos.z());
            tileEntity = this.tileEntityMap.get(tilePos);
        }
        if (tileEntity != null && tileEntity.isInvalid()) {
            this.tileEntityMap.remove(tilePos);
            return null;
        }
        return tileEntity;
    }

    @Deprecated
    @Nullable
    public final TileEntity getTileEntity(int x, int y, int z) {
        return this.getTileEntity(new ChunkTilePos(x, y, z));
    }

    public void addTileEntity(@NotNull TileEntity tileEntity) {
        @NotNull TilePos tilePos = new TilePos(tileEntity.x, tileEntity.y, tileEntity.z);
        this.setTileEntity(new ChunkTilePos(tilePos), tileEntity);
        if (this.isLoaded) {
            this.world.tileEntityList.add(tileEntity);
        }
    }

    public boolean setTileEntity(@NotNull ChunkTilePosc tilePos, @NotNull TileEntity tileEntity) {
        @NotNull TilePos worldPos = new TilePos(this.pos, tilePos);
        tileEntity.worldObj = this.world;
        tileEntity.x = worldPos.x;
        tileEntity.y = worldPos.y;
        tileEntity.z = worldPos.z;
        @Nullable Block<?> block = this.getBlock(tilePos);
        if (block.isEntityTile) {
            tileEntity.validate();
            @Nullable TileEntity previous = this.tileEntityMap.put(new ChunkTilePos(tilePos), tileEntity);
            if (previous != null) {
                previous.invalidate();
            }
            return true;
        }
        LOGGER.warn("Attempted to place a tile entity {} at {} {} {} where there was no tile entity block!", tileEntity.getClass(), worldPos.x, worldPos.y, worldPos.z);
        Thread.dumpStack();
        return false;
    }

    @Deprecated
    public final boolean setTileEntity(int x, int y, int z, @NotNull TileEntity tileEntity) {
        return this.setTileEntity(new ChunkTilePos(x, y, z), tileEntity);
    }

    public void removeTileEntity(@NotNull ChunkTilePosc tilePos) {
        TileEntity tileEntity;
        if (this.isLoaded && (tileEntity = this.tileEntityMap.remove(tilePos)) != null) {
            tileEntity.invalidate();
        }
    }

    @Deprecated
    public final void removeTileEntity(int x, int y, int z) {
        this.removeTileEntity(new ChunkTilePos(x, y, z));
    }

    public void removeTileEntity(@Nullable TileEntity tileEntity) {
        if (this.isLoaded && tileEntity != null && this.tileEntityMap.containsValue(tileEntity)) {
            @NotNull ChunkTilePos tilePos = new ChunkTilePos(tileEntity.x, tileEntity.y, tileEntity.z);
            this.tileEntityMap.remove(tilePos);
            tileEntity.invalidate();
        }
    }

    public void onLoad() {
        this.isLoaded = true;
        this.world.addAllBlockEntities(this.tileEntityMap.values());
        for (ChunkSection section : this.sections) {
            section.onLoad(this.world);
        }
    }

    public void onUnload() {
        this.isLoaded = false;
        for (TileEntity tileentity : this.tileEntityMap.values()) {
            tileentity.invalidate();
        }
        for (ChunkSection section : this.sections) {
            section.onUnload(this.world);
        }
    }

    public void setChunkModified() {
        this.isModified = true;
    }

    public void getEntitiesWithin(@Nullable Entity toExclude, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull Entity> entities) {
        int minSection = Math.max(0, MathHelper.floor((aabb.minY() - 2.0) / 16.0));
        int maxSection = Math.min(MathHelper.floor((aabb.maxY() + 2.0) / 16.0), 15);
        for (int section = minSection; section <= maxSection; ++section) {
            this.getSection(section).getEntitiesWithin(toExclude, aabb, entities);
        }
    }

    public <T extends Entity> void getEntitiesWithin(@NotNull Class<T> ofClass, @NotNull AABBdc aabb, @NotNull @NotNull List<@NotNull T> entities) {
        int minSection = Math.max(0, MathHelper.floor((aabb.minY() - 2.0) / 16.0));
        int maxSection = Math.min(MathHelper.floor((aabb.maxY() + 2.0) / 16.0), 15);
        for (int section = minSection; section <= maxSection; ++section) {
            this.getSection(section).getEntitiesWithin(ofClass, aabb, entities);
        }
    }

    public <T extends Entity> void getEntitiesWithinRadius(@NotNull Class<T> ofClass, double x, double y, double z, double radius, @NotNull @NotNull List<@NotNull T> entities) {
        int minSection = Math.max(0, MathHelper.floor((y - radius - 2.0) / 16.0));
        int maxSection = Math.min(MathHelper.floor((y + radius + 2.0) / 16.0), 15);
        for (int section = minSection; section <= maxSection; ++section) {
            this.getSection(section).getEntitiesWithinRadius(ofClass, x, y, z, radius, entities);
        }
    }

    public boolean needsSaving(boolean saveImmediately) {
        if (this.neverSave) {
            return false;
        }
        if (saveImmediately ? this.hasEntities && this.world.getWorldTime() != this.lastSaveTime : this.hasEntities && this.world.getWorldTime() >= this.lastSaveTime + 600L) {
            return true;
        }
        return this.isModified;
    }

    public int setChunkData(byte @NotNull [] data, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int z;
        int x;
        int minSectionY = minY / 16;
        int maxSectionY = (int)Math.ceil((double)maxY / 16.0);
        for (int sectionY = minSectionY; sectionY <= maxSectionY; ++sectionY) {
            if (sectionY < 0 || sectionY >= this.sections.length) continue;
            int minYSection = minY - sectionY * 16;
            int maxYSection = maxY - sectionY * 16;
            if (minYSection < 0) {
                minYSection = 0;
            }
            if (maxYSection > 16) {
                maxYSection = 16;
            }
            startIndex = this.sections[sectionY].setChunkSectionData(data, minX, minYSection, minZ, maxX, maxYSection, maxZ, startIndex);
        }
        this.recalcHeightmapOnly();
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                this.temperature[x * 16 + z] = (double)(data[startIndex++] & 0xFF) / 255.0;
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                this.humidity[x * 16 + z] = (double)(data[startIndex++] & 0xFF) / 255.0;
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                this.variety[x * 16 + z] = (double)(data[startIndex++] & 0xFF) / 255.0;
            }
        }
        return startIndex;
    }

    public int getChunkData(byte @NotNull [] data, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int startIndex) {
        int z;
        int x;
        int minSectionY = minY / 16;
        int maxSectionY = (int)Math.ceil((double)maxY / 16.0);
        for (int sectionY = minSectionY; sectionY <= maxSectionY; ++sectionY) {
            if (sectionY < 0 || sectionY >= this.sections.length) continue;
            int minYSection = minY - sectionY * 16;
            int maxYSection = maxY - sectionY * 16;
            if (minYSection < 0) {
                minYSection = 0;
            }
            if (maxYSection > 16) {
                maxYSection = 16;
            }
            startIndex = this.sections[sectionY].getChunkSectionData(data, minX, minYSection, minZ, maxX, maxYSection, maxZ, startIndex);
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                data[startIndex++] = (byte)(this.temperature[x * 16 + z] * 255.0);
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                data[startIndex++] = (byte)(this.humidity[x * 16 + z] * 255.0);
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                data[startIndex++] = (byte)(this.variety[x * 16 + z] * 255.0);
            }
        }
        return startIndex;
    }

    @NotNull
    public Random getChunkRandom(long xor) {
        return new Random(this.world.getRandomSeed() + (long)(this.pos.x * this.pos.x) * 4987142L + (long)this.pos.x * 5947611L + (long)(this.pos.z * this.pos.z) * 4392871L + (long)this.pos.z * 389711L ^ xor);
    }

    public boolean isChunkEmpty() {
        return false;
    }

    public void fixMissingBlocks() {
        for (ChunkSection section : this.sections) {
            if (section == null || section.blocks == null) continue;
            MissingBlockFixer.fixMissingBlocks(section.blocks);
        }
    }
}

