/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import java.util.Random;
import net.minecraft.core.block.BlockLogicSand;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.feature.WorldFeatureFire;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneA;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneB;
import net.minecraft.core.world.generate.feature.WorldFeatureMagmaBoulder;
import net.minecraft.core.world.generate.feature.WorldFeatureNetherLava;
import net.minecraft.core.world.generate.feature.WorldFeatureNetherPatch;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;
import net.minecraft.core.world.generate.feature.WorldFeaturePillar;
import net.minecraft.core.world.generate.feature.WorldFeatureRubyglassCrystal;
import net.minecraft.core.world.generate.feature.WorldFeatureRubyglassGrowthPatch;
import net.minecraft.core.world.generate.feature.WorldFeatureTerrace;
import net.minecraft.core.world.generate.feature.WorldFeatureThermalSpire;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureBoneshaleTree;
import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;
import net.minecraft.core.world.noise.Noise2D;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ChunkDecoratorNether
implements ChunkDecorator {
    @NotNull
    private final World world;
    @NotNull
    private final Noise2D crystalDensityNoise;

    public ChunkDecoratorNether(@NotNull World world) {
        this.world = world;
        this.crystalDensityNoise = new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 6, 74));
    }

    @Override
    public void decorate(@NotNull Chunk chunk) {
        int zf;
        int yf;
        int xf;
        int i;
        int zf1;
        int yf1;
        int xf1;
        int zf2;
        int yf2;
        int l24;
        int k23;
        int l21;
        int chunkX = chunk.pos.x;
        int chunkZ = chunk.pos.z;
        int minY = this.world.getWorldType().getMinY(this.world);
        int maxY = this.world.getWorldType().getMaxY(this.world);
        int rangeY = maxY + 1 - minY;
        Random rand = new Random((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        BlockLogicSand.fallInstantly = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        Biome biome = this.world.getBlockBiome(x + 16, minY, z + 16);
        @NotNull TilePos ti = new TilePos();
        if (biome == Biomes.NETHER_CRYSTAL_FOREST || biome == Biomes.NETHER_CRYSTAL_FIELD) {
            int i2;
            double noiseScale = 0.5;
            int density = (int)((this.crystalDensityNoise.getValue((double)x * noiseScale, (double)z * noiseScale) - 6.0 + 30.0) / 6.0);
            if (biome == Biomes.NETHER_CRYSTAL_FOREST) {
                for (i2 = 0; i2 < density + 4; ++i2) {
                    ti.set(x + rand.nextInt(16) + 8, rangeY / 2 + rand.nextInt(rangeY - 8) + 4, z + rand.nextInt(16) + 8);
                    boolean isCeiling = rand.nextInt(5) == 0;
                    new WorldFeatureRubyglassCrystal(isCeiling).place(this.world, rand, ti);
                }
                for (i2 = 0; i2 < density + 6; ++i2) {
                    ti.set(x + rand.nextInt(16) + 8, rangeY / 2 + rand.nextInt(rangeY - 8) + 4, z + rand.nextInt(16) + 8);
                    new WorldFeatureRubyglassCrystal(false, 25, 50).place(this.world, rand, ti);
                }
            }
            ti.set(x + rand.nextInt(16) + 8, rangeY / 2 + rand.nextInt(rangeY - 8) + 4, z + rand.nextInt(16) + 8);
            new WorldFeatureRubyglassCrystal(false, 20, 30).place(this.world, rand, ti);
            for (i2 = 0; i2 < 20; ++i2) {
                int xf2 = x + rand.nextInt(16) + 8;
                int yf3 = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
                int zf3 = z + rand.nextInt(16) + 8;
                new WorldFeatureRubyglassGrowthPatch().place(this.world, rand, xf2, yf3, zf3);
            }
            for (int l18 = 0; l18 < 30; ++l18) {
                int l212 = x + rand.nextInt(16) + 8;
                int k232 = minY + rand.nextInt(rand.nextInt(rangeY - rangeY / 16) + rangeY / 16);
                int l242 = z + rand.nextInt(16) + 8;
                new WorldFeatureNetherLava(Blocks.FLUID_WATER_FLOWING.id()).place(this.world, rand, l212, k232, l242);
            }
            if (rand.nextInt(4) == 0) {
                int xf3 = x + rand.nextInt(16) + 8;
                int yf4 = rangeY / 2 + rand.nextInt(rangeY - 8) + 4;
                int zf4 = z + rand.nextInt(16) + 8;
                new WorldFeaturePillar(Blocks.NETHERRACK.id(), true).place(this.world, rand, xf3, yf4, zf4);
            }
        }
        if (biome == Biomes.NETHER_VOLCANIC_ISLANDS) {
            for (int l18 = 0; l18 < 50; ++l18) {
                l21 = x + rand.nextInt(16) + 8;
                k23 = minY + rand.nextInt(rand.nextInt(rangeY - rangeY / 16) + rangeY / 16);
                l24 = z + rand.nextInt(16) + 8;
                new WorldFeatureNetherLava(Blocks.FLUID_LAVA_FLOWING.id()).place(this.world, rand, l21, k23, l24);
            }
            if (rand.nextInt(4) == 0) {
                int xf4 = x + rand.nextInt(16) + 8;
                yf2 = rangeY / 2 + rand.nextInt(rangeY - 8) + 4;
                zf2 = z + rand.nextInt(16) + 8;
                new WorldFeaturePillar(Blocks.COBBLE_BASALT.id(), true).place(this.world, rand, xf4, yf2, zf2);
            }
            for (int i3 = 0; i3 < 2; ++i3) {
                xf1 = x + rand.nextInt(16) + 8;
                yf1 = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
                zf1 = z + rand.nextInt(16) + 8;
                new WorldFeatureMagmaBoulder().place(this.world, rand, xf1, yf1, zf1);
            }
        }
        if (biome == Biomes.NETHER_SULFUR_POOLS) {
            int i4;
            if (rand.nextInt(8) != 0) {
                new WorldFeatureTerrace(Blocks.FLUID_WATER_STILL, Blocks.BRIMSAND).place(this.world, rand, x, 0, z);
            }
            if (rand.nextInt(8) == 0) {
                int xf5 = x + rand.nextInt(16) + 8;
                yf2 = rangeY / 2 + rand.nextInt(rangeY - 8) + 4;
                zf2 = z + rand.nextInt(16) + 8;
                new WorldFeaturePillar(Blocks.COBBLE_BASALT.id(), true).place(this.world, rand, xf5, yf2, zf2);
            }
            for (int l18 = 0; l18 < 30; ++l18) {
                l21 = x + rand.nextInt(16) + 8;
                k23 = minY + rand.nextInt(rand.nextInt(rangeY - rangeY / 16) + rangeY / 16);
                l24 = z + rand.nextInt(16) + 8;
                new WorldFeatureNetherLava(Blocks.FLUID_LAVA_FLOWING.id()).place(this.world, rand, l21, k23, l24);
            }
            for (i4 = 0; i4 < 1; ++i4) {
                xf1 = x + rand.nextInt(16) + 8;
                yf1 = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
                zf1 = z + rand.nextInt(16) + 8;
                new WorldFeatureThermalSpire().place(this.world, rand, xf1, yf1, zf1);
            }
            for (i4 = 0; i4 < 2; ++i4) {
                xf1 = x + rand.nextInt(16) + 8;
                yf1 = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
                zf1 = z + rand.nextInt(16) + 8;
                new WorldFeatureMagmaBoulder().place(this.world, rand, xf1, yf1, zf1);
            }
        }
        for (int i5 = 0; i5 < 10; ++i5) {
            int xf6 = x + rand.nextInt(16);
            int yf5 = rangeY / 2 + rand.nextInt(rangeY - 8) + 4;
            int zf5 = z + rand.nextInt(16);
            new WorldFeatureOre(Blocks.ORE_NETHERCOAL_NETHERRACK.id(), 12).place(this.world, rand, xf6, yf5, zf5);
        }
        int max = rand.nextInt(rand.nextInt(10) + 1);
        for (i = 0; i < max; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureGlowstoneA().place(this.world, rand, xf, yf, zf);
        }
        for (i = 0; i < 10; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureGlowstoneB().place(this.world, rand, xf, yf, zf);
        }
        if (biome == Biomes.NETHER_VOLCANIC_ISLANDS) {
            for (i = 0; i < 20; ++i) {
                xf = x + rand.nextInt(16);
                yf = rangeY / 2 + rand.nextInt(rangeY - 8) + 4;
                zf = z + rand.nextInt(16);
                new WorldFeatureOre(Blocks.ORE_NETHERCOAL_NETHERRACK.id(), 16).place(this.world, rand, xf, yf, zf);
            }
        }
        max = 4;
        if (biome == Biomes.NETHER_VOLCANIC_ISLANDS || biome == Biomes.NETHER_SULFUR_POOLS) {
            max = 8;
        }
        if (biome == Biomes.NETHER_CRYSTAL_FIELD || biome == Biomes.NETHER_CRYSTAL_FOREST) {
            max = 0;
        }
        for (i = 0; i < max; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureFire().place(this.world, rand, xf, yf, zf);
        }
        max = 2;
        if (biome == Biomes.NETHER_OLD_WORLD) {
            max = 8;
        }
        for (i = 0; i < max; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureNetherPatch(Blocks.BONE_PILE.id()).place(this.world, rand, xf, yf, zf);
        }
        max = 4;
        if (biome == Biomes.NETHER_OLD_WORLD) {
            max = 2;
        }
        for (i = 0; i < max; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureNetherPatch(Blocks.SOULCATCHER.id()).place(this.world, rand, xf, yf, zf);
        }
        if (biome == Biomes.NETHER_OLD_WORLD) {
            double noiseScale = 0.5;
            int density = (int)((this.crystalDensityNoise.getValue((double)x * noiseScale, (double)z * noiseScale) - 6.0 + 20.0) / 6.0);
            for (int i6 = 0; i6 < density + 4; ++i6) {
                int xf7 = x + rand.nextInt(16) + 8;
                int yf6 = this.world.getWorldType().getOceanY() + rand.nextInt(rangeY - 8) + 4;
                int zf6 = z + rand.nextInt(16) + 8;
                new WorldFeatureBoneshaleTree(0, Blocks.BONESHALE.id()).place(this.world, rand, xf7, yf6, zf6);
            }
        }
        int oceanY = this.world.getWorldType().getOceanY();
        int midY = oceanY + (this.world.getWorldType().getMaxY(this.world) - oceanY) / 2;
        for (int dx = x + 8; dx < x + 8 + 16; ++dx) {
            for (int dz = z + 8; dz < z + 8 + 16; ++dz) {
                Biome localBiome;
                int dy = midY;
                while (this.world.getBlockId(dx, dy, dz) == 0) {
                    --dy;
                }
                if ((localBiome = this.world.getBlockBiome(dx, ++dy, dz)) == null || !localBiome.hasSurfaceSnow() || dy <= 0 || dy >= this.world.getHeightBlocks() || !this.world.isAirBlock(dx, dy, dz) || !this.world.getBlockMaterial(dx, dy - 1, dz).blocksMotion()) continue;
                this.world.setBlockWithNotify(dx, dy, dz, Blocks.LAYER_ASH.id());
            }
        }
        BlockLogicSand.fallInstantly = false;
    }
}

