/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.datagen.recipeBuilders;

import com.b100.utils.FileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.adapter.ItemStackJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.RecipeSymbolJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.WeightedRandomBagJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.WeightedRandomLootObjectJsonAdapter;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import net.minecraft.datagen.recipeBuilders.RecipeBuilderBlastFurnace;
import net.minecraft.datagen.recipeBuilders.RecipeBuilderFurnace;
import net.minecraft.datagen.recipeBuilders.RecipeBuilderShaped;
import net.minecraft.datagen.recipeBuilders.RecipeBuilderShapeless;
import net.minecraft.datagen.recipeBuilders.RecipeBuilderTrommel;
import org.jetbrains.annotations.NotNull;

public final class RecipeBuilder {
    public static boolean isExporting = false;

    @NotNull
    public static RecipeNamespace getRecipeNamespace(String modID) {
        if (Registries.RECIPES.getItem(modID) != null) {
            return (RecipeNamespace)Registries.RECIPES.getItem(modID);
        }
        RecipeNamespace modSpace = new RecipeNamespace();
        Registries.RECIPES.register(modID, modSpace);
        return Objects.requireNonNull(modSpace);
    }

    @NotNull
    public static RecipeGroup<?> getRecipeGroup(String modID, String key, RecipeSymbol symbol) {
        return RecipeBuilder.getRecipeGroup(RecipeBuilder.getRecipeNamespace(modID), key, symbol);
    }

    @NotNull
    public static RecipeGroup<?> getRecipeGroup(RecipeNamespace namespace, String key, RecipeSymbol symbol) {
        if (namespace.getItem(key) != null) {
            return (RecipeGroup)namespace.getItem(key);
        }
        RecipeGroup group = new RecipeGroup(symbol);
        namespace.register(key, group);
        return Objects.requireNonNull(group);
    }

    @NotNull
    public static List<ItemStack> getItemGroup(String modID, String key) {
        List<ItemStack> group = Registries.ITEM_GROUPS.getItem(String.format("%s:%s", modID, key));
        if (group == null) {
            group = new ArrayList<ItemStack>();
            Registries.ITEM_GROUPS.register(String.format("%s:%s", modID, key), group);
        }
        return group;
    }

    public static void addItemsToGroup(String modID, String key, Object ... items) {
        List<ItemStack> group = RecipeBuilder.getItemGroup(modID, key);
        for (Object o : items) {
            if (o instanceof IItemConvertible) {
                group.add(((IItemConvertible)o).getDefaultStack());
                continue;
            }
            if (o instanceof ItemStack) {
                group.add((ItemStack)o);
                continue;
            }
            throw new IllegalArgumentException(String.format("Object '%s' has invalid class '%s'! Only classes that extend 'IItemConvertible' or 'ItemStack' are allowed!", o.toString(), o.getClass().getSimpleName()));
        }
    }

    public static RecipeBuilderShaped Shaped(String modID) {
        return new RecipeBuilderShaped(modID);
    }

    public static RecipeBuilderShaped Shaped(String modID, String ... shape) {
        return new RecipeBuilderShaped(modID, shape);
    }

    public static RecipeBuilderShapeless Shapeless(String modID) {
        return new RecipeBuilderShapeless(modID);
    }

    public static RecipeBuilderFurnace Furnace(String modID) {
        return new RecipeBuilderFurnace(modID);
    }

    public static RecipeBuilderBlastFurnace BlastFurnace(String modID) {
        return new RecipeBuilderBlastFurnace(modID);
    }

    public static RecipeBuilderTrommel Trommel(String modID) {
        return new RecipeBuilderTrommel(modID);
    }

    public static void exportRecipes(File output, RecipeGroup<? extends RecipeEntryBase<?, ?, ?>> recipeGroup) {
        isExporting = true;
        List<RecipeEntryBase<?, ?, ?>> recipesRaw = recipeGroup.getAllRecipes();
        ArrayList recipes = new ArrayList();
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        ArrayList usedAdapters = new ArrayList();
        for (RecipeEntryBase<?, ?, ?> recipe : recipesRaw) {
            if (!(recipe instanceof HasJsonAdapter)) continue;
            recipes.add(recipe);
            HasJsonAdapter hasJsonAdapter = (HasJsonAdapter)((Object)recipe);
            RecipeJsonAdapter<?> recipeJsonAdapter = hasJsonAdapter.getAdapter();
            if (usedAdapters.contains(recipeJsonAdapter)) continue;
            builder.registerTypeAdapter(recipe.getClass(), recipeJsonAdapter);
            usedAdapters.add(recipeJsonAdapter);
        }
        builder.registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)RecipeSymbol.class), new RecipeSymbolJsonAdapter());
        builder.registerTypeAdapter(new TypeToken<WeightedRandomBag<WeightedRandomLootObject>>(){}.getType(), new WeightedRandomBagJsonAdapter());
        builder.registerTypeAdapter((Type)((Object)WeightedRandomLootObject.class), new WeightedRandomLootObjectJsonAdapter());
        Gson gson = builder.create();
        JsonArray jsonArray = new JsonArray();
        for (RecipeEntryBase recipeEntryBase : recipes) {
            TypeAdapter<?> typeAdapter = gson.getAdapter(recipeEntryBase.getClass());
            JsonElement json = typeAdapter.toJsonTree(recipeEntryBase);
            jsonArray.add(json);
        }
        if (output.exists()) {
            output.delete();
        }
        File file = FileUtils.createNewFile(output);
        try (FileWriter fileWriter = new FileWriter(file);){
            gson.toJson((JsonElement)jsonArray, (Appendable)fileWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        isExporting = false;
    }
}

