/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.sound;

import com.b100.utils.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.InputStream;
import org.slf4j.Logger;

public class SoundTypes {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Int2ObjectMap<String> idToSoundNameMap = new Int2ObjectOpenHashMap<String>();
    private static final Object2IntMap<String> soundNameToIdMap = new Object2IntOpenHashMap<String>();
    private static final String format = "/assets/%s/sounds/sounds.json";
    private static int idCount = 0;

    public static void registerSounds() {
        SoundTypes.loadSoundsJson("minecraft");
    }

    public static void loadSoundsJson(String namespace) {
        JsonObject o;
        try {
            o = SoundTypes.loadStreamAsElement(SoundTypes.class.getResourceAsStream(String.format(format, namespace))).getAsJsonObject();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load sounds.json from '{}' as a json object!", (Object)namespace, (Object)e);
            return;
        }
        boolean isMC = namespace.equals("minecraft");
        for (String s : o.asMap().keySet()) {
            SoundTypes.register(namespace + ":" + s);
            if (!isMC) continue;
            SoundTypes.register(s);
        }
    }

    private static JsonElement loadStreamAsElement(InputStream stream) throws JsonParseException {
        return JsonParser.parseString(StringUtils.readInputString(stream));
    }

    public static boolean register(String soundPath) {
        if (soundPath.length() > 128) {
            throw new RuntimeException("Sound Path is too long: '" + soundPath + "'!");
        }
        if (soundNameToIdMap.containsKey(soundPath)) {
            return false;
        }
        int id = idCount++;
        idCount %= 65536;
        soundNameToIdMap.put(soundPath, id);
        idToSoundNameMap.put(id, soundPath);
        return true;
    }

    public static int getSoundId(String soundPath) {
        return soundNameToIdMap.getOrDefault((Object)soundPath, -1);
    }

    public static String getSoundById(int id) {
        return (String)idToSoundNameMap.get(id);
    }

    public static void setSoundIds(Int2ObjectMap<String> soundIds) {
        idToSoundNameMap.clear();
        soundNameToIdMap.clear();
        for (Int2ObjectMap.Entry entry : soundIds.int2ObjectEntrySet()) {
            int id = entry.getIntKey();
            String name = (String)entry.getValue();
            idToSoundNameMap.put(id, name);
            soundNameToIdMap.put(name, id);
        }
    }

    public static Int2ObjectMap<String> getSoundIds() {
        return idToSoundNameMap;
    }
}

