/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.settings.SettingNodesValues;
import net.minecraft.core.world.settings.WorldConfiguration;
import net.minecraft.core.world.settings.WorldSettingNodes;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypeGroups;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DimensionData {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private final WorldType worldType;
    @NotNull
    private final SettingNodesValues dimensionSettings;
    private int weatherCurrentId = -1;
    private int weatherNextId = -1;
    private long weatherDuration;
    private float weatherIntensity;
    private float weatherPower;

    @NotNull
    public static DimensionData fromCompoundTag(@NotNull CompoundTag tag, @NotNull Dimension dimension) {
        SettingNodesValues dimensionSettings;
        @Nullable WorldType worldType = Registries.WORLD_TYPES.getItem(tag.getString("WorldType"));
        if (worldType == null) {
            worldType = WorldTypeGroups.DEFAULT.get(dimension);
        }
        if (tag.containsKey("DimensionSettings")) {
            @NotNull CompoundTag dimensionSettingsTag = tag.getCompound("DimensionSettings");
            dimensionSettings = SettingNodesValues.deserialize(WorldSettingNodes.getRootNode(), dimension, dimensionSettingsTag);
        } else {
            dimensionSettings = new SettingNodesValues(WorldSettingNodes.getRootNode(), dimension);
        }
        @NotNull DimensionData dimensionData = new DimensionData(worldType, dimensionSettings);
        @NotNull CompoundTag weatherTag = tag.getCompound("Weather");
        dimensionData.weatherCurrentId = weatherTag.getInteger("CurrentID");
        dimensionData.weatherNextId = weatherTag.getInteger("NextID");
        dimensionData.weatherDuration = weatherTag.getLong("Duration");
        dimensionData.weatherIntensity = weatherTag.getFloat("Intensity");
        dimensionData.weatherPower = weatherTag.getFloat("Power");
        return dimensionData;
    }

    @NotNull
    public static CompoundTag toCompoundTag(@NotNull DimensionData dimensionData, @NotNull CompoundTag out) {
        out.putString("WorldType", Objects.requireNonNull(Registries.WORLD_TYPES.getKey(dimensionData.worldType)));
        @NotNull CompoundTag dimensionSettingsTag = new CompoundTag();
        SettingNodesValues.serialize(dimensionData.dimensionSettings, dimensionSettingsTag);
        out.put("DimensionSettings", dimensionSettingsTag);
        @NotNull CompoundTag weatherTag = new CompoundTag();
        weatherTag.putInt("CurrentID", dimensionData.weatherCurrentId);
        weatherTag.putInt("NextID", dimensionData.weatherNextId);
        weatherTag.putLong("Duration", dimensionData.weatherDuration);
        weatherTag.putFloat("Intensity", dimensionData.weatherIntensity);
        weatherTag.putFloat("Power", dimensionData.weatherPower);
        out.putCompound("Weather", weatherTag);
        return out;
    }

    @NotNull
    public static DimensionData fromWorldDir(@NotNull File worldDir, @NotNull Dimension dimension) throws IOException {
        @Nullable CompoundTag nbtRootData = null;
        @NotNull File dimensionsDir = new File(worldDir, "dimensions");
        @NotNull File dimensionDir = new File(dimensionsDir, "" + dimension.id);
        if (!(worldDir.exists() && dimensionsDir.exists() && dimensionDir.exists())) {
            throw new IOException();
        }
        @NotNull File dimensionDat = new File(dimensionDir, "dimension.dat");
        if (dimensionDat.exists()) {
            @NotNull CompoundTag nbtRoot = NbtIo.readCompressed(Files.newInputStream(dimensionDat.toPath(), new OpenOption[0]));
            nbtRootData = nbtRoot.getCompound("Data");
        } else {
            dimensionDat = new File(dimensionDir, "dimension.dat_old");
            if (dimensionDat.exists()) {
                @NotNull CompoundTag oldNbtRoot = NbtIo.readCompressed(Files.newInputStream(dimensionDat.toPath(), new OpenOption[0]));
                nbtRootData = oldNbtRoot.getCompound("Data");
            }
        }
        if (nbtRootData != null) {
            return DimensionData.fromCompoundTag(nbtRootData, dimension);
        }
        throw new IOException();
    }

    private DimensionData(@NotNull WorldType worldType, @NotNull SettingNodesValues dimensionSettings) {
        this.worldType = worldType;
        this.dimensionSettings = dimensionSettings;
    }

    public DimensionData(@NotNull Dimension dimension, @NotNull WorldConfiguration worldConfiguration) {
        this(worldConfiguration.getWorldTypeGroup().get(dimension), worldConfiguration.getDimensionSettings(dimension));
    }

    public DimensionData(@NotNull DimensionData dimensionData, @NotNull Dimension dimension) {
        this.worldType = dimensionData.worldType;
        this.dimensionSettings = new SettingNodesValues(WorldSettingNodes.getRootNode(), dimension);
        this.dimensionSettings.setAll(dimensionData.dimensionSettings);
        this.weatherCurrentId = dimensionData.weatherCurrentId;
        this.weatherNextId = dimensionData.weatherNextId;
        this.weatherDuration = dimensionData.weatherDuration;
        this.weatherIntensity = dimensionData.weatherIntensity;
        this.weatherPower = dimensionData.weatherPower;
    }

    @NotNull
    public WorldType getWorldType() {
        return this.worldType;
    }

    @NotNull
    public SettingNodesValues getDimensionSettings() {
        return this.dimensionSettings;
    }

    @Nullable
    public Weather getCurrentWeather() {
        if (this.weatherCurrentId < 0) {
            return null;
        }
        return Weathers.getWeather(this.weatherCurrentId);
    }

    public void setCurrentWeather(@Nullable Weather weather) {
        this.weatherCurrentId = weather == null ? -1 : weather.getId();
    }

    @Nullable
    public Weather getNextWeather() {
        if (this.weatherNextId == -1) {
            return null;
        }
        return Weathers.getWeather(this.weatherNextId);
    }

    public void setNextWeather(@Nullable Weather weather) {
        this.weatherNextId = weather == null ? -1 : weather.getId();
    }

    public long getWeatherDuration() {
        return this.weatherDuration;
    }

    public void setWeatherDuration(long duration) {
        this.weatherDuration = duration;
    }

    public float getWeatherIntensity() {
        return this.weatherIntensity;
    }

    public void setWeatherIntensity(float intensity) {
        this.weatherIntensity = intensity;
    }

    public float getWeatherPower() {
        return this.weatherPower;
    }

    public void setWeatherPower(float power) {
        this.weatherPower = power;
    }
}

