/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.IArmorWearing;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.primitives.AABBd;

public class ExplosionCannonball
extends Explosion {
    public ExplosionCannonball(@NotNull World world, @Nullable Entity exploder, double x, double y, double z, float explosionSize) {
        super(world, exploder, x, y, z, explosionSize);
    }

    @Override
    public void explode() {
        this.explosionSize *= 3.0f;
        int minX = MathHelper.floor(this.explosionX - (double)this.explosionSize - 1.0);
        int maxX = MathHelper.floor(this.explosionX + (double)this.explosionSize + 1.0);
        int minY = MathHelper.floor(this.explosionY - (double)this.explosionSize - 1.0);
        int maxY = MathHelper.floor(this.explosionY + (double)this.explosionSize + 1.0);
        int minZ = MathHelper.floor(this.explosionZ - (double)this.explosionSize - 1.0);
        int maxZ = MathHelper.floor(this.explosionZ + (double)this.explosionSize + 1.0);
        List<Entity> list = this.world.getEntitiesWithinAABB(Entity.class, new AABBd(minX, minY, minZ, maxX, maxY, maxZ));
        Vector3d vec3 = new Vector3d(this.explosionX, this.explosionY, this.explosionZ);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            IArmorWearing entArmored;
            Entity entity = list.get(k2);
            double d4 = entity.distanceTo(this.explosionX, this.explosionY, this.explosionZ) / (double)this.explosionSize;
            if (!(d4 <= 1.0)) continue;
            double xComp = entity.x - this.explosionX;
            double yComp = entity.y + (double)(entity.bbHeight / 2.0f) - this.explosionY;
            double zComp = entity.z - this.explosionZ;
            double d11 = MathHelper.sqrt(xComp * xComp + yComp * yComp + zComp * zComp);
            xComp *= 2.5;
            yComp /= d11;
            yComp += 0.5;
            zComp *= 2.5;
            double d12 = this.world.getSeenPercent(vec3, entity.bb);
            double flingForce = (1.0 - d4) * d12;
            if (!(entity instanceof EntityItem)) {
                entity.hurt(this.exploder, (int)((flingForce * flingForce + flingForce) / 2.0 * 8.0 * ((double)this.explosionSize * 2.0 / 3.0) + 1.0), DamageType.BLAST);
            }
            if (entity instanceof IArmorWearing && (entArmored = (IArmorWearing)((Object)entity)) != this.exploder) {
                float proc = 1.0f - entArmored.getTotalProtectionAmount(DamageType.BLAST) / 2.0f;
                flingForce *= (double)proc;
            }
            entity.fling(xComp * flingForce, yComp * flingForce, zComp * flingForce, 1.0f);
        }
    }

    @Override
    public void addEffects(boolean particles) {
        if (!this.world.isClientSide) {
            this.world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f) * 0.7f);
        }
        if (particles) {
            Vector3d d = new Vector3d(0.0, 0.0, 1.0);
            for (int i = 0; i < 64; ++i) {
                d.set(0.0, 0.0, 0.25);
                d.rotateY(this.ExplosionRNG.nextDouble() * (Math.PI * 2));
                d.rotateX(this.ExplosionRNG.nextDouble() * (Math.PI * 2));
                d.mul(1.0 - this.ExplosionRNG.nextDouble() * 0.25);
                this.world.spawnParticle("explode", this.explosionX + d.x(), this.explosionY + d.y(), this.explosionZ + d.z(), d.x() * 2.0, d.y() * 2.0, d.z() * 2.0, 0);
                this.world.spawnParticle("smoke", this.explosionX + d.x(), this.explosionY + d.y(), this.explosionZ + d.z(), d.x() * 2.0, d.y() * 2.0, d.z() * 2.0, 0);
            }
        }
    }
}

