/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.LargeFeature;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import net.minecraft.core.world.generate.chunk.perlin.SurfaceGenerator;
import net.minecraft.core.world.generate.chunk.perlin.TerrainGenerator;
import org.jetbrains.annotations.NotNull;

public class ChunkGeneratorPerlin
extends ChunkGenerator {
    @NotNull
    private final TerrainGenerator terrainGenerator;
    @NotNull
    private final SurfaceGenerator surfaceGenerator;
    @NotNull
    private final List<LargeFeature> largeFeatures;

    protected ChunkGeneratorPerlin(@NotNull World world, @NotNull ChunkDecorator decorator, @NotNull TerrainGenerator terrainGenerator, @NotNull SurfaceGenerator surfaceGenerator, @NotNull @NotNull LargeFeature @NotNull [] largeFeatures) {
        super(world, decorator);
        this.terrainGenerator = terrainGenerator;
        this.surfaceGenerator = surfaceGenerator;
        this.largeFeatures = Arrays.asList(largeFeatures);
    }

    @Override
    @NotNull
    protected ChunkGeneratorResult doBlockGeneration(@NotNull Chunk chunk) {
        double[] densityMap = this.terrainGenerator.getDensityGenerator().generateDensityMap(chunk);
        ChunkGeneratorResult result = this.terrainGenerator.generateTerrain(chunk, densityMap);
        this.surfaceGenerator.generateSurface(chunk, result);
        for (LargeFeature largeFeature : this.largeFeatures) {
            largeFeature.generate(this.world, chunk.pos.x, chunk.pos.z, result);
        }
        return result;
    }
}

