/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.voxelizer;

import java.util.Objects;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.voxelizer.Voxelizer;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ConvexShapeVoxelizer
implements Voxelizer {
    @NotNull
    private final @NotNull Vector3f @NotNull [] @NotNull [] faces;
    @NotNull
    private final BlockFetcher fetcher;

    public ConvexShapeVoxelizer(@NotNull @NotNull Vector3f @NotNull [] points, int @NotNull [] @NotNull [] faces, @NotNull Matrix4f transformation, @NotNull BlockFetcher fetcher) {
        int i;
        this.fetcher = fetcher;
        @NotNull Vector3f @NotNull [] tPoints = new Vector3f[points.length];
        for (i = 0; i < points.length; ++i) {
            tPoints[i] = Objects.requireNonNull(new Vector4f(points[i], 1.0f).mul(transformation).xyz(new Vector3f()));
        }
        this.faces = new Vector3f[faces.length][];
        for (i = 0; i < faces.length; ++i) {
            this.faces[i] = new Vector3f[faces[i].length];
            for (int j = 0; j < faces[i].length; ++j) {
                this.faces[i][j] = tPoints[faces[i][j]];
            }
        }
    }

    @Override
    public void voxelize(@NotNull World world, @NotNull TilePosc origin) {
        this.fillConvexSolid(world, origin, this.fetcher, this.faces);
    }

    private void fillConvexSolid(@NotNull World world, @NotNull TilePosc origin, @NotNull BlockFetcher fetcher, @NotNull @NotNull Vector3f @NotNull [] @NotNull [] faces) {
        @NotNull Plane @NotNull [] planes = new Plane[faces.length];
        for (int i = 0; i < faces.length; ++i) {
            Vector3f[] f = faces[i];
            planes[i] = new Plane(f[0], f[1], f[2]);
        }
        @NotNull Vector3f min = new Vector3f(Float.POSITIVE_INFINITY);
        @NotNull Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY);
        Vector3f[][] vector3fArray = faces;
        int n = vector3fArray.length;
        for (int i = 0; i < n; ++i) {
            Vector3f[] f;
            for (Vector3f v : f = vector3fArray[i]) {
                min.min(v);
                max.max(v);
            }
        }
        @NotNull Vector3f centroid = new Vector3f();
        int count = 0;
        Vector3f[][] vector3fArray2 = faces;
        int f = vector3fArray2.length;
        for (int i = 0; i < f; ++i) {
            Vector3f[] vector3fArray3;
            for (Vector3f v : vector3fArray3 = vector3fArray2[i]) {
                centroid.add(v);
                ++count;
            }
        }
        centroid.div(count);
        for (Vector3f[] vector3fArray4 : planes) {
            if (!(vector3fArray4.signedDistance(centroid) > 0.0f)) continue;
            vector3fArray4.flip();
        }
        @NotNull Vector3f p = new Vector3f();
        @NotNull TilePos ti = new TilePos();
        @NotNull TilePos temp = new TilePos();
        float @NotNull [] fArray = new float[planes.length];
        ti.x = MathHelper.floor(min.x);
        while (ti.x <= MathHelper.floor(max.x)) {
            ti.y = MathHelper.floor(min.y);
            while (ti.y <= MathHelper.floor(max.y)) {
                ti.z = MathHelper.floor(min.z);
                while (ti.z <= MathHelper.floor(max.z)) {
                    p.set((float)ti.x + 0.5f, (float)ti.y + 0.5f, (float)ti.z + 0.5f);
                    boolean inside = true;
                    for (int i = 0; i < planes.length; ++i) {
                        fArray[i] = -planes[i].signedDistance(p);
                        if (!(fArray[i] < 0.0f)) continue;
                        inside = false;
                        break;
                    }
                    if (inside) {
                        ti.add(origin.x(), origin.y(), origin.z(), temp);
                        @NotNull Block<?> replacing = world.getBlockType(temp);
                        @Nullable Block<?> replacer = fetcher.getBlock(temp, replacing, fArray);
                        if (replacer != null) {
                            world.setBlockTypeNotify(temp, replacer);
                        }
                    }
                    ++ti.z;
                }
                ++ti.y;
            }
            ++ti.x;
        }
    }

    public static interface BlockFetcher {
        @Nullable
        public Block<?> getBlock(@NotNull TilePosc var1, @NotNull Block<?> var2, float @NotNull [] var3);
    }

    private static class Plane {
        @NotNull
        final Vector3f normal;
        float d;

        Plane(@NotNull Vector3f a, @NotNull Vector3f b, @NotNull Vector3f c) {
            @NotNull Vector3f ab = Objects.requireNonNull(new Vector3f(b).sub(a));
            @NotNull Vector3f ac = Objects.requireNonNull(new Vector3f(c).sub(a));
            this.normal = Objects.requireNonNull(Objects.requireNonNull(ab.cross(ac)).normalize());
            this.d = -this.normal.dot(a);
        }

        float signedDistance(@NotNull Vector3f p) {
            return this.normal.dot(p) + this.d;
        }

        void flip() {
            this.normal.negate();
            this.d = -this.d;
        }
    }
}

