/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Objects;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.BiomeTags;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.DensityGenerator;
import net.minecraft.core.world.generate.chunk.perlin.TerrainGeneratorLerp;
import net.minecraft.core.world.generate.chunk.perlin.nether.DensityGeneratorNether;
import net.minecraft.core.world.noise.FractalNoise3D;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;
import net.minecraft.core.world.noise.Noise3D;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerrainGeneratorNether
extends TerrainGeneratorLerp {
    private final DensityGenerator densityGenerator;
    private final int lastX = Integer.MIN_VALUE;
    private final int lastZ = Integer.MIN_VALUE;
    @Nullable
    private Biome lastBiome = null;
    private final Object2IntMap<Biome> fluidLookup = new Object2IntArrayMap<Biome>();
    private int lastChunkX = Integer.MIN_VALUE;
    private int lastChunkZ = Integer.MIN_VALUE;
    @NotNull
    private final Noise3D noise = new FractalNoise3D((Noise3D[])ImprovedPerlinNoise.genOctaves(0L, 4, 0));
    private final double @NotNull [] cache = new double[65536];
    private final int minY;
    private final int maxY;

    public TerrainGeneratorNether(@NotNull World world) {
        super(world);
        this.densityGenerator = new DensityGeneratorNether(world);
        this.fluidLookup.put(Biomes.NETHER_VOLCANIC_ISLANDS, Blocks.FLUID_LAVA_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_SULFUR_POOLS, Blocks.FLUID_LAVA_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_CRAG, Blocks.FLUID_LAVA_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_SHELF, Blocks.COBBLE_NETHERRACK.id());
        this.fluidLookup.put(Biomes.NETHER_CRYSTAL_FOREST, Blocks.FLUID_WATER_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_CRYSTAL_PLAINS, Blocks.FLUID_WATER_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_OLD_WORLD, Blocks.FLUID_WATER_STILL.id());
        this.minY = world.getWorldType().getMinY(world);
        this.maxY = world.getWorldType().getMaxY(world);
    }

    @Override
    protected int getBlockAt(@NotNull Chunk chunk, int x, int y, int z, double density) {
        block11: {
            block10: {
                Objects.requireNonNull(this);
                if (Integer.MIN_VALUE != x) break block10;
                Objects.requireNonNull(this);
                if (Integer.MIN_VALUE == z) break block11;
            }
            this.lastBiome = chunk.getBlockBiome(x, 0, z);
        }
        if (this.lastChunkX != chunk.pos.x || this.lastChunkZ != chunk.pos.z) {
            this.lastChunkX = chunk.pos.x;
            this.lastChunkZ = chunk.pos.z;
            this.noise.getRegion(this.cache, chunk.pos.x * 16, 0.0, chunk.pos.z * 16, 16, 256, 16, 0.2, 0.2, 0.2);
        }
        WorldType type = this.world.getWorldType();
        int quarterHeight = this.maxY / 4;
        if (y < quarterHeight) {
            return 0;
        }
        if (y >= this.maxY - this.rand.nextInt(5)) {
            return Blocks.BEDROCK.id();
        }
        if (y <= quarterHeight + this.rand.nextInt(5)) {
            return Blocks.BEDROCK.id();
        }
        if (density > 0.0) {
            int sizeY;
            double d;
            if (this.lastBiome != null && this.lastBiome.hasTag(BiomeTags.HAS_CRYSTAL_VEINS) && (d = this.cache[x * 16 * (sizeY = 256) + z * sizeY + y]) > -1.0 && d < 2.0) {
                return Blocks.COBBLE_NETHERRACK_CRYSTALLINE.id();
            }
            return type.getFillerBlockId();
        }
        if (y < type.getOceanY()) {
            return this.fluidLookup.getOrDefault((Object)this.lastBiome, 0);
        }
        return 0;
    }

    @Override
    @NotNull
    public DensityGenerator getDensityGenerator() {
        return this.densityGenerator;
    }
}

