/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Objects;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeatureInterface;
import net.minecraft.core.world.generate.voxelizer.ConvexShapeVoxelizer;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class WorldFeatureRubyglassCrystal
implements WorldFeatureInterface {
    private static final float BASE_PCTG = 0.5f;
    private final boolean isCeiling;
    private final int minHeight;
    private final int heightMod;

    public WorldFeatureRubyglassCrystal(boolean isCeiling) {
        this(isCeiling, 20, 10);
    }

    public WorldFeatureRubyglassCrystal(boolean isCeiling, int minHeight, int heightMod) {
        this.isCeiling = isCeiling;
        this.minHeight = minHeight;
        this.heightMod = heightMod;
    }

    @Override
    public boolean place(@NotNull World world, @NotNull Random random, @NotNull TilePosc tilePos) {
        Block<?> block;
        @NotNull TilePos ti = new TilePos(tilePos.x() + random.nextInt(2) - random.nextInt(2), tilePos.y(), tilePos.z() + random.nextInt(2) - random.nextInt(2));
        int floorY = -1;
        int checksForGround = 0;
        boolean foundGround = false;
        boolean canGenerate = false;
        int groundDepth = 0;
        while (true) {
            ti.y = this.isCeiling ? ++ti.y : --ti.y;
            if (checksForGround > 64 || ti.y < 0 || ti.y >= world.getHeightBlocks()) break;
            block = world.getBlockType(ti);
            if (!foundGround) {
                if (block == Blocks.COBBLE_NETHERRACK) {
                    floorY = ti.y;
                    foundGround = true;
                }
            } else {
                ++groundDepth;
                if (block != Blocks.COBBLE_NETHERRACK) break;
                if (groundDepth >= 6) {
                    canGenerate = true;
                    break;
                }
            }
            ++checksForGround;
        }
        block = world.getBlockType(ti);
        if (canGenerate && (block == Blocks.COBBLE_NETHERRACK || block == Blocks.SOULSAND)) {
            floorY = this.isCeiling ? ++floorY : --floorY;
            this.placeCrystal(world, random, new TilePos(ti.x, floorY, ti.z));
            return true;
        }
        return false;
    }

    private float randomOffset(int length, @NotNull Random random) {
        int base = length / 16;
        return random.nextFloat() * (float)base;
    }

    private void placeCrystal(@NotNull World world, @NotNull Random random, @NotNull TilePosc tilePos) {
        float r = random.nextFloat();
        int length = this.minHeight + MathHelper.floor(Math.pow(r, 4.0) * (double)this.heightMod);
        int base = length / 4;
        float rx = 0.0f;
        float ry = 0.0f;
        @NotNull TilePos ti = new TilePos(tilePos);
        int n = ti.y = this.isCeiling ? ti.y + base / 2 : ti.y - base / 2;
        if (!this.hasSpace(world, ti, base)) {
            return;
        }
        float minBase = -((float)base / 2.0f);
        float maxBase = (float)base / 2.0f;
        float randX = this.randomOffset(length, random);
        float randZ = this.randomOffset(length, random);
        Vector3f[] pts = new Vector3f[]{new Vector3f(minBase - randX, 0.0f, minBase - randZ), new Vector3f(maxBase + randX, 0.0f, minBase - randZ), new Vector3f(minBase - randX, 0.0f, maxBase + randZ), new Vector3f(maxBase + randX, 0.0f, maxBase + randZ), new Vector3f(minBase - randX, length, minBase - randZ), new Vector3f(maxBase + randX, length, minBase - randZ), new Vector3f(minBase - randX, length, maxBase + randZ), new Vector3f(maxBase + randX, length, maxBase + randZ), new Vector3f(0.0f, (float)length + maxBase * 4.0f * (random.nextFloat() * 0.5f + 0.5f), 0.0f)};
        if (this.isCeiling) {
            rx = (float)Math.PI;
        }
        @NotNull Matrix4f matrix = Objects.requireNonNull(new Matrix4f().rotateY(ry += (float)(random.nextDouble() * 2.0 * Math.PI)).rotateX(rx += (float)((random.nextDouble() - 0.5) * 1.5707963267948966) * 0.8f));
        int[][] faces = new int[][]{{0, 1, 3}, {0, 1, 5}, {1, 3, 7}, {3, 2, 6}, {2, 0, 4}, {4, 5, 8}, {5, 7, 8}, {7, 6, 8}, {6, 4, 8}};
        @NotNull ConvexShapeVoxelizer voxelizer = new ConvexShapeVoxelizer(pts, faces, matrix, (worldPos, replacing, faceDistances) -> {
            if (replacing == Blocks.BEDROCK) {
                return null;
            }
            float distancePctg = faceDistances[0] / (float)length;
            if (distancePctg < 0.5f) {
                float innerDistancePctg = distancePctg / 0.5f;
                if (innerDistancePctg < random.nextFloat()) {
                    return Blocks.COBBLE_NETHERRACK_CRYSTALLINE;
                }
                return Blocks.RUBYGLASS;
            }
            return Blocks.RUBYGLASS;
        });
        voxelizer.voxelize(world, ti);
    }

    private boolean hasSpace(@NotNull World world, @NotNull TilePosc tilePos, int base) {
        @NotNull TilePos ti = new TilePos();
        ti.y = tilePos.y();
        while (ti.y < tilePos.y() + base) {
            ti.x = tilePos.x() - base;
            while (ti.x < tilePos.x() + base) {
                ti.z = tilePos.z() - base;
                while (ti.z < tilePos.z() + base) {
                    if (world.getBlockType(ti) == Blocks.RUBYGLASS) {
                        return false;
                    }
                    ++ti.z;
                }
                ++ti.x;
            }
            ++ti.y;
        }
        return true;
    }
}

