/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.BiomeTags;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicLayerSnow
extends BlockLogicLayerBase {
    public BlockLogicLayerSnow(@NotNull Block<? extends BlockLogicLayerBase> block, @Nullable Block<?> fullBlock, @NotNull Material material) {
        super(block, fullBlock, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        block.setTicking(true);
    }

    public void accumulate(@NotNull World world, @NotNull TilePosc tilePos) {
        int myMetadata = world.getBlockData(tilePos);
        if (myMetadata == 7) {
            return;
        }
        for (int i = 0; i < Direction.horizontalDirections.length; ++i) {
            Direction dir = Direction.horizontalDirections[i];
            TilePos dirPos = tilePos.add(dir, new TilePos());
            if (world.isBlockOpaqueCube(dirPos) || world.getBlockType(dirPos) == this.block && world.getBlockData(dirPos) >= myMetadata) continue;
            return;
        }
        world.setBlockData(tilePos, myMetadata + 1);
        world.markBlockNeedsUpdate(tilePos);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos down = tilePos.down(new TilePos());
        Block<?> b = world.getBlockType(down);
        if (!b.isSolidRender() && !(b.getLogic() instanceof BlockLogicLeavesBase)) {
            return false;
        }
        Material material = world.getBlockMaterial(down);
        return material == Materials.LEAVES || material.blocksMotion();
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        AABBdc aabb = this.getBounds();
        return new AABBd(aabb).setMax(aabb.maxX(), Math.max(aabb.maxY() - 0.125, (double)tilePos.y()), aabb.maxZ());
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        if (!this.canPlaceAt(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this, data + 1);
                break;
            }
            case PICK_BLOCK: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(this);
                break;
            }
            case EXPLOSION: 
            case PROPER_TOOL: {
                ItemStack[] itemStackArray4 = new ItemStack[1];
                itemStackArray = itemStackArray4;
                itemStackArray4[0] = new ItemStack(Items.AMMO_SNOWBALL, data + 1);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.getSavedLightValue(LightLayer.Block, tilePos) > 11) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
        if (!world.getBlockBiome(tilePos).hasTag(BiomeTags.HAS_SURFACE_SNOW) && world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().letWeatherCleanUpSnow) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
    }
}

