/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class ItemBlockLayer<T extends BlockLogicLayerBase>
extends ItemBlock<T> {
    public ItemBlockLayer(@NotNull Block<T> block) {
        super(block);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        int placeMeta;
        Block<?> targetBlock = world.getBlockType(tilePos);
        int meta = world.getBlockData(tilePos);
        if (targetBlock != this.block && targetBlock != null && targetBlock.hasTag(BlockTags.PLACE_OVERWRITES)) {
            targetBlock = null;
            meta = 0;
        }
        if (selfStack.stackSize <= 0 || tilePos.y() == world.getHeightBlocks() - 1 && this.block.getMaterial().isSolid()) {
            return false;
        }
        if (targetBlock == this.block && side == Side.TOP) {
            BlockLogicLayerBase blockLayer = (BlockLogicLayerBase)this.block.getLogic();
            int newMeta = meta + 1;
            AABBd bbBox = new AABBd(tilePos.x(), tilePos.y(), tilePos.z(), (float)tilePos.x() + 1.0f, (float)tilePos.y() + (float)(2 * (newMeta + 1)) / 16.0f, (float)tilePos.z() + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if (newMeta < 7) {
                world.setBlockTypeDataNotify(tilePos, this.block, newMeta);
            } else if (blockLayer.fullBlock != null) {
                world.setBlockTypeNotify(tilePos, blockLayer.fullBlock);
            } else {
                world.setBlockTypeNotify(tilePos.up(new TilePos()), this.block);
            }
            world.playBlockSoundEffect(player, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        if (targetBlock != null) {
            tilePos = tilePos.add(side.getDirection(), new TilePos());
            targetBlock = world.getBlockType(tilePos);
            meta = world.getBlockData(tilePos);
        }
        if (targetBlock == this.block) {
            BlockLogicLayerBase blockLayer = (BlockLogicLayerBase)this.block.getLogic();
            int newMeta = meta + 1;
            AABBd bbBox = new AABBd(tilePos.x(), tilePos.y(), tilePos.z(), (float)tilePos.x() + 1.0f, (float)tilePos.y() + (float)(2 * (newMeta + 1)) / 16.0f, (float)tilePos.z() + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if (newMeta < 7) {
                world.setBlockTypeDataNotify(tilePos, this.block, newMeta);
            } else if (blockLayer.fullBlock != null) {
                world.setBlockTypeNotify(tilePos, blockLayer.fullBlock);
            } else {
                world.setBlockTypeNotify(tilePos.up(new TilePos()), this.block);
            }
            world.playBlockSoundEffect(player, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        if (world.canBlockIdBePlacedAt(this.block.id(), tilePos, false, side) && world.setBlockTypeDataNotify(tilePos, this.block, placeMeta = this.getPlacedData(selfStack, world, player, tilePos, side, xHit, yHit))) {
            if (player == null) {
                this.block.onPlacedOnSide(world, tilePos, side, xHit, yHit);
            } else {
                this.block.onPlacedByMob(world, tilePos, Side.NONE, player, xHit, yHit);
            }
            world.playBlockSoundEffect(player, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        return false;
    }
}

