/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.BiomeTags;
import net.minecraft.core.world.biome.SurfaceProperties;
import net.minecraft.core.world.biome.drift.BiomeDrift;
import net.minecraft.core.world.biome.nether.BiomeCrystalForest;
import net.minecraft.core.world.biome.nether.BiomeNether;
import net.minecraft.core.world.biome.nether.BiomeSulfurPools;
import net.minecraft.core.world.biome.nether.BiomeVolcanoIslands;
import net.minecraft.core.world.biome.overworld.BiomeBirchForest;
import net.minecraft.core.world.biome.overworld.BiomeBorealForest;
import net.minecraft.core.world.biome.overworld.BiomeCaatinga;
import net.minecraft.core.world.biome.overworld.BiomeDesert;
import net.minecraft.core.world.biome.overworld.BiomeForest;
import net.minecraft.core.world.biome.overworld.BiomeOutback;
import net.minecraft.core.world.biome.overworld.BiomePlains;
import net.minecraft.core.world.biome.overworld.BiomeRainforest;
import net.minecraft.core.world.biome.overworld.BiomeRetro;
import net.minecraft.core.world.biome.overworld.BiomeSeasonalForest;
import net.minecraft.core.world.biome.overworld.BiomeShrubland;
import net.minecraft.core.world.biome.overworld.BiomeSwamp;
import net.minecraft.core.world.biome.overworld.BiomeTaiga;
import net.minecraft.core.world.biome.overworld.legacy.BiomeDesertLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeForestLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeRainforestLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeSwampLegacy;
import net.minecraft.core.world.biome.overworld.legacy.BiomeTaigaLegacy;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;

public class Biomes {
    @NotNull
    public static final Biome OVERWORLD_RAINFOREST = Biomes.register("minecraft:overworld.rainforest", new BiomeRainforest("overworld.rainforest").withDebugColor(1896704).withBlockedWeathers(Weathers.OVERWORLD_SNOW).withPlacementDefaults(0.975f, 0.925f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_SWAMPLAND = Biomes.register("minecraft:overworld.swampland", new BiomeSwamp("overworld.swampland").withDebugColor(65400).withPlacementDefaults(0.85f, 0.925f, 0.5f).withTags(BiomeTags.HAS_SURFACE_WATER, BiomeTags.HAS_SURFACE_MUD));
    @NotNull
    public static final Biome OVERWORLD_SEASONAL_FOREST = Biomes.register("minecraft:overworld.seasonal_forest", new BiomeSeasonalForest("overworld.seasonal_forest").withDebugColor(6606357).withPlacementDefaults(0.675f, 0.75f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_FOREST = Biomes.register("minecraft:overworld.forest", new BiomeForest("overworld.forest").withDebugColor(2532885).withPlacementDefaults(0.875f, 0.675f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_GRASSLANDS = Biomes.register("minecraft:overworld.grasslands", new Biome("overworld.grasslands").withDebugColor(15790152).withBlockedWeathers(Weathers.OVERWORLD_SNOW).withPlacementDefaults(0.75f, 0.025f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_OUTBACK = Biomes.register("minecraft:overworld.outback", new BiomeOutback("overworld.outback").withDebugColor(14245408).withBlockedWeathers(Weathers.OVERWORLD_SNOW).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.DIRT_SCORCHED).withFillerBlock(Blocks.DIRT_SCORCHED).build()).withPlacementDefaults(0.825f, 0.1f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_SHRUBLAND = Biomes.register("minecraft:overworld.shrubland", new BiomeShrubland("overworld.shrubland").withDebugColor(12237368).withPlacementDefaults(0.675f, 0.175f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_TAIGA = Biomes.register("minecraft:overworld.taiga", new BiomeTaiga("overworld.taiga").withDebugColor(9092351).withPlacementDefaults(0.15f, 0.55f, 0.5f).withTags(BiomeTags.HAS_SURFACE_SNOW, BiomeTags.HAS_SURFACE_ICE));
    @NotNull
    public static final Biome OVERWORLD_BOREAL_FOREST = Biomes.register("minecraft:overworld.boreal_forest", new BiomeBorealForest("overworld.boreal_forest").withDebugColor(1344868).withPlacementDefaults(0.4f, 0.525f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_DESERT = Biomes.register("minecraft:overworld.desert", new BiomeDesert("overworld.desert").withDebugColor(15589999).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.SAND).withFillerBlock(Blocks.SAND).build()).withPlacementDefaults(0.925f, 0.05f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_PLAINS = Biomes.register("minecraft:overworld.plains", new BiomePlains("overworld.plains").withDebugColor(10733129).withPlacementDefaults(0.875f, 0.25f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_GLACIER = Biomes.register("minecraft:overworld.glacier", new Biome("overworld.glacier").withDebugColor(13367039).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.BLOCK_SNOW).withFillerBlock(Blocks.BLOCK_SNOW).build()).withPlacementDefaults(0.15f, 0.005f, 0.5f).withTags(BiomeTags.HAS_SURFACE_SNOW, BiomeTags.DEEPER_SNOW));
    @NotNull
    public static final Biome OVERWORLD_TUNDRA = Biomes.register("minecraft:overworld.tundra", new Biome("overworld.tundra").withDebugColor(5759231).withPlacementDefaults(0.15f, 0.055f, 0.5f).withTags(BiomeTags.HAS_SURFACE_SNOW, BiomeTags.HAS_SURFACE_ICE));
    @NotNull
    public static final Biome OVERWORLD_MEADOW = Biomes.register("minecraft:overworld.meadow", new BiomeBorealForest("overworld.meadow").withDebugColor(0x8C8C22).withPlacementDefaults(0.4f, 0.025f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_BIRCH_FOREST = Biomes.register("minecraft:overworld.birch_forest", new BiomeBirchForest("overworld.birch_forest").withDebugColor(4967262).withPlacementDefaults(0.675f, 0.4f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_RETRO = Biomes.register("minecraft:overworld.retro", new BiomeRetro("overworld.retro").withDebugColor(7778634).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.GRASS_RETRO).build()));
    @NotNull
    public static final Biome OVERWORLD_HELL = Biomes.register("minecraft:overworld.hell", new Biome("overworld.hell").withDebugColor(14246435).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.DIRT_SCORCHED).withFillerBlock(Blocks.DIRT_SCORCHED).build()));
    @NotNull
    public static final Biome OVERWORLD_SWAMPLAND_MUDDY = Biomes.register("minecraft:overworld.swampland.muddy", new BiomeSwamp("overworld.swampland.muddy").withDebugColor(5383936).withPlacementDefaults(0.85f, 0.925f, 0.5f).withTags(BiomeTags.HAS_SURFACE_MUD));
    @NotNull
    public static final Biome OVERWORLD_OUTBACK_GRASSY = Biomes.register("minecraft:overworld.outback.grassy", new BiomeOutback("overworld.outback.grassy").withDebugColor(15765559).withBlockedWeathers(Weathers.OVERWORLD_SNOW).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.GRASS_SCORCHED).withFillerBlock(Blocks.DIRT_SCORCHED).build()).withPlacementDefaults(0.825f, 0.1f, 1.0f));
    @NotNull
    public static final Biome OVERWORLD_CAATINGA = Biomes.register("minecraft:overworld.caatinga", new BiomeCaatinga("overworld.caatinga").withDebugColor(14601638).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.MUD_BAKED).withFillerBlock(Blocks.MUD_BAKED).build()).withBlockedWeathers(Weathers.OVERWORLD_SNOW).withPlacementDefaults(0.95f, 0.015f, 0.5f).withTags(BiomeTags.HAS_SURFACE_MUD));
    @NotNull
    public static final Biome OVERWORLD_CAATINGA_PLAINS = Biomes.register("minecraft:overworld.caatinga.plains", new Biome("overworld.caatinga.plains").withDebugColor(10589303).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.MUD_BAKED).withFillerBlock(Blocks.MUD_BAKED).build()).withBlockedWeathers(Weathers.OVERWORLD_SNOW).withPlacementDefaults(0.95f, 0.015f, 0.0f).withTags(BiomeTags.HAS_SURFACE_MUD));
    @NotNull
    public static final Biome NETHER_CRAG = Biomes.register("minecraft:nether.crag", new BiomeNether("nether.crag").withDebugColor(6503997).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.COBBLE_NETHERRACK).withFillerBlock(Blocks.COBBLE_NETHERRACK).build()));
    @NotNull
    public static final Biome NETHER_VOLCANIC_ISLANDS = Biomes.register("minecraft:nether.volcanic_islands", new BiomeVolcanoIslands("nether.volcanic_islands").withDebugColor(0xFFA333).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.BRIMSAND).withFillerBlock(Blocks.BRIMSAND).build()));
    @NotNull
    public static final Biome NETHER_SULFUR_POOLS = Biomes.register("minecraft:nether.sulfur_pools", new BiomeSulfurPools("nether.sulfur_pools").withDebugColor(10721600).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.BRIMSAND).withFillerBlock(Blocks.BRIMSAND).build()).withTags(BiomeTags.HAS_SULFUR_POOLS));
    @NotNull
    public static final Biome NETHER_CRYSTAL_PLAINS = Biomes.register("minecraft:nether.crystal_plains", new BiomeCrystalForest("nether.crystal_plains").withDebugColor(0xAA0000).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.COBBLE_NETHERRACK).withFillerBlock(Blocks.COBBLE_NETHERRACK).build()).withTags(BiomeTags.HAS_CRYSTAL_VEINS));
    @NotNull
    public static final Biome NETHER_CRYSTAL_FOREST = Biomes.register("minecraft:nether.crystal_forest", new BiomeCrystalForest("nether.crystal_forest").withDebugColor(0xDD0000).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.COBBLE_NETHERRACK).withFillerBlock(Blocks.COBBLE_NETHERRACK).build()).withTags(BiomeTags.HAS_CRYSTAL_VEINS));
    @NotNull
    public static final Biome NETHER_OLD_WORLD = Biomes.register("minecraft:nether.old_world", new BiomeNether("nether.old_world").withDebugColor(6513792).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.COBBLE_NETHERRACK).withFillerBlock(Blocks.COBBLE_NETHERRACK).build()).withTags(BiomeTags.HAS_SURFACE_ASH));
    @NotNull
    public static final Biome NETHER_SHELF = Biomes.register("minecraft:nether.shelf", new BiomeNether("nether.shelf").withDebugColor(9865839).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.COBBLE_NETHERRACK).withFillerBlock(Blocks.COBBLE_NETHERRACK).build()));
    @NotNull
    public static final Biome DRIFT_DRIFT = Biomes.register("minecraft:drift.drift", new BiomeDrift("drift.drift").withDebugColor(0x8080FF).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM, Weathers.OVERWORLD_FOG).withPlacementDefaults(0.5f, 0.0f, 0.0f));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_RAINFOREST = Biomes.register("minecraft:overworld.legacy.rainforest", new BiomeRainforestLegacy("overworld.legacy.rainforest").withDebugColor(14278691).withBlockedWeathers(Weathers.OVERWORLD_SNOW).withPlacementDefaults(0.985f, 0.95f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_SWAMPLAND = Biomes.register("minecraft:overworld.legacy.swampland", new BiomeSwampLegacy("overworld.legacy.swampland").withDebugColor(522674).withPlacementDefaults(0.75f, 0.4f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_SEASONAL_FOREST = Biomes.register("minecraft:overworld.legacy.seasonal_forest", new Biome("overworld.legacy.seasonal_forest").withDebugColor(10215459).withPlacementDefaults(0.985f, 0.675f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_FOREST = Biomes.register("minecraft:overworld.legacy.forest", new BiomeForestLegacy("overworld.legacy.forest").withDebugColor(353825).withPlacementDefaults(0.735f, 0.425f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_SAVANNA = Biomes.register("minecraft:overworld.legacy.savanna", new BiomeDesertLegacy("overworld.legacy.savanna").withDebugColor(14278691).withBlockedWeathers(Weathers.OVERWORLD_SNOW).withPlacementDefaults(0.725f, 0.1f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_SHRUBLAND = Biomes.register("minecraft:overworld.legacy.shrubland", new Biome("overworld.legacy.shrubland").withDebugColor(10595616).withPlacementDefaults(0.735f, 0.275f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_TAIGA = Biomes.register("minecraft:overworld.legacy.taiga", new BiomeTaigaLegacy("overworld.legacy.taiga").withDebugColor(3060051).withPlacementDefaults(0.3f, 0.35f, 0.5f).withTags(BiomeTags.HAS_SURFACE_SNOW, BiomeTags.HAS_SURFACE_ICE));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_DESERT = Biomes.register("minecraft:overworld.legacy.desert", new BiomeDesertLegacy("overworld.legacy.desert").withDebugColor(16421912).withBlockedWeathers(Weathers.OVERWORLD_RAIN, Weathers.OVERWORLD_SNOW, Weathers.OVERWORLD_STORM).withSurfaceProperties(new SurfaceProperties.Builder().withTopBlock(Blocks.SAND).withFillerBlock(Blocks.SAND).build()).withPlacementDefaults(0.975f, 0.1f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_PLAINS = Biomes.register("minecraft:overworld.legacy.plains", new BiomeDesertLegacy("overworld.legacy.plains").withDebugColor(16767248).withPlacementDefaults(0.985f, 0.325f, 0.5f));
    @NotNull
    public static final Biome OVERWORLD_LEGACY_TUNDRA = Biomes.register("minecraft:overworld.legacy.tundra", new Biome("overworld.legacy.tundra").withDebugColor(5762041).withPlacementDefaults(0.05f, 0.5f, 0.5f).withTags(BiomeTags.HAS_SURFACE_SNOW, BiomeTags.HAS_SURFACE_ICE));

    @NotNull
    public static Biome register(@NotNull String key, @NotNull Biome biome) {
        Registries.BIOMES.register(key, biome);
        return biome;
    }

    public static void init() {
    }
}

