/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicPumpkinRedstone
extends BlockLogicVeryRotatable {
    public BlockLogicPumpkinRedstone(@NotNull Block<?> block) {
        super(block, Materials.VEGETABLE);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        for (Direction dir : Direction.directions) {
            world.notifyBlocksOfNeighborChange(tilePos.add(dir, queryPos), this.block);
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        TilePos queryPos = new TilePos();
        for (Direction dir : Direction.directions) {
            world.notifyBlocksOfNeighborChange(tilePos.add(dir, queryPos), this.block);
        }
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.isEmittingSignal(world, tilePos, side);
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        Side mySide = Side.getSideById(source.getBlockData(tilePos));
        return mySide == side.getOpposite();
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return 0;
    }
}

