/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.SpawnListEntry;
import net.minecraft.core.entity.animal.MobButterfly;
import net.minecraft.core.entity.animal.MobChicken;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.animal.MobDeer;
import net.minecraft.core.entity.animal.MobFireflyCluster;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.monster.MobSnowman;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.enums.MobCategory;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.SurfaceProperties;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTree;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeFancy;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.weather.Weather;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Biome
implements ITaggable<Biome> {
    @NotNull
    public final String translationKey;
    public int color = 0xFF00FF;
    @NotNull
    public final @NotNull List<@NotNull Weather> blockedWeathers = new ArrayList<Weather>();
    @NotNull
    protected final @NotNull List<@NotNull SpawnListEntry> spawnableMonsterList = new ArrayList<SpawnListEntry>();
    @NotNull
    protected final @NotNull List<@NotNull SpawnListEntry> spawnableCreatureList = new ArrayList<SpawnListEntry>();
    @NotNull
    protected final @NotNull List<@NotNull SpawnListEntry> spawnableWaterCreatureList = new ArrayList<SpawnListEntry>();
    @NotNull
    protected final @NotNull List<@NotNull SpawnListEntry> spawnableAmbientCreatureList = new ArrayList<SpawnListEntry>();
    public float defaultTemperature = 0.5f;
    public float defaultHumidity = 0.5f;
    public float defaultVariety = 0.5f;
    @NotNull
    private SurfaceProperties surfaceProperties;

    public Biome(@NotNull String key) {
        this.translationKey = "biome." + key;
        this.surfaceProperties = new SurfaceProperties.Builder().build();
        Biome.initSpawnables(this.spawnableMonsterList, this.spawnableCreatureList, this.spawnableWaterCreatureList, this.spawnableAmbientCreatureList);
    }

    static void initSpawnables(@NotNull @NotNull List<@NotNull SpawnListEntry> monsters, @NotNull @NotNull List<@NotNull SpawnListEntry> creatures, @NotNull @NotNull List<@NotNull SpawnListEntry> waterCreatures, @NotNull @NotNull List<@NotNull SpawnListEntry> ambientCreatures) {
        monsters.add(new SpawnListEntry(MobSpider.class, 10));
        monsters.add(new SpawnListEntry(MobZombie.class, 10));
        monsters.add(new SpawnListEntry(MobZombieArmored.class, 2));
        monsters.add(new SpawnListEntry(MobSkeleton.class, 10));
        monsters.add(new SpawnListEntry(MobCreeper.class, 10));
        monsters.add(new SpawnListEntry(MobSlime.class, 10));
        monsters.add(new SpawnListEntry(MobSnowman.class, 2));
        creatures.add(new SpawnListEntry(MobSheep.class, 102));
        creatures.add(new SpawnListEntry(MobPig.class, 102));
        creatures.add(new SpawnListEntry(MobChicken.class, 102));
        creatures.add(new SpawnListEntry(MobCow.class, 102));
        creatures.add(new SpawnListEntry(MobDeer.class, 10));
        waterCreatures.add(new SpawnListEntry(MobSquid.class, 10));
        ambientCreatures.add(new SpawnListEntry(MobFireflyCluster.class, 10));
        ambientCreatures.add(new SpawnListEntry(MobButterfly.class, 65));
    }

    @NotNull
    public Biome withPlacementDefaults(float temperature, float humidity, float variety) {
        this.defaultTemperature = temperature;
        this.defaultHumidity = humidity;
        this.defaultVariety = variety;
        return this;
    }

    @SafeVarargs
    @NotNull
    public final Biome withTags(Tag<Biome> ... tags) {
        for (Tag<Biome> tag : tags) {
            tag.tag(this);
        }
        return this;
    }

    @NotNull
    public Biome withDebugColor(int color) {
        this.color = color;
        return this;
    }

    @NotNull
    public Biome withBlockedWeathers(Weather ... blocked) {
        this.blockedWeathers.clear();
        this.blockedWeathers.addAll(Arrays.asList(blocked));
        return this;
    }

    @NotNull
    public Biome withSurfaceProperties(@NotNull SurfaceProperties surfaceProperties) {
        this.surfaceProperties = surfaceProperties;
        return this;
    }

    @NotNull
    public SurfaceProperties getSurfaceProperties() {
        return this.surfaceProperties;
    }

    @NotNull
    public WorldFeature getTreeFeature(@NotNull Random random) {
        if (random.nextInt(10) == 0) {
            return new WorldFeatureTreeFancy(Blocks.LEAVES_OAK.id(), Blocks.LOG_OAK.id());
        }
        return new WorldFeatureTree(Blocks.LEAVES_OAK.id(), Blocks.LOG_OAK.id(), 4);
    }

    public int getSkyColor(float temperature) {
        if ((temperature /= 3.0f) < -1.0f) {
            temperature = -1.0f;
        }
        if (temperature > 1.0f) {
            temperature = 1.0f;
        }
        return Color.getHSBColor(0.6222222f - temperature * 0.125f, 0.5f + temperature * 0.1f, 1.0f).getRGB();
    }

    @NotNull
    public @NotNull List<@NotNull SpawnListEntry> getSpawnableList(@NotNull MobCategory category) {
        return switch (category) {
            default -> throw new IncompatibleClassChangeError();
            case MobCategory.MONSTER -> this.spawnableMonsterList;
            case MobCategory.CREATURE -> this.spawnableCreatureList;
            case MobCategory.WATER_CREATURE -> this.spawnableWaterCreatureList;
            case MobCategory.AMBIENT -> this.spawnableAmbientCreatureList;
        };
    }

    @Nullable
    public static TilePosc getBiomeCoords(@NotNull Biome biome, @NotNull World world) {
        int[] xPattern = new int[]{0, 1, 0, -1};
        int[] zPattern = new int[]{1, 0, -1, 0};
        @NotNull TilePos sourcePos = new TilePos();
        int runLength = 2;
        int chunkX = (int)((double)sourcePos.x() / 16.0);
        int chunkZ = (int)((double)sourcePos.z() / 16.0);
        int passes = 1024;
        if (world.getBiomeProvider().getBiome(sourcePos.x(), sourcePos.y(), sourcePos.z()) == biome) {
            return sourcePos;
        }
        --chunkX;
        --chunkZ;
        for (int pass = 0; pass < passes; ++pass) {
            for (int i = 0; i < 4; ++i) {
                for (int j = runLength - 1; j >= 0; --j) {
                    if (world.getBiomeProvider().getBiome((chunkX += xPattern[i]) * 16, sourcePos.y(), (chunkZ += zPattern[i]) * 16) != biome) continue;
                    return new TilePos(chunkX * 16, sourcePos.y(), chunkZ * 16);
                }
            }
            ++runLength;
        }
        return null;
    }

    public boolean hasTag(@NotNull Tag<Biome> tag) {
        return tag.appliesTo(this);
    }

    @Override
    public boolean isIn(@NotNull Tag<Biome> tag) {
        return tag.appliesTo(this);
    }
}

