/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.LightIndexHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkPosc;
import net.minecraft.core.world.pos.ChunkTilePos;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.season.SeasonManager;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.WeatherManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkCache
implements WorldSource {
    @NotNull
    private final ChunkPos origin;
    @NotNull
    private final @NotNull Chunk @NotNull [] chunkArray;
    @NotNull
    private final World world;
    private final int widthX;
    private final int widthZ;
    @NotNull
    private final TilePos queryTilePos = new TilePos();
    @NotNull
    private final ChunkTilePos queryChunkTilePos = new ChunkTilePos();

    public ChunkCache(@NotNull World world, @NotNull TilePos min, @NotNull TilePos max, boolean priority) {
        this.world = world;
        this.origin = new ChunkPos(min);
        @NotNull ChunkPos chunkMax = new ChunkPos(max);
        this.widthX = chunkMax.x - this.origin.x + 1;
        this.widthZ = chunkMax.z - this.origin.z + 1;
        this.chunkArray = new Chunk[this.widthX * this.widthZ];
        for (int x = 0; x < this.widthX; ++x) {
            for (int z = 0; z < this.widthZ; ++z) {
                int index = z * this.widthX + x;
                this.chunkArray[index] = this.world.getChunk(new ChunkPos(x + this.origin.x, z + this.origin.z), priority);
            }
        }
    }

    @Deprecated
    public ChunkCache(@NotNull World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this(world, new TilePos(minX, minY, minZ), new TilePos(maxX, maxY, maxZ), true);
    }

    public boolean allLoaded() {
        for (int x = 0; x < this.widthX; ++x) {
            for (int z = 0; z < this.widthZ; ++z) {
                if (this.world.isChunkLoaded(new ChunkPos(x + this.origin.x, z + this.origin.z))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public Chunk getChunk(@NotNull ChunkPosc chunkPos) {
        int index = (chunkPos.z() - this.origin.z()) * this.widthX + chunkPos.x() - this.origin.x();
        return this.chunkArray[index];
    }

    @NotNull
    public Chunk getChunk(@NotNull TilePosc tilePos) {
        int index = ((tilePos.z() >> 4) - this.origin.z()) * this.widthX + (tilePos.x() >> 4) - this.origin.x();
        return this.chunkArray[index];
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        return chunkX >= this.origin.x() && chunkZ >= this.origin.z() && chunkX < this.origin.x() + this.widthX && chunkZ < this.origin.z() + this.widthZ;
    }

    public boolean isChunkLoaded(@NotNull ChunkPosc chunkPos) {
        return this.isChunkLoaded(chunkPos.x(), chunkPos.z());
    }

    public boolean isChunkLoaded(@NotNull TilePosc tilePos) {
        return this.isChunkLoaded(tilePos.x() >> 4, tilePos.z() >> 4);
    }

    @Override
    public int getHeightBlocks() {
        return this.world.getHeightBlocks();
    }

    @Override
    @NotNull
    public Block<?> getBlockType(@NotNull TilePosc tilePos) {
        if (tilePos.y() < 0 || tilePos.y() >= this.getHeightBlocks()) {
            return Blocks.AIR;
        }
        if (!this.isChunkLoaded(tilePos)) {
            return Blocks.AIR;
        }
        return this.getChunk(tilePos).getBlock(this.queryChunkTilePos.set(tilePos));
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(@NotNull TilePosc tilePos) {
        return this.getChunk(tilePos).getTileEntity(this.queryChunkTilePos.set(tilePos));
    }

    public boolean getBlockLitInteriorSurface(@NotNull TilePosc tilePos) {
        if (!tilePos.inBounds(this)) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this, tilePos);
    }

    @Override
    public float getBrightness(@NotNull TilePosc tilePos, int lightEmission) {
        int lightValue = this.getBlockLightValue(tilePos);
        return this.world.getWorldType().getBrightnessRamp()[Math.max(lightValue, lightEmission)];
    }

    @Override
    public byte getLightIndex(@NotNull TilePosc tilePos, int lightEmission) {
        byte lightIndex = this.getSavedLightIndex(tilePos);
        lightIndex = LightIndexHelper.max(lightIndex, (byte)lightEmission);
        if (this.getBlockLitInteriorSurface(tilePos)) {
            lightIndex = LightIndexHelper.max(lightIndex, this.getSavedLightIndex(tilePos.up(this.queryTilePos)));
            lightIndex = LightIndexHelper.max(lightIndex, this.getSavedLightIndex(tilePos.down(this.queryTilePos)));
            lightIndex = LightIndexHelper.max(lightIndex, this.getSavedLightIndex(tilePos.east(this.queryTilePos)));
            lightIndex = LightIndexHelper.max(lightIndex, this.getSavedLightIndex(tilePos.west(this.queryTilePos)));
            lightIndex = LightIndexHelper.max(lightIndex, this.getSavedLightIndex(tilePos.south(this.queryTilePos)));
            lightIndex = LightIndexHelper.max(lightIndex, this.getSavedLightIndex(tilePos.north(this.queryTilePos)));
        }
        return lightIndex;
    }

    @Override
    public float getLightBrightness(@NotNull TilePosc tilePos) {
        return this.world.getWorldType().getBrightnessRamp()[this.getBlockLightValue(tilePos)];
    }

    public int getBlockLightValue(@NotNull TilePosc tilePos) {
        return this.getBlockLightValue_do(tilePos, true);
    }

    @Deprecated
    private int getBlockLightValue_do(@NotNull TilePosc tilePos, boolean first) {
        if (tilePos.x() < -32000000 || tilePos.z() < -32000000 || tilePos.x() >= 32000000 || tilePos.z() > 32000000) {
            return 15;
        }
        if (first && this.getBlockLitInteriorSurface(tilePos)) {
            int lightUp = this.getBlockLightValue_do(tilePos.up(this.queryTilePos), false);
            int lightEast = this.getBlockLightValue_do(tilePos.east(this.queryTilePos), false);
            int lightWest = this.getBlockLightValue_do(tilePos.west(this.queryTilePos), false);
            int lightSouth = this.getBlockLightValue_do(tilePos.south(this.queryTilePos), false);
            int lightNorth = this.getBlockLightValue_do(tilePos.north(this.queryTilePos), false);
            return Math.max(lightUp, Math.max(lightEast, Math.max(lightWest, Math.max(lightSouth, lightNorth))));
        }
        if (tilePos.y() < 0) {
            return 0;
        }
        if (tilePos.y() >= this.getHeightBlocks()) {
            int brightness = 15 - this.world.skyDarken;
            if (brightness < 0) {
                brightness = 0;
            }
            return brightness;
        }
        return this.getChunk(tilePos).getRawSkyLightLevel(this.queryChunkTilePos.set(tilePos), this.world.skyDarken);
    }

    @Override
    public int getBlockData(@NotNull TilePosc tilePos) {
        if (tilePos.y() < 0 || tilePos.y() >= this.getHeightBlocks()) {
            return 0;
        }
        return this.getChunk(tilePos).getBlockData(this.queryChunkTilePos.set(tilePos));
    }

    @Override
    @NotNull
    public Material getBlockMaterial(@NotNull TilePosc tilePos) {
        return this.getBlockType(tilePos).getMaterial();
    }

    @Override
    public boolean isBlockOpaqueCube(@NotNull TilePosc tilePos) {
        return this.getBlockType(tilePos).isSolidRender();
    }

    @Override
    public boolean isBlockNormalCube(@NotNull TilePosc tilePos) {
        @Nullable Block<?> block = this.getBlockType(tilePos);
        return block.getMaterial().isSolidBlocking() && block.renderAsNormalBlockOnCondition(this, tilePos);
    }

    @Override
    public double getBlockTemperature(@NotNull TilePosc tilePos) {
        return this.world.getBlockTemperature(tilePos);
    }

    @Override
    public double getBlockHumidity(@NotNull TilePosc tilePos) {
        return this.world.getBlockHumidity(tilePos);
    }

    @Override
    public double getBlockVariety(@NotNull TilePosc tilePos) {
        return this.world.getBlockVariety(tilePos);
    }

    @Override
    @NotNull
    public SeasonManager getSeasonManager() {
        return this.world.getSeasonManager();
    }

    @Override
    @NotNull
    public WeatherManager getWeatherManager() {
        return this.world.getWeatherManager();
    }

    @Override
    @NotNull
    public Biome getBlockBiome(@NotNull TilePosc tilePos) {
        return this.world.getBlockBiome(tilePos);
    }

    @Override
    public int getSavedLightValue(@NotNull LightLayer lightLayer, @NotNull TilePosc tilePos) {
        if (tilePos.y() < 0 || tilePos.y() >= this.getHeightBlocks()) {
            return lightLayer.defaultLightLevel;
        }
        if (!this.isChunkLoaded(tilePos)) {
            return 0;
        }
        return this.getChunk(tilePos).getLightLevel(lightLayer, this.queryChunkTilePos.set(tilePos));
    }

    @Override
    public byte getSavedLightIndex(@NotNull TilePosc tilePos) {
        if (tilePos.y() < 0 || tilePos.y() >= this.getHeightBlocks()) {
            return LightLayer.DEFAULT_LIGHT_INDEX;
        }
        if (!this.isChunkLoaded(tilePos)) {
            return 0;
        }
        return this.getChunk(tilePos).getLightIndex(this.queryChunkTilePos.set(tilePos));
    }

    @Override
    @NotNull
    public Dimension getDimension() {
        return this.world.getDimension();
    }

    @Override
    @NotNull
    public WorldType getWorldType() {
        return this.world.getWorldType();
    }
}

