/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecoration;
import net.minecraft.core.world.generate.chunk.PlaceableFeature;
import net.minecraft.core.world.generate.chunk.PlacementMethod;
import net.minecraft.core.world.generate.chunk.PlacementMethods;
import net.minecraft.core.world.generate.chunk.PositionSelector;
import net.minecraft.core.world.generate.chunk.PositionSelectors;
import net.minecraft.core.world.generate.feature.WorldFeatureInterface;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ChunkDecorationBuilder
implements ChunkDecoration {
    private final WorldFeatureInterface worldFeature;
    @NotNull
    private PlacementMethod placementMethod = PlacementMethods.OncePerChunk;
    @NotNull
    private Biome[] biomeMask = new Biome[0];
    @NotNull
    private PositionSelector positionSelector = PositionSelectors.SurfaceBlock;

    public ChunkDecorationBuilder(@NotNull WorldFeatureInterface worldFeature) {
        this.worldFeature = worldFeature;
    }

    public ChunkDecorationBuilder withBiomeMask(@NotNull Biome[] biomes) {
        this.biomeMask = biomes;
        return this;
    }

    public ChunkDecorationBuilder withPositionSelector(PositionSelector positionSelector) {
        this.positionSelector = positionSelector;
        return this;
    }

    public ChunkDecorationBuilder withPlacementMethod(PlacementMethod placementMethod) {
        this.placementMethod = placementMethod;
        return this;
    }

    @Override
    public void placeDecoration(@NotNull World world, @NotNull Chunk chunk, int worldX, int worldZ, int minY, int maxY, int rangeY, @NotNull Random rand) {
        if (this.biomeMask.length > 0 && !Arrays.asList(this.biomeMask).contains(world.getBlockBiome(new TilePos(worldX, minY, worldZ)))) {
            return;
        }
        this.placementMethod.placeFeature(new PlaceableFeature(this.worldFeature, this.positionSelector, minY, maxY, rangeY), world, chunk, rand);
    }
}

