/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlowstone;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class WorldFeatureSpeleothems
extends WorldFeature {
    protected final int maxRadius;
    protected final boolean generateBottom;
    protected final int maxHeight;
    protected final boolean checkDepth;

    public WorldFeatureSpeleothems(int maxRadius, boolean generateBottom, int maxHeight, boolean checkDepth) {
        this.maxRadius = maxRadius;
        this.generateBottom = generateBottom;
        this.maxHeight = maxHeight;
        this.checkDepth = checkDepth;
    }

    @Override
    public boolean place(@NotNull World world, @NotNull Random random, int x, int y, int z) {
        @NotNull TilePos tilePos = new TilePos(x, y, z);
        @NotNull TilePos queryPos = new TilePos();
        @NotNull Block<?> baseBlock = Blocks.COBBLE_NETHERRACK;
        if (world.getBlockType(tilePos) == Blocks.AIR) {
            tilePos.up(queryPos);
            if (world.getBlockType(queryPos) != Blocks.AIR) {
                ++y;
            } else {
                return false;
            }
        }
        int radius = random.nextInt(this.maxRadius) + this.maxRadius;
        int depth = radius * 2;
        if (this.checkDepth) {
            for (int i = y - 1; i > y - depth; --i) {
                queryPos.set(x, i, z);
                if (world.getBlockType(queryPos) == Blocks.AIR) continue;
                return false;
            }
        }
        int numBaseBlocks = radius * 2 * (radius * 2);
        for (int i = 0; i < numBaseBlocks; ++i) {
            int dx = radius - random.nextInt(radius * 2);
            int dy = 0;
            int dz = radius - random.nextInt(radius * 2);
            if (world.getBlockType(queryPos.set(x + dx, y, z + dz)) == baseBlock) continue;
            int distance = dx * dz;
            if (distance == 0) {
                if (dx == 0 && dz == 0) {
                    distance = 1;
                } else if (dx == 0) {
                    distance = dz;
                } else if (dz == 0) {
                    distance = dx;
                }
            }
            if (random.nextInt(Math.abs(distance)) != 0) {
                --i;
                continue;
            }
            if (world.getBlockType(queryPos.set(x + dx, y, z + dz)) == Blocks.AIR) {
                dy = 1;
                if (world.getBlockType(queryPos.set(x + dx, y + 1, z + dz)) == Blocks.AIR) continue;
            }
            if (world.getBlockType(queryPos.set(x + dx, y - 1, z + dz)) != Blocks.AIR) {
                dy = -1;
                if (world.getBlockType(queryPos.set(x + dx, y - 2, z + dz)) != Blocks.AIR) continue;
            }
            world.setBlockTypeNotify(queryPos.set(x + dx, y + dy, z + dz), baseBlock);
            if (random.nextInt(5) != 0) continue;
            int height = random.nextInt(depth - radius - 1) + 1;
            if (this.maxHeight > -1 && height > this.maxHeight) {
                height = this.maxHeight;
            }
            this.placeSpeleothem(world, queryPos.set(x + dx, y + dy, z + dz), height);
            if (!this.generateBottom || random.nextInt(3) != 0) continue;
            int bottom = -1;
            for (int j = height + 1; j < depth * 2; ++j) {
                if (world.getBlockType(queryPos.set(x + dx, y + dy - j, z + dz)) == Blocks.AIR) continue;
                bottom = y + dy - j;
                break;
            }
            if (bottom == -1) continue;
            this.placeSpeleothem(world, queryPos.set(x + dx, bottom, z + dz), -height / 2);
        }
        return true;
    }

    private boolean placeSpeleothem(@NotNull World world, @NotNull TilePosc pos, int height) {
        int i;
        if (height == 0) {
            return false;
        }
        @NotNull Block<BlockLogicFlowstone> block = Blocks.FLOWSTONE;
        @NotNull TilePos queryPos = new TilePos(pos);
        int absHeight = Math.abs(height);
        int dy = height < 0 ? 1 : -1;
        for (i = 0; i < absHeight; ++i) {
            queryPos.y += dy;
            if (world.getBlockType(queryPos) == Blocks.AIR) continue;
            return false;
        }
        queryPos.set(pos);
        if (absHeight <= 4) {
            int data = 4 - absHeight;
            for (int i2 = 0; i2 < absHeight; ++i2) {
                queryPos.y += dy;
                world.setBlockTypeData(queryPos, block, data);
                ++data;
            }
        } else {
            for (i = 0; i < absHeight; ++i) {
                float progress = (float)i / (float)absHeight;
                int data = (int)(progress * 4.0f);
                queryPos.y += dy;
                world.setBlockTypeData(queryPos, block, data);
            }
        }
        return true;
    }
}

