/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.weatherable.operation;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.generate.feature.weatherable.Operation;
import net.minecraft.core.world.structure.EditableStructure;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class CollapseOperation
implements Operation {
    @Override
    public void apply(@NotNull EditableStructure structure, @NotNull Random random) {
        int y;
        int collapsedY0;
        Vector3ic size = structure.getSize();
        int x = random.nextInt(size.x());
        int z = random.nextInt(size.z());
        int y0 = size.y() - 1;
        int y1 = size.y() - 1;
        @NotNull Vector3i queryPos = new Vector3i();
        while (structure.getBlockType(queryPos.set(x, y1, z)) == Blocks.AIR && y1 > 0) {
            --y1;
            --y0;
        }
        while (structure.getBlockType(queryPos.set(x, y0 - 1, z)) != Blocks.AIR && y0 > 0) {
            --y0;
        }
        for (collapsedY0 = y0; structure.getBlockType(queryPos.set(x, collapsedY0 - 1, z)) == Blocks.AIR && collapsedY0 > 0; --collapsedY0) {
        }
        int fallDistance = y0 - collapsedY0;
        int collapsedY1 = y1 - fallDistance;
        for (y = collapsedY0; y <= collapsedY1; ++y) {
            structure.setBlockTypeData(new Vector3i(x, y, z), structure.getBlockType(queryPos.set(x, y + fallDistance, z)), structure.getBlockData(queryPos));
        }
        for (y = collapsedY1 + 1; y <= y1; ++y) {
            structure.setBlockType(queryPos.set(x, y, z), Blocks.AIR);
        }
    }
}

