/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.structure;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class DummyStructure
implements Structure {
    @NotNull
    private final Vector3i size;
    @NotNull
    private final Vector3i origin;

    public DummyStructure(@NotNull Vector3i size) {
        this.size = size;
        this.origin = new Vector3i(size.x / 2, 1, size.z / 2);
    }

    @Override
    @NotNull
    public Vector3ic getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Vector3ic getOrigin() {
        return this.origin;
    }

    @Override
    @NotNull
    public Block<?> getBlockType(@NotNull Vector3ic pos) {
        if ((pos.y() == 1 || pos.y() == 2) && pos.x() == 0 && pos.z() == this.size.z / 2) {
            return Blocks.AIR;
        }
        if (pos.x() == 0 && pos.z() == 0 || pos.x() == this.size.x - 1 && pos.z() == this.size.z - 1 || pos.x() == 0 && pos.z() == this.size.z - 1 || pos.x() == this.size.x - 1 && pos.z() == 0) {
            return Blocks.BRICK_STONE_POLISHED;
        }
        if (pos.x() == 0 || pos.x() == this.size.x - 1 || pos.z() == 0 || pos.z() == this.size.z - 1) {
            if (pos.y() % 6 == 0) {
                return Blocks.STONE_CARVED;
            }
            int total = pos.x() * 3 + pos.y() * 2 + pos.z() ^ 0x12345678;
            if (total % 3 == 0) {
                return Blocks.STONE;
            }
            if (total % 3 == 1) {
                return Blocks.COBBLE_STONE;
            }
            return Blocks.BRICK_STONE;
        }
        if (pos.y() == 0 || pos.y() == this.size.y - 1) {
            return Blocks.PLANKS_OAK;
        }
        return Blocks.AIR;
    }

    @Override
    public int getBlockData(@NotNull Vector3ic pos) {
        return 0;
    }
}

