/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import net.minecraft.core.block.BlockLogicOreNetherCoal;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.BiomeTags;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecoration;
import net.minecraft.core.world.generate.chunk.ChunkDecorationBuilder;
import net.minecraft.core.world.generate.chunk.ChunkFeatureDecorator;
import net.minecraft.core.world.generate.chunk.PlacementMethod;
import net.minecraft.core.world.generate.chunk.PlacementMethods;
import net.minecraft.core.world.generate.chunk.PositionSelectors;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.WorldFeatureFire;
import net.minecraft.core.world.generate.feature.WorldFeatureFloorVent;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneA;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneB;
import net.minecraft.core.world.generate.feature.WorldFeatureLake;
import net.minecraft.core.world.generate.feature.WorldFeatureMagmaBoulder;
import net.minecraft.core.world.generate.feature.WorldFeatureNetherPatch;
import net.minecraft.core.world.generate.feature.WorldFeatureNetherSpring;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;
import net.minecraft.core.world.generate.feature.WorldFeaturePillar;
import net.minecraft.core.world.generate.feature.WorldFeatureRubyglassCrystal;
import net.minecraft.core.world.generate.feature.WorldFeatureRubyglassSproutPatch;
import net.minecraft.core.world.generate.feature.WorldFeatureSpeleothems;
import net.minecraft.core.world.generate.feature.WorldFeatureTerrace;
import net.minecraft.core.world.generate.feature.WorldFeatureThermalSpire;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureBoneshaleTree;
import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;
import net.minecraft.core.world.noise.Noise2D;
import org.jetbrains.annotations.NotNull;

public class ChunkDecoratorNether
extends ChunkFeatureDecorator {
    @NotNull
    private final FractalNoise2D<ImprovedPerlinNoise> crystalDensityNoise;

    public ChunkDecoratorNether(@NotNull World world) {
        super(world);
        this.crystalDensityNoise = new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 8, 74));
    }

    @Override
    public void registerDecorations() {
        this.register("minecraft:decoration/nether/default/speleothems", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureSpeleothems(12, true, 12, true)).withPositionSelector(PositionSelectors.UpperHeightRangeUniform).withPlacementMethod(new PlacementMethod.TriesPerChunk(4)));
        this.register("minecraft:decoration/nether/default/lava_lake", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureLake(Blocks.FLUID_LAVA_STILL.id())).withPositionSelector(PositionSelectors.UpperHeightRangeUniform).withPlacementMethod(new PlacementMethod.ChanceToPlace(4)));
        this.register("minecraft:decoration/nether/default/rubyglass_crystal_ceiling", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureRubyglassCrystal(true)).withBiomeMask(new Biome[]{Biomes.NETHER_CRYSTAL_FOREST}).withPositionSelector(PositionSelectors.UpperHeightRangeUniform).withPlacementMethod((feature, world, chunk, random) -> {
            int x = chunk.pos.x * 16;
            int z = chunk.pos.z * 16;
            int density = (int)((this.crystalDensityNoise.getValue((double)x * 0.5, (double)z * 0.5) - 6.0 + 30.0) / 6.0);
            for (int i = 0; i < density + 4; ++i) {
                feature.placeFeature(world, chunk, random);
            }
        }));
        this.register("minecraft:decoration/nether/default/rubyglass_crystal_floor", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureRubyglassCrystal(false, 25, 50)).withBiomeMask(new Biome[]{Biomes.NETHER_CRYSTAL_FOREST}).withPositionSelector(PositionSelectors.UpperHeightRangeUniform).withPlacementMethod((feature, world, chunk, random) -> {
            int x = chunk.pos.x * 16;
            int z = chunk.pos.z * 16;
            int density = (int)((this.crystalDensityNoise.getValue((double)x * 0.5, (double)z * 0.5) - 6.0 + 30.0) / 6.0);
            for (int i = 0; i < density + 4; ++i) {
                feature.placeFeature(world, chunk, random);
            }
        }));
        this.register("minecraft:decoration/nether/default/rubyglass_crystal_floor_2", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureRubyglassCrystal(false, 20, 30)).withBiomeMask(new Biome[]{Biomes.NETHER_CRYSTAL_FOREST, Biomes.NETHER_CRYSTAL_PLAINS}).withPositionSelector(PositionSelectors.UpperHeightRangeUniform).withPlacementMethod(new PlacementMethod.TriesPerChunk(4)));
        this.register("minecraft:decoration/nether/default/rubyglass_sprout_patch", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureRubyglassSproutPatch()).withBiomeMask(new Biome[]{Biomes.NETHER_CRYSTAL_FOREST, Biomes.NETHER_CRYSTAL_PLAINS}).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(20)));
        this.register("minecraft:decoration/nether/default/nether_water_spring", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureNetherSpring(Blocks.FLUID_WATER_FLOWING.id())).withBiomeMask(new Biome[]{Biomes.NETHER_CRYSTAL_FOREST, Biomes.NETHER_CRYSTAL_PLAINS, Biomes.NETHER_OLD_WORLD}).withPositionSelector(PositionSelectors.HeightRangeBiasedTop).withPlacementMethod(new PlacementMethod.TriesPerChunk(30)));
        this.register("minecraft:decoration/nether/default/nether_lava_spring", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureNetherSpring(Blocks.FLUID_LAVA_FLOWING.id())).withBiomeMask(new Biome[]{Biomes.NETHER_VOLCANIC_ISLANDS, Biomes.NETHER_SULFUR_POOLS, Biomes.NETHER_CRAG, Biomes.NETHER_SHELF}).withPositionSelector(PositionSelectors.HeightRangeBiasedTop).withPlacementMethod(new PlacementMethod.TriesPerChunk(30)));
        this.register("minecraft:decoration/nether/default/nether_lava_spring_2", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureNetherSpring(Blocks.FLUID_LAVA_FLOWING.id())).withBiomeMask(new Biome[]{Biomes.NETHER_VOLCANIC_ISLANDS}).withPositionSelector(PositionSelectors.HeightRangeBiasedTop).withPlacementMethod(new PlacementMethod.TriesPerChunk(20)));
        this.register("minecraft:decoration/nether/default/pillar_netherrack", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeaturePillar(Blocks.NETHERRACK.id(), false)).withBiomeMask(new Biome[]{Biomes.NETHER_CRYSTAL_PLAINS, Biomes.NETHER_CRYSTAL_FOREST, Biomes.NETHER_CRAG, Biomes.NETHER_SHELF}).withPositionSelector(PositionSelectors.UpperHeightRangeUniform).withPlacementMethod(new PlacementMethod.ChanceToPlace(4)));
        this.register("minecraft:decoration/nether/default/pillar_cobble_basalt", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeaturePillar(Blocks.COBBLE_BASALT.id(), true)).withBiomeMask(new Biome[]{Biomes.NETHER_SULFUR_POOLS, Biomes.NETHER_VOLCANIC_ISLANDS}).withPositionSelector(PositionSelectors.UpperHeightRangeUniform).withPlacementMethod(new PlacementMethod.TriesPerChunk(4)));
        this.register("minecraft:decoration/nether/default/boulder", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureMagmaBoulder()).withBiomeMask(new Biome[]{Biomes.NETHER_SULFUR_POOLS, Biomes.NETHER_VOLCANIC_ISLANDS}).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(2)));
        this.register("minecraft:decoration/nether/default/sulfur_pool_terrace", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureTerrace(Blocks.FLUID_WATER_STILL, Blocks.BRIMSAND)).withBiomeMask(new Biome[]{Biomes.NETHER_SULFUR_POOLS}).withPositionSelector(PositionSelectors.MinY).withPlacementMethod(PlacementMethods.OncePerChunk));
        this.register("minecraft:decoration/nether/default/lava_pool_terrace", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureTerrace(Blocks.FLUID_LAVA_STILL, Blocks.COBBLE_BASALT, 4, 4)).withBiomeMask(new Biome[]{Biomes.NETHER_VOLCANIC_ISLANDS}).withPositionSelector(PositionSelectors.MinY).withPlacementMethod(PlacementMethods.OncePerChunk));
        this.register("minecraft:decoration/nether/default/sulfur_pool_floor_vent", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureFloorVent()).withBiomeMask(new Biome[]{Biomes.NETHER_SULFUR_POOLS}).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(12)));
        this.register("minecraft:decoration/nether/default/sulfur_pool_spire", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureThermalSpire()).withBiomeMask(new Biome[]{Biomes.NETHER_SULFUR_POOLS}).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(8)));
        this.register("minecraft:decoration/nether/default/nether_coal_ore", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureOre(BlockLogicOreNetherCoal.variantMap, 12)).withPositionSelector(PositionSelectors.HeightRangeUniform).withPlacementMethod(new PlacementMethod.TriesPerChunk(10)));
        this.register("minecraft:decoration/nether/default/nether_coal_ore_2", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureOre(BlockLogicOreNetherCoal.variantMap, 12)).withBiomeMask(new Biome[]{Biomes.NETHER_VOLCANIC_ISLANDS}).withPositionSelector(PositionSelectors.HeightRangeUniform).withPlacementMethod(new PlacementMethod.TriesPerChunk(20)));
        this.register("minecraft:decoration/nether/default/glowstone_1", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureGlowstoneA()).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod((feature, world, chunk, random) -> {
            int max = random.nextInt(random.nextInt(10) + 1);
            for (int i = 0; i < max; ++i) {
                feature.placeFeature(world, chunk, random);
            }
        }));
        this.register("minecraft:decoration/nether/default/glowstone_2", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureGlowstoneB()).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(10)));
        this.register("minecraft:decoration/nether/default/patch_fire_1", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureFire()).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(4)));
        this.register("minecraft:decoration/nether/default/patch_fire_2", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureFire()).withBiomeMask(new Biome[]{Biomes.NETHER_VOLCANIC_ISLANDS}).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(4)));
        this.register("minecraft:decoration/nether/default/old_world_patch_bone_pile", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureNetherPatch(Blocks.BONE_PILE.id())).withBiomeMask(new Biome[]{Biomes.NETHER_OLD_WORLD, Biomes.NETHER_OLD_WORLD_DESERT}).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(4)));
        this.register("minecraft:decoration/nether/default/patch_bone_pile", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureNetherPatch(Blocks.BONE_PILE.id())).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(1)));
        this.register("minecraft:decoration/nether/default/patch_soul_catcher", (ChunkDecoration)new ChunkDecorationBuilder(new WorldFeatureNetherPatch(Blocks.SOULCATCHER.id())).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(2)));
        this.register("minecraft:decoration/nether/default/boneshale_tree", (ChunkDecoration)new ChunkDecorationBuilder((world, random, tilePos) -> {
            WorldFeatureBoneshaleTree wf = new WorldFeatureBoneshaleTree(0, Blocks.LOG_PETRIFIED.id());
            ((WorldFeature)wf).init(1.0, 1.0, 1.0);
            return wf.place(world, random, tilePos);
        }).withBiomeMask(new Biome[]{Biomes.NETHER_OLD_WORLD}).withPositionSelector(PositionSelectors.HeightRangeUniformFromOcean).withPlacementMethod(new PlacementMethod.TriesPerChunk(4)));
    }

    @Override
    public void postDecorate(@NotNull World world, @NotNull Chunk chunk) {
        int oceanY = world.getWorldType().getOceanY();
        int worldX = chunk.pos.x() * 16;
        int worldZ = chunk.pos.z() * 16;
        int midY = oceanY + (world.getWorldType().getMaxY(world) - oceanY) / 2;
        for (int dx = worldX; dx < worldX + 16; ++dx) {
            for (int dz = worldZ; dz < worldZ + 16; ++dz) {
                Biome localBiome;
                int dy = midY;
                while (world.getBlockId(dx, dy, dz) == 0) {
                    --dy;
                }
                if ((localBiome = world.getBlockBiome(dx, ++dy, dz)) == null || !localBiome.hasTag(BiomeTags.HAS_SURFACE_ASH) || dy <= 0 || dy >= world.getHeightBlocks() || !world.isAirBlock(dx, dy, dz) || !world.getBlockMaterial(dx, dy - 1, dz).blocksMotion()) continue;
                world.setBlock(dx, dy, dz, Blocks.LAYER_ASH.id());
            }
        }
    }
}

