/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureNetherPatch
extends WorldFeature {
    private final int blockId;

    @MethodParametersAnnotation(names={"blockId"})
    public WorldFeatureNetherPatch(int blockId) {
        this.blockId = blockId;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        while (world.getBlockId(x, y, z) == 0 && y > 0) {
            --y;
        }
        for (int i = 0; i < 8; ++i) {
            int z1;
            int y1;
            int x1 = x + random.nextInt(4) - random.nextInt(4);
            if (!world.isAirBlock(x1, y1 = y + random.nextInt(4) - random.nextInt(4), z1 = z + random.nextInt(4) - random.nextInt(4)) || !Blocks.blocksList[this.blockId].canBlockStay(world, x1, y1, z1)) continue;
            world.setBlock(x1, y1, z1, this.blockId);
        }
        return true;
    }
}

