/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.structure;

import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.data.ChunkNibbleArray;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import net.minecraft.core.world.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class SavedStructure
implements Structure {
    @NotNull
    private static final Map<String, SavedStructure> STRUCTURES = new HashMap<String, SavedStructure>();
    @NotNull
    private final Vector3i size = new Vector3i();
    @NotNull
    private final Vector3i origin = new Vector3i();
    private final short @NotNull [] blocks;
    @NotNull
    private final ChunkNibbleArray data;

    public SavedStructure(@NotNull Vector3ic size, @NotNull Vector3ic origin) {
        this(size, origin, new short[size.x() * size.y() * size.z()], new ChunkNibbleArray(size.x(), size.y(), size.z()));
    }

    private SavedStructure(@NotNull Vector3ic size, @NotNull Vector3ic origin, short @NotNull [] blocks, @NotNull ChunkNibbleArray data) {
        this.size.set(size);
        this.origin.set(origin);
        this.blocks = blocks;
        this.data = data;
    }

    @Override
    @NotNull
    public Vector3ic getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Vector3ic getOrigin() {
        return this.origin;
    }

    private int toIndex(@NotNull Vector3ic pos) {
        @NotNull Vector3ic size = this.getSize();
        return pos.y() * size.z() * size.x() + pos.z() * size.x() + pos.x();
    }

    @Override
    @NotNull
    public Block<?> getBlockType(@NotNull Vector3ic pos) {
        int index = this.toIndex(pos);
        if (index < 0 || index >= this.blocks.length) {
            return Blocks.AIR;
        }
        return Blocks.getBlock(this.blocks[index]);
    }

    public void setBlockType(@NotNull Vector3ic pos, @NotNull Block<?> block) {
        int index = this.toIndex(pos);
        if (index < 0 || index >= this.blocks.length) {
            return;
        }
        this.blocks[index] = (short)block.id();
        this.setBlockData(pos, 0);
    }

    @Override
    public int getBlockData(@NotNull Vector3ic pos) {
        return this.data.get(pos.x(), pos.y(), pos.z());
    }

    public void setBlockData(@NotNull Vector3ic pos, int data) {
        this.data.set(pos.x(), pos.y(), pos.z(), data);
    }

    public void setBlockTypeData(@NotNull Vector3ic pos, @NotNull Block<?> block, int data) {
        this.setBlockType(pos, block);
        this.setBlockData(pos, data);
    }

    public static boolean save(@NotNull World world, @NotNull String id, @NotNull TilePosc pos, @NotNull Vector3ic size, @NotNull Vector3ic origin) {
        @NotNull SavedStructure structure = new SavedStructure(size, origin);
        @NotNull Vector3i sPos = new Vector3i();
        @NotNull TilePos queryPos = new TilePos();
        for (int x = 0; x < size.x(); ++x) {
            for (int y = 0; y < size.y(); ++y) {
                for (int z = 0; z < size.z(); ++z) {
                    sPos.set(x, y, z);
                    queryPos.set(pos).add(sPos);
                    structure.setBlockType(sPos, world.getBlockType(queryPos));
                    structure.setBlockData(sPos, world.getBlockData(queryPos));
                }
            }
        }
        STRUCTURES.put(id, structure);
        return SavedStructure.writeTag(SavedStructure.toNbt(structure), id);
    }

    @NotNull
    private static CompoundTag toNbt(@NotNull SavedStructure structure) {
        @NotNull CompoundTag tag = new CompoundTag();
        tag.putInt("formatVersion", 1);
        @NotNull CompoundTag structureTag = new CompoundTag();
        structureTag.putInt("sizeX", structure.size.x);
        structureTag.putInt("sizeY", structure.size.y);
        structureTag.putInt("sizeZ", structure.size.z);
        structureTag.putInt("originX", structure.origin.x);
        structureTag.putInt("originY", structure.origin.y);
        structureTag.putInt("originZ", structure.origin.z);
        structureTag.putShortArray("blocks", structure.blocks);
        structureTag.putByteArray("data", structure.data.data);
        tag.put("structure", structureTag);
        return tag;
    }

    private static boolean writeTag(@NotNull CompoundTag tag, @NotNull String id) {
        try {
            @NotNull File directory = new File(Global.accessor.getMinecraftDir(), "structures");
            if (!directory.exists() && !directory.mkdirs()) {
                return false;
            }
            @NotNull File file = new File(directory, id + ".nbt");
            if (!file.exists() && !file.createNewFile()) {
                return false;
            }
            try (@NotNull FileOutputStream stream = new FileOutputStream(file);){
                NbtIo.writeCompressed(tag, stream);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Nullable
    public static SavedStructure load(@NotNull String id) {
        if (STRUCTURES.containsKey(id)) {
            return STRUCTURES.get(id);
        }
        @Nullable InputStream stream = Structure.class.getResourceAsStream("/structures/" + id + ".nbt");
        if (stream == null) {
            try {
                @NotNull File file = new File(Global.accessor.getMinecraftDir(), "structures/" + id + ".nbt");
                if (file.exists()) {
                    stream = new FileInputStream(file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            @NotNull CompoundTag tag = NbtIo.readCompressed(stream);
            @NotNull SavedStructure structure = SavedStructure.fromNbt(tag);
            STRUCTURES.put(id, structure);
            return structure;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    private static SavedStructure fromNbt(@NotNull CompoundTag tag) {
        @NotNull CompoundTag structureTag = tag.getCompound("structure");
        int sizeX = structureTag.getInteger("sizeX");
        int sizeY = structureTag.getInteger("sizeY");
        int sizeZ = structureTag.getInteger("sizeZ");
        int originX = structureTag.getInteger("originX");
        int originY = structureTag.getInteger("originY");
        int originZ = structureTag.getInteger("originZ");
        short[] blocks = structureTag.getShortArray("blocks");
        byte[] data = structureTag.getByteArray("data");
        return new SavedStructure(new Vector3i(sizeX, sizeY, sizeZ), new Vector3i(originX, originY, originZ), blocks, new ChunkNibbleArray(sizeX, sizeY, sizeZ, data));
    }
}

