/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicSpikes
extends BlockLogic {
    public static final int MASK_POWERED = 1;

    public BlockLogicSpikes(Block<?> block, Material mat) {
        super(block, mat);
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (world.hasNeighborSignal(x, y, z)) {
            world.setBlockMetadataWithNotify(x, y, z, meta | 1);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Blocks.SPIKES)};
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z) || world.getBlockId(x, y - 1, z) == Blocks.MOBSPAWNER.id();
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean destroy;
        if (world.isClientSide) {
            return;
        }
        boolean bl = destroy = !world.canPlaceOnSurfaceOfBlock(x, y - 1, z) && world.getBlockId(x, y - 1, z) != Blocks.MESH.id() && world.getBlockId(x, y - 1, z) != Blocks.MOBSPAWNER.id();
        if (destroy) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
            world.setBlockWithNotify(x, y, z, 0);
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        boolean wasPowered = (meta & 1) != 0;
        boolean isPowered = world.hasNeighborSignal(x, y, z);
        if (isPowered != wasPowered) {
            if (isPowered) {
                world.playBlockEvent(null, 1007, x, y, z, 0);
                world.setBlockMetadataWithNotify(x, y, z, 1);
            } else {
                world.playBlockEvent(null, 1006, x, y, z, 0);
                world.setBlockMetadataWithNotify(x, y, z, 0);
            }
        }
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        float f = 0.0625f;
        return AABB.getTemporaryBB((float)x + f, y, (float)z + f, (float)(x + 1) - f, (float)y + 0.1875f, (float)(z + 1) - f);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        int metaData = world.getBlockMetadata(x, y, z);
        if (BlockLogicSpikes.isSpikesUp(metaData) && entity instanceof Mob) {
            if (entity.fallDistance > 1.5f) {
                entity.hurt(null, MathHelper.floor(entity.fallDistance) * 2 + 1, DamageType.COMBAT);
                entity.stuck = true;
            } else if (entity.isWalking) {
                entity.hurt(null, 1, DamageType.COMBAT);
            }
        }
    }

    @Override
    public boolean collidesWithEntity(Entity entity, World world, int x, int y, int z) {
        return !(entity instanceof EntityItem);
    }

    public static boolean isSpikesUp(int i) {
        return (i & 1) == 0;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }
}

