/*
 * Decompiled with CFR 0.152.
 */
package b100.json.element;

import b100.json.element.JsonArray;
import b100.json.element.JsonBoolean;
import b100.json.element.JsonNumber;
import b100.json.element.JsonObject;
import b100.json.element.JsonString;
import b100.utils.InvalidCharacterException;
import b100.utils.StringReader;
import b100.utils.Writable;

public interface JsonElement
extends Writable {
    public static JsonElement readElement(StringReader reader) {
        reader.skipWhitespace();
        if (reader.get() == '\"') {
            return new JsonString(reader);
        }
        if (reader.get() == '{') {
            return new JsonObject(reader);
        }
        if (reader.get() == '[') {
            return new JsonArray(reader);
        }
        if (reader.get() >= '0' && reader.get() <= '9' || reader.get() == '-') {
            return new JsonNumber(reader);
        }
        if (reader.isNext("true") || reader.isNext("false")) {
            return new JsonBoolean(reader);
        }
        throw new InvalidCharacterException(reader);
    }

    default public <E extends JsonElement> E getAs(Class<E> clazz) {
        return (E)((JsonElement)clazz.cast(this));
    }

    default public JsonObject getAsObject() {
        return this.getAs(JsonObject.class);
    }

    default public JsonArray getAsArray() {
        return this.getAs(JsonArray.class);
    }

    default public JsonNumber getAsNumber() {
        return this.getAs(JsonNumber.class);
    }

    default public JsonString getAsString() {
        return this.getAs(JsonString.class);
    }

    default public JsonBoolean getAsBoolean() {
        return this.getAs(JsonBoolean.class);
    }

    default public boolean is(Class<? extends JsonElement> clazz) {
        return this.getClass().isAssignableFrom(clazz);
    }

    default public boolean isObject() {
        return this.is(JsonObject.class);
    }

    default public boolean isArray() {
        return this.is(JsonArray.class);
    }

    default public boolean isNumber() {
        return this.is(JsonNumber.class);
    }

    default public boolean isString() {
        return this.is(JsonString.class);
    }

    default public boolean isBoolean() {
        return this.is(JsonBoolean.class);
    }
}

