/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import bta.ModLoader;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.MinecraftApplet;
import net.minecraft.src.AchievementList;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkProviderLoadOrGenerate;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.ColorizerWater;
import net.minecraft.src.EffectRenderer;
import net.minecraft.src.EntityClientPlayerMP;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EntityRenderer;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.EnumOS2;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.GameResolution;
import net.minecraft.src.GameSettings;
import net.minecraft.src.GameWindowListener;
import net.minecraft.src.Gamemode;
import net.minecraft.src.GuiAchievement;
import net.minecraft.src.GuiChat;
import net.minecraft.src.GuiConflictWarning;
import net.minecraft.src.GuiConnecting;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.GuiErrorScreen;
import net.minecraft.src.GuiGameOver;
import net.minecraft.src.GuiIngame;
import net.minecraft.src.GuiIngameMenu;
import net.minecraft.src.GuiMainMenu;
import net.minecraft.src.GuiPhotoMode;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiShaderSelect;
import net.minecraft.src.GuiSleepMP;
import net.minecraft.src.GuiSleepSP;
import net.minecraft.src.GuiUnused;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.ISaveFormat;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.ItemRenderer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.LoadingScreenRenderer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MinecraftError;
import net.minecraft.src.MinecraftException;
import net.minecraft.src.MinecraftImpl;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.MovementInputFromOptions;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.OpenGlCapsChecker;
import net.minecraft.src.PlayerController;
import net.minecraft.src.PlayerProfile;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.RenderManager;
import net.minecraft.src.SaveFormatMcRegionExtended;
import net.minecraft.src.ScreenShotHelper;
import net.minecraft.src.Session;
import net.minecraft.src.SoundManager;
import net.minecraft.src.StatFileWriter;
import net.minecraft.src.StatList;
import net.minecraft.src.StatStringFormatKeyInv;
import net.minecraft.src.Teleporter;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TexturePackList;
import net.minecraft.src.ThreadCheckHasPaid;
import net.minecraft.src.ThreadDownloadResources;
import net.minecraft.src.ThreadSleepForeverClient;
import net.minecraft.src.Timer;
import net.minecraft.src.UnexpectedThrowable;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.WorldRenderer;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.ClientCommandHandler;
import net.minecraft.src.helper.Direction;
import net.minecraft.src.helper.LogPrintStream;
import net.minecraft.src.helper.ScreenshotHelper;
import net.minecraft.src.helper.Textures;
import net.minecraft.src.helper.Time;
import net.minecraft.src.input.InputHandler;
import net.minecraft.src.input.InputType;
import net.minecraft.src.input.MouseInput;
import net.minecraft.src.input.controller.ControllerInput;
import net.minecraft.src.input.controller.Joystick;
import net.minecraft.src.option.FloatOption;
import net.minecraft.src.option.IntegerOption;
import net.minecraft.src.render.IRenderer;
import net.minecraft.src.render.Shaders;
import net.minecraft.src.render.ShadersRendererBuiltin;
import net.minecraft.src.render.ShadersRendererCustom;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;

public abstract class Minecraft
implements Runnable {
    public static final String VERSION = "1.7.6.2";
    public static final boolean isMultiplayerDisabled = false;
    public static byte[] field_28006_b = new byte[0xA00000];
    private static Minecraft theMinecraft;
    public PlayerController playerController;
    private boolean fullscreen;
    private boolean hasCrashed;
    private OpenGlCapsChecker glCapabilities;
    private Timer timer;
    public World theWorld;
    public RenderGlobal renderGlobal;
    public EntityPlayerSP thePlayer;
    public EntityLiving renderViewEntity;
    public EffectRenderer effectRenderer;
    public Session session;
    public String minecraftUri;
    public Canvas mcCanvas;
    public boolean hideQuitButton;
    public volatile boolean isGamePaused;
    public RenderEngine renderEngine;
    public FontRenderer fontRenderer;
    public GuiScreen currentScreen;
    public LoadingScreenRenderer loadingScreen;
    public EntityRenderer entityRenderer;
    public ThreadDownloadResources downloadResourcesThread;
    private int ticksRan;
    public GuiAchievement guiAchievement;
    public GuiIngame ingameGUI;
    public boolean skipRenderWorld;
    public ModelBiped field_9242_w;
    public MovingObjectPosition objectMouseOver;
    public GameSettings gameSettings;
    protected MinecraftApplet mcApplet;
    public SoundManager sndManager;
    public TexturePackList texturePackList;
    private File mcDataDir;
    private ISaveFormat saveLoader;
    public static long[] frameTimes;
    public static long[] tickTimes;
    public static int numRecordedFrameTimes;
    public static long hasPaidCheckTime;
    public StatFileWriter statFileWriter;
    private String serverName;
    private int serverPort;
    private static File minecraftDir;
    public volatile boolean running;
    public String debug;
    public String debugFPS;
    boolean isTakingScreenshot;
    long prevFrameTime;
    public boolean inGameHasFocus;
    private int mouseTicksRan;
    public boolean isRaining;
    long systemTime;
    private int joinPlayerCounter;
    protected boolean toggleFlyPressed = false;
    protected long flyPressedTime = 0L;
    public float hotbarSwapAnimationProgress = 0.0f;
    public final GameResolution resolution = new GameResolution(this);
    public boolean isometricMode = false;
    public float isometricRotation = 0.0f;
    public float isometricRotationGoal = 0.0f;
    public float isometricZoom = 1.0f;
    public float isometricZoomGoal = 1.0f;
    public float isometricTilt = 30.0f;
    public float isometricTiltGoal = 30.0f;
    public float isometricFogGoal = 1.0f;
    public final ClientCommandHandler commandHandler = new ClientCommandHandler(this);
    public float fogOverride = 1.0f;
    public boolean fullbright = false;
    public IRenderer render;
    public ControllerInput controllerInput;
    public MouseInput mouseInput;
    public InputType inputType = InputType.KEYBOARD;
    public final ModLoader modLoader = new ModLoader(this);
    public final ScreenshotHelper screenshotHelper = new ScreenshotHelper(this);
    private boolean f3Press = false;

    public Minecraft(Component component, Canvas canvas, MinecraftApplet minecraftapplet, int i, int j, boolean flag) {
        LogPrintStream.setup();
        this.fullscreen = false;
        this.hasCrashed = false;
        this.timer = new Timer(20.0f);
        this.session = null;
        this.hideQuitButton = false;
        this.isGamePaused = false;
        this.currentScreen = null;
        this.loadingScreen = new LoadingScreenRenderer(this);
        this.ticksRan = 0;
        this.guiAchievement = new GuiAchievement(this);
        this.skipRenderWorld = false;
        this.field_9242_w = new ModelBiped(0.0f);
        this.objectMouseOver = null;
        this.sndManager = new SoundManager();
        this.running = true;
        this.debug = "";
        this.isTakingScreenshot = false;
        this.prevFrameTime = -1L;
        this.inGameHasFocus = false;
        this.mouseTicksRan = 0;
        this.isRaining = false;
        this.systemTime = System.currentTimeMillis();
        this.joinPlayerCounter = 0;
        StatList.init();
        this.fullscreen = flag;
        this.mcApplet = minecraftapplet;
        new ThreadSleepForeverClient(this, "Timer hack thread");
        this.mcCanvas = canvas;
        this.fullscreen = flag;
        theMinecraft = this;
    }

    public void onMinecraftCrash(UnexpectedThrowable unexpectedthrowable) {
        this.hasCrashed = true;
        this.displayUnexpectedThrowable(unexpectedthrowable);
    }

    public abstract void displayUnexpectedThrowable(UnexpectedThrowable var1);

    public void setServer(String s, int i) {
        this.serverName = s;
        this.serverPort = i;
    }

    public void startGame() throws LWJGLException {
        System.out.println("Java Version: " + System.getProperty("java.version"));
        if (this.mcCanvas != null) {
            this.mcCanvas.setBackground(Color.black);
            Display.setParent((Canvas)this.mcCanvas);
        } else if (this.fullscreen) {
            Display.setFullscreen((boolean)true);
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(854, 480));
        }
        Display.setTitle((String)"Better than Adventure! 1.7.6.2");
        try {
            PixelFormat pixelformat = new PixelFormat();
            pixelformat = pixelformat.withDepthBits(24);
            Display.create((PixelFormat)pixelformat);
        }
        catch (LWJGLException lwjglexception) {
            lwjglexception.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
        this.resolution.update();
        this.mcDataDir = Minecraft.getMinecraftDir();
        this.saveLoader = new SaveFormatMcRegionExtended(new File(this.mcDataDir, "saves"));
        this.gameSettings = new GameSettings(this, this.mcDataDir);
        this.resolution.getSetGuiScale();
        this.resolution.update();
        Display.setVSyncEnabled(((Integer)this.gameSettings.limitFramerate.value == 3 ? 1 : 0) != 0);
        Shaders.testShaderCompat(this);
        if (Shaders.shadersCompatible) {
            if (((Boolean)this.gameSettings.customShaders.value).booleanValue()) {
                this.setRenderer(new ShadersRendererCustom(this));
            } else {
                this.setRenderer(new ShadersRendererBuiltin(this));
            }
        }
        this.texturePackList = new TexturePackList(this, this.mcDataDir);
        this.renderEngine = new RenderEngine(this, this.texturePackList, this.gameSettings);
        ColorizerWater.updateColorData(this.renderEngine.getTextureImageData("/misc/watercolor.png"));
        ColorizerGrass.func_28181_a(this.renderEngine.getTextureImageData("/misc/grasscolor.png"));
        ColorizerFoliage.func_28152_a(this.renderEngine.getTextureImageData("/misc/foliagecolor.png"));
        this.entityRenderer = new EntityRenderer(this);
        RenderManager.instance.itemRenderer = new ItemRenderer(this);
        this.statFileWriter = new StatFileWriter(this.session, this.mcDataDir);
        AchievementList.openInventory.setStatStringFormatter(new StatStringFormatKeyInv(this));
        this.loadScreen();
        try {
            InputHandler.init(this);
            System.out.println("Saved Controller: " + (String)this.gameSettings.selectedController.value);
            for (ControllerInput controllerInput : InputHandler.controllers) {
                if (((String)this.gameSettings.selectedController.value).length() <= 0 || !controllerInput.getController().toString().equalsIgnoreCase((String)this.gameSettings.selectedController.value)) continue;
                System.out.println("Using Controller: " + controllerInput);
                this.controllerInput = controllerInput;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkGLError("Pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.checkGLError("Startup");
        this.glCapabilities = new OpenGlCapsChecker();
        this.sndManager.loadSoundSettings(this.gameSettings);
        this.renderEngine.refreshTextures();
        this.renderEngine.getTexture("/terrain.png");
        this.renderGlobal = new RenderGlobal(this, this.renderEngine);
        GL11.glViewport((int)0, (int)0, (int)this.resolution.width, (int)this.resolution.height);
        this.effectRenderer = new EffectRenderer(this.theWorld, this.renderEngine);
        try {
            this.downloadResourcesThread = new ThreadDownloadResources(this.mcDataDir, this);
            this.downloadResourcesThread.start();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.checkGLError("Post startup");
        this.ingameGUI = new GuiIngame(this);
        if (this.serverName != null) {
            this.displayGuiScreen(new GuiConnecting(this, this.serverName, this.serverPort));
        } else {
            this.displayGuiScreen(new GuiMainMenu());
        }
        try {
            this.modLoader.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void loadScreen() throws LWJGLException {
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.resolution.scaledWidthExact, (double)this.resolution.scaledHeightExact, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.resolution.width, (int)this.resolution.height);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        Random mojrand = new Random();
        if (mojrand.nextInt(666) == 0) {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/title/majonk.png"));
        } else {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/title/mojang.png"));
        }
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xFFFFFF);
        tessellator.addVertexWithUV(0.0, this.resolution.height, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.resolution.width, this.resolution.height, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.resolution.width, 0.0, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int width = 256;
        int height = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.setColorOpaque_I(0xFFFFFF);
        this.drawMojangLogoVertices((this.resolution.scaledWidth - width) / 2, (this.resolution.scaledHeight - height) / 2, 0, 0, width, height);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.swapBuffers();
    }

    public void drawMojangLogoVertices(int i, int j, int k, int l, int i1, int j1) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(i + 0, j + j1, 0.0, (float)(k + 0) * f, (float)(l + j1) * f1);
        tessellator.addVertexWithUV(i + i1, j + j1, 0.0, (float)(k + i1) * f, (float)(l + j1) * f1);
        tessellator.addVertexWithUV(i + i1, j + 0, 0.0, (float)(k + i1) * f, (float)(l + 0) * f1);
        tessellator.addVertexWithUV(i + 0, j + 0, 0.0, (float)(k + 0) * f, (float)(l + 0) * f1);
        tessellator.draw();
    }

    public static File getMinecraftDir() {
        if (minecraftDir == null) {
            minecraftDir = Minecraft.getAppDir("minecraft-bta");
        }
        return minecraftDir;
    }

    public static File getAppDir(String s) {
        File file;
        String s1 = System.getProperty("user.home", ".");
        switch (Minecraft.getOs()) {
            case linux: 
            case solaris: {
                file = new File(s1, '.' + s + '/');
                break;
            }
            case windows: {
                String s2 = System.getenv("APPDATA");
                if (s2 != null) {
                    file = new File(s2, "." + s + '/');
                    break;
                }
                file = new File(s1, '.' + s + '/');
                break;
            }
            case macos: {
                file = new File(s1, "Library/Application Support/" + s);
                break;
            }
            default: {
                file = new File(s1, s + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static EnumOS2 getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS2.windows;
        }
        if (s.contains("mac")) {
            return EnumOS2.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS2.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS2.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS2.linux;
        }
        if (s.contains("unix")) {
            return EnumOS2.linux;
        }
        return EnumOS2.unknown;
    }

    public ISaveFormat getSaveLoader() {
        return this.saveLoader;
    }

    public void displayGuiScreen(GuiScreen guiscreen) {
        if (this.currentScreen == null && guiscreen != null && this.controllerInput != null) {
            this.controllerInput.cursorX = this.resolution.scaledWidth / 2;
            this.controllerInput.cursorY = this.resolution.scaledHeight / 2;
        }
        if (this.currentScreen instanceof GuiUnused) {
            return;
        }
        if (this.currentScreen != null) {
            this.currentScreen.onGuiClosed();
        }
        if (guiscreen instanceof GuiMainMenu) {
            if (((Boolean)this.gameSettings.showFrameTimes.value).booleanValue()) {
                this.gameSettings.showFrameTimes.set(false);
            }
            this.statFileWriter.func_27175_b();
        }
        this.statFileWriter.syncStats();
        if (guiscreen == null && this.theWorld == null) {
            guiscreen = new GuiMainMenu();
        } else if (guiscreen == null && this.thePlayer.health <= 0) {
            guiscreen = new GuiGameOver();
        }
        if (guiscreen instanceof GuiMainMenu) {
            this.ingameGUI.clearChatMessages();
        }
        this.currentScreen = guiscreen;
        if (guiscreen != null) {
            this.setIngameNotInFocus();
            guiscreen.setWorldAndResolution(this, this.resolution.scaledWidth, this.resolution.scaledHeight);
            this.skipRenderWorld = false;
        } else {
            this.setIngameFocus();
        }
    }

    private void checkGLError(String s) {
        int i = GL11.glGetError();
        if (i != 0) {
            String s1 = GLU.gluErrorString((int)i);
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + s);
            System.out.println(i + ": " + s1);
        }
    }

    public void shutdownMinecraftApplet() {
        try {
            try {
                this.gameSettings.saveOptions();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.statFileWriter.func_27175_b();
            this.statFileWriter.syncStats();
            if (this.mcApplet != null) {
                this.mcApplet.clearApplet();
            }
            System.out.println("Stopping!");
            try {
                this.changeWorld1(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                GLAllocation.deleteTexturesAndDisplayLists();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sndManager.closeMinecraft();
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
            if (!this.hasCrashed) {
                System.exit(0);
            }
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block33: {
            this.running = true;
            try {
                this.startGame();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.onMinecraftCrash(new UnexpectedThrowable("Failed to start game", exception));
                return;
            }
            try {
                l = System.currentTimeMillis();
                i = 0;
                while (true) lbl-1000:
                // 4 sources

                {
                    if (!this.running) {
                        break block33;
                    }
                    try {
                        Time.tick();
                        if (this.mcApplet != null && !this.mcApplet.isActive()) {
                            break block33;
                        }
                        AxisAlignedBB.clearBoundingBoxPool();
                        Vec3D.initialize();
                        if (this.mcCanvas == null && Display.isCloseRequested()) {
                            this.shutdown();
                        }
                        if (Display.isFullscreen() && !Display.isActive()) {
                            this.toggleFullscreen();
                        }
                        if (this.isGamePaused && this.theWorld != null) {
                            f = this.timer.renderPartialTicks;
                            this.timer.updateTimer();
                            this.timer.renderPartialTicks = f;
                        } else {
                            this.timer.updateTimer();
                        }
                        l1 = System.nanoTime();
                        this.mouseInput.update();
                        if (this.controllerInput != null && this.currentScreen != null) {
                            this.controllerInput.moveCursor();
                        }
                        for (j = 0; j < this.timer.elapsedTicks; ++j) {
                            ++this.ticksRan;
                            try {
                                this.runTick();
                                continue;
                            }
                            catch (MinecraftException minecraftexception1) {
                                this.theWorld = null;
                                this.changeWorld1(null);
                                this.displayGuiScreen(new GuiConflictWarning());
                            }
                        }
                        l2 = System.nanoTime() - l1;
                        this.checkGLError("Pre render");
                        RenderBlocks.fancyGrass = (Boolean)this.gameSettings.fancyGraphics.value;
                        this.sndManager.func_338_a(this.thePlayer, this.timer.renderPartialTicks);
                        GL11.glEnable((int)3553);
                        if (this.theWorld != null) {
                            this.theWorld.updatingLighting();
                        }
                        Display.update();
                        if (this.thePlayer != null && this.thePlayer.isEntityInsideOpaqueBlock()) {
                            this.gameSettings.thirdPersonView.value = 0;
                        }
                        if (this.shadersActive()) {
                            this.render.beginRenderGame();
                        }
                        GL11.glEnable((int)3008);
                        if (!this.skipRenderWorld) {
                            if (this.playerController != null) {
                                this.playerController.setPartialTime(this.timer.renderPartialTicks);
                            }
                            this.entityRenderer.updateCameraAndRender(this.timer.renderPartialTicks);
                        }
                        if (((Boolean)this.gameSettings.pauseOnLostFocus.value).booleanValue() && !Display.isActive() && this.currentScreen == null) {
                            this.displayInGameMenu();
                        }
                        if (((Boolean)this.gameSettings.showFrameTimes.value).booleanValue()) {
                            this.displayDebugInfo(l2);
                        } else {
                            this.prevFrameTime = System.nanoTime();
                        }
                        this.guiAchievement.updateAchievementWindow();
                        if (this.shadersActive()) {
                            this.render.endRenderGame();
                        }
                        Thread.yield();
                        this.screenshotListener();
                        if (!(this.mcCanvas == null || this.fullscreen || this.mcCanvas.getWidth() == this.resolution.width && this.mcCanvas.getHeight() == this.resolution.height)) {
                            this.resize();
                        }
                        this.checkGLError("Post render");
                        ++i;
                        v0 = this.isGamePaused = this.isMultiplayerWorld() == false && this.currentScreen != null && this.currentScreen.doesGuiPauseGame() != false;
                        while (true) {
                            if (System.currentTimeMillis() < l + 1000L) ** GOTO lbl-1000
                            this.debug = i + " fps, " + WorldRenderer.chunksUpdated + " chunk updates";
                            this.debugFPS = i + " fps";
                            WorldRenderer.chunksUpdated = 0;
                            l += 1000L;
                            i = 0;
                        }
                    }
                    catch (MinecraftException minecraftexception) {
                        this.theWorld = null;
                        this.changeWorld1(null);
                        this.displayGuiScreen(new GuiConflictWarning());
                    }
                    catch (OutOfMemoryError outofmemoryerror) {
                        this.func_28002_e();
                        this.displayGuiScreen(new GuiErrorScreen());
                        System.gc();
                        continue;
                    }
                    break;
                }
            }
            catch (MinecraftError l) {
                break block33;
            }
            catch (Throwable throwable) {
                this.func_28002_e();
                throwable.printStackTrace();
                this.onMinecraftCrash(new UnexpectedThrowable("Unexpected error", throwable));
                break block33;
            }
            finally {
                this.shutdownMinecraftApplet();
            }
            ** GOTO lbl-1000
        }
    }

    public void func_28002_e() {
        try {
            field_28006_b = new byte[0];
            this.renderGlobal.func_28137_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            AxisAlignedBB.func_28196_a();
            Vec3D.func_28215_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            this.changeWorld1(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void screenshotListener() {
        if (this.gameSettings.keyScreenshot.isPressed() && !Keyboard.isKeyDown((int)29) && !Keyboard.isKeyDown((int)157)) {
            if (!this.isTakingScreenshot) {
                this.isTakingScreenshot = true;
                this.ingameGUI.addChatMessage(ScreenShotHelper.saveScreenshot(minecraftDir, this.resolution.width, this.resolution.height));
            }
        } else {
            this.isTakingScreenshot = false;
        }
    }

    private void displayDebugInfo(long l) {
        long l1 = 16666666L;
        if (this.prevFrameTime == -1L) {
            this.prevFrameTime = System.nanoTime();
        }
        long l2 = System.nanoTime();
        Minecraft.tickTimes[Minecraft.numRecordedFrameTimes & Minecraft.frameTimes.length - 1] = l;
        Minecraft.frameTimes[Minecraft.numRecordedFrameTimes++ & Minecraft.frameTimes.length - 1] = l2 - this.prevFrameTime;
        this.prevFrameTime = l2;
        GL11.glClear((int)256);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.resolution.width, (double)this.resolution.height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(7);
        int i = (int)(l1 / 200000L);
        tessellator.setColorOpaque_I(0x20000000);
        tessellator.addVertex(0.0, this.resolution.height - i, 0.0);
        tessellator.addVertex(0.0, this.resolution.height, 0.0);
        tessellator.addVertex(frameTimes.length, this.resolution.height, 0.0);
        tessellator.addVertex(frameTimes.length, this.resolution.height - i, 0.0);
        tessellator.setColorOpaque_I(0x20200000);
        tessellator.addVertex(0.0, this.resolution.height - i * 2, 0.0);
        tessellator.addVertex(0.0, this.resolution.height - i, 0.0);
        tessellator.addVertex(frameTimes.length, this.resolution.height - i, 0.0);
        tessellator.addVertex(frameTimes.length, this.resolution.height - i * 2, 0.0);
        tessellator.draw();
        long l3 = 0L;
        for (int j = 0; j < frameTimes.length; ++j) {
            l3 += frameTimes[j];
        }
        int k = (int)(l3 / 200000L / (long)frameTimes.length);
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_I(0x20400000);
        tessellator.addVertex(0.0, this.resolution.height - k, 0.0);
        tessellator.addVertex(0.0, this.resolution.height, 0.0);
        tessellator.addVertex(frameTimes.length, this.resolution.height, 0.0);
        tessellator.addVertex(frameTimes.length, this.resolution.height - k, 0.0);
        tessellator.draw();
        tessellator.startDrawing(1);
        for (int i1 = 0; i1 < frameTimes.length; ++i1) {
            int j1 = (i1 - numRecordedFrameTimes & frameTimes.length - 1) * 255 / frameTimes.length;
            int k1 = j1 * j1 / 255;
            k1 = k1 * k1 / 255;
            int i2 = k1 * k1 / 255;
            i2 = i2 * i2 / 255;
            if (frameTimes[i1] > l1) {
                tessellator.setColorOpaque_I(-16777216 + k1 * 65536);
            } else {
                tessellator.setColorOpaque_I(-16777216 + k1 * 256);
            }
            long l4 = frameTimes[i1] / 200000L;
            long l5 = tickTimes[i1] / 200000L;
            tessellator.addVertex((float)i1 + 0.5f, (float)((long)this.resolution.height - l4) + 0.5f, 0.0);
            tessellator.addVertex((float)i1 + 0.5f, (float)this.resolution.height + 0.5f, 0.0);
            tessellator.setColorOpaque_I(-16777216 + k1 * 65536 + k1 * 256 + k1 * 1);
            tessellator.addVertex((float)i1 + 0.5f, (float)((long)this.resolution.height - l4) + 0.5f, 0.0);
            tessellator.addVertex((float)i1 + 0.5f, (float)((long)this.resolution.height - (l4 - l5)) + 0.5f, 0.0);
        }
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public void shutdown() {
        this.running = false;
    }

    public void setIngameFocus() {
        if (!Display.isActive()) {
            return;
        }
        if (this.inGameHasFocus) {
            return;
        }
        this.inGameHasFocus = true;
        this.mouseInput.grabCursor();
        this.displayGuiScreen(null);
        this.mouseTicksRan = this.ticksRan + 10000;
    }

    public void setIngameNotInFocus() {
        if (!this.inGameHasFocus) {
            return;
        }
        if (this.thePlayer != null) {
            this.thePlayer.resetPlayerKeyState();
        }
        this.inGameHasFocus = false;
        if (this.inputType == InputType.KEYBOARD) {
            this.mouseInput.releaseCursor();
        }
    }

    public boolean shadersActive() {
        return Shaders.shadersCompatible && this.render != null && (Boolean)this.gameSettings.shaders.value != false;
    }

    public void displayInGameMenu() {
        if (this.currentScreen != null) {
            return;
        }
        this.displayGuiScreen(new GuiIngameMenu());
    }

    private void mineBlocks(int i, boolean flag) {
        if (this.playerController.field_1064_b) {
            return;
        }
        if (flag && this.objectMouseOver != null && this.objectMouseOver.typeOfHit == EnumMovingObjectType.TILE && i == 0) {
            int j = this.objectMouseOver.blockX;
            int k = this.objectMouseOver.blockY;
            int l = this.objectMouseOver.blockZ;
            this.playerController.mine(j, k, l, this.objectMouseOver.sideHit);
        } else {
            this.playerController.dontMine(flag);
        }
    }

    private void clickMouse(int clickType, boolean attack, boolean repeat) {
        ItemStack itemstack;
        this.mouseTicksRan = this.ticksRan;
        boolean flag = true;
        if (this.objectMouseOver == null) {
            if (clickType == 0 && attack) {
                this.thePlayer.swingItem();
            }
        } else if (this.objectMouseOver.typeOfHit == EnumMovingObjectType.ENTITY) {
            if (clickType == 0 && attack) {
                this.thePlayer.swingItem();
                this.playerController.attackEntity(this.thePlayer, this.objectMouseOver.entityHit);
            }
            if (clickType == 1) {
                this.playerController.interactWithEntity(this.thePlayer, this.objectMouseOver.entityHit);
            }
        } else if (this.objectMouseOver.typeOfHit == EnumMovingObjectType.TILE) {
            int j = this.objectMouseOver.blockX;
            int k = this.objectMouseOver.blockY;
            int l = this.objectMouseOver.blockZ;
            int i1 = this.objectMouseOver.sideHit;
            double heightPlaced = this.objectMouseOver.hitVec.yCoord - (double)this.objectMouseOver.blockY;
            if (clickType == 0) {
                this.playerController.clickBlock(j, k, l, this.objectMouseOver.sideHit, repeat);
            } else {
                int j1;
                ItemStack itemstack1 = this.thePlayer.inventory.getCurrentItem();
                int n = j1 = itemstack1 == null ? 0 : itemstack1.stackSize;
                if (this.playerController.activeBlockOrUseItem(this.thePlayer, this.theWorld, itemstack1, j, k, l, i1, heightPlaced)) {
                    flag = false;
                    this.thePlayer.swingItem();
                }
                if (itemstack1 == null) {
                    return;
                }
                if (itemstack1.stackSize == 0) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                } else if (itemstack1.stackSize != j1) {
                    this.entityRenderer.itemRenderer.func_9449_b();
                }
            }
        }
        if (flag && clickType == 1 && (itemstack = this.thePlayer.inventory.getCurrentItem()) != null && this.playerController.sendUseItem(this.thePlayer, this.theWorld, itemstack)) {
            this.entityRenderer.itemRenderer.func_9450_c();
        }
    }

    public void toggleFullscreen() {
        try {
            this.fullscreen = !this.fullscreen;
            Display.setFullscreen((boolean)this.fullscreen);
            Display.update();
            this.resize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void resize() {
        this.resolution.update();
        if (this.currentScreen != null) {
            this.currentScreen.setWorldAndResolution(this, this.resolution.scaledWidth, this.resolution.scaledHeight);
        }
    }

    private void clickMiddleMouseButton() {
        if (this.objectMouseOver != null && this.objectMouseOver.typeOfHit == EnumMovingObjectType.TILE) {
            this.thePlayer.middleClickBlock(this.objectMouseOver.blockX, this.objectMouseOver.blockY, this.objectMouseOver.blockZ);
        }
    }

    private void func_28001_B() {
        new ThreadCheckHasPaid(this).start();
    }

    public void runTick() {
        IChunkProvider ichunkprovider;
        if (this.ticksRan == 6000) {
            this.func_28001_B();
        }
        this.statFileWriter.func_27178_d();
        this.ingameGUI.updateTick();
        this.entityRenderer.getMouseOver(1.0f);
        if (this.thePlayer != null && (ichunkprovider = this.theWorld.getIChunkProvider()) instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            int j = MathHelper.floor_float((int)this.thePlayer.posX) >> 4;
            int i1 = MathHelper.floor_float((int)this.thePlayer.posZ) >> 4;
            chunkproviderloadorgenerate.setCurrentChunkOver(j, i1);
        }
        if (!this.isGamePaused && this.theWorld != null) {
            this.playerController.updateController();
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTexture("/terrain.png"));
        if (!this.isGamePaused) {
            this.renderEngine.updateDynamicTextures();
        }
        if (this.currentScreen == null && this.thePlayer != null) {
            if (this.thePlayer.health <= 0) {
                this.displayGuiScreen(null);
            } else if (this.thePlayer.isPlayerSleeping() && this.theWorld != null) {
                if (this.theWorld.isMultiplayerAndNotHost) {
                    this.displayGuiScreen(new GuiSleepMP());
                } else {
                    this.displayGuiScreen(new GuiSleepSP());
                }
            }
        } else if (this.currentScreen != null && this.currentScreen instanceof GuiSleepMP && !this.thePlayer.isPlayerSleeping()) {
            this.displayGuiScreen(null);
        }
        if (this.currentScreen != null) {
            this.mouseTicksRan = this.ticksRan + 10000;
        }
        if (this.currentScreen != null && this.inputType == InputType.CONTROLLER && (this.mouseInput.deltaX != 0.0 || this.mouseInput.deltaY != 0.0)) {
            this.setInputType(InputType.KEYBOARD);
        }
        if (this.currentScreen != null) {
            this.currentScreen.handleInput();
            if (this.currentScreen != null) {
                this.currentScreen.field_25091_h.func_25088_a();
                this.currentScreen.updateScreen();
            }
        }
        if (this.controllerInput != null) {
            this.handleControllerInput();
        }
        if (this.currentScreen == null || this.currentScreen.field_948_f) {
            boolean click1;
            while (Mouse.next()) {
                long l = System.currentTimeMillis() - this.systemTime;
                if (l > 200L) continue;
                int k = Mouse.getEventDWheel();
                if (k != 0) {
                    if (this.thePlayer.noClip && this.toggleFlyPressed) {
                        this.thePlayer.changeFlySpeed(k);
                    } else {
                        this.thePlayer.inventory.changeCurrentItem(k);
                        if (((Boolean)this.gameSettings.field_22275_C.value).booleanValue()) {
                            if (k > 0) {
                                k = 1;
                            }
                            if (k < 0) {
                                k = -1;
                            }
                            FloatOption i1 = this.gameSettings.field_22272_F;
                            Float.valueOf(((Float)i1.value).floatValue() + (float)k * 0.25f);
                            i1.value = i1.value;
                        }
                    }
                }
                if (this.currentScreen == null) {
                    if (!this.inGameHasFocus && Mouse.getEventButtonState()) {
                        this.setIngameFocus();
                        continue;
                    }
                    if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState()) {
                        this.clickMouse(0, true, false);
                        if (!Mouse.isGrabbed() && this.inputType == InputType.KEYBOARD && this.currentScreen == null) {
                            this.mouseInput.grabCursor();
                        }
                    }
                    if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState()) {
                        this.clickMouse(1, true, false);
                    }
                    if (Mouse.getEventButton() != 2 || !Mouse.getEventButtonState()) continue;
                    this.clickMiddleMouseButton();
                    continue;
                }
                if (this.currentScreen == null) continue;
                this.currentScreen.handleMouseInput();
            }
            if (this.toggleFlyPressed && !this.gameSettings.keyFly.isPressed()) {
                this.toggleFlyPressed = false;
                if (this.flyPressedTime + 400L > System.currentTimeMillis()) {
                    this.thePlayer.setNoclip(!this.thePlayer.noClip);
                }
            }
            while (Keyboard.next()) {
                Integer n;
                boolean control;
                boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                boolean bl = control = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
                if (!Keyboard.getEventKeyState() || !Keyboard.isKeyDown((int)61)) {
                    this.thePlayer.handleKeyPress(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                }
                if (Keyboard.getEventKey() == 61) {
                    if (Keyboard.getEventKeyState()) {
                        this.f3Press = true;
                    } else if (this.f3Press) {
                        if (control) {
                            this.gameSettings.showFrameTimes.toggle();
                        } else {
                            this.gameSettings.showDebugScreen.toggle();
                        }
                        this.f3Press = false;
                    }
                }
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 87) {
                    this.toggleFullscreen();
                    continue;
                }
                if (this.currentScreen != null) {
                    this.currentScreen.handleKeyboardInput();
                } else if (Keyboard.isKeyDown((int)61)) {
                    if (Keyboard.getEventKey() == 16) {
                        this.ingameGUI.addChatMessage(ChatColor.yellow + "Keyboard Shortcuts: ");
                        this.ingameGUI.addChatMessage("F3 + A: Reload Chunks");
                        this.ingameGUI.addChatMessage("F3 + C: Clear Chat");
                        this.ingameGUI.addChatMessage("F3 + D: Dump Textures");
                        this.ingameGUI.addChatMessage("F3 + F: Toggle Fullbright");
                        this.ingameGUI.addChatMessage("F3 + H: Toggle Item Durability");
                        this.ingameGUI.addChatMessage("F3 + N: Switch Gamemode");
                        this.ingameGUI.addChatMessage("F3 + P: Toggle Pause on lost focus");
                        this.ingameGUI.addChatMessage("F3 + R: Reload");
                        this.ingameGUI.addChatMessage("F3 + S: Toggle Smooth Lighting");
                        this.ingameGUI.addChatMessage("F4: Toggle All Overlays");
                        this.ingameGUI.addChatMessage("F12: Release Cursor");
                    }
                    if (Keyboard.getEventKey() == 19) {
                        this.forceReload();
                    } else if (Keyboard.getEventKey() == 49) {
                        if (this.theWorld.getWorldInfo().getCheatsEnabled() || this.theWorld.isMultiplayerAndNotHost) {
                            if (this.thePlayer.getGamemode() == Gamemode.creative) {
                                this.thePlayer.sendChatMessage("/gamemode 0");
                            } else {
                                this.thePlayer.sendChatMessage("/gamemode 1");
                            }
                        }
                    } else if (Keyboard.getEventKey() == 32) {
                        Textures.dumpTextures();
                    } else if (Keyboard.getEventKey() == 33) {
                        NetClientHandler queue = this.getSendQueue();
                        if (queue != null) {
                            PlayerProfile profile = queue.getPlayer(this.thePlayer.username);
                            if (profile != null && profile.isOperator) {
                                this.fullbright = !this.fullbright;
                                this.renderGlobal.loadRenderers();
                            }
                        } else if (this.theWorld.getWorldInfo().getCheatsEnabled()) {
                            this.fullbright = !this.fullbright;
                            this.renderGlobal.loadRenderers();
                        }
                    } else if (Keyboard.getEventKey() == 46) {
                        this.ingameGUI.clearChatMessages();
                    } else if (Keyboard.getEventKey() == 25) {
                        this.gameSettings.pauseOnLostFocus.toggle();
                        this.ingameGUI.addChatMessage("Pause on lost focus: " + ((Boolean)this.gameSettings.pauseOnLostFocus.value != false ? "On" : "Off"));
                    } else if (Keyboard.getEventKey() == 35) {
                        this.gameSettings.showItemDurability.toggle();
                        this.ingameGUI.addChatMessage("Item durability: " + ((Boolean)this.gameSettings.showItemDurability.value != false ? "Shown" : "Hidden"));
                    } else if (Keyboard.getEventKey() == 30) {
                        this.renderGlobal.loadRenderers();
                    } else if (Keyboard.getEventKey() == 31) {
                        this.gameSettings.ambientOcclusion.toggle();
                        this.renderGlobal.loadRenderers();
                    }
                    if (Keyboard.getEventKey() != 61) {
                        this.f3Press = false;
                    }
                } else if (Keyboard.getEventKey() == 62) {
                    if (control) {
                        IntegerOption queue = this.gameSettings.overlayMode;
                        Integer profile = (Integer)queue.value;
                        queue.value = (Integer)queue.value + 1;
                        n = queue.value;
                        queue = this.gameSettings.overlayMode;
                        Integer.valueOf((Integer)queue.value % 3);
                        queue.value = queue.value;
                    } else {
                        int i;
                        boolean on = false;
                        for (i = 0; i < this.gameSettings.overlayElements.length; ++i) {
                            if (!((Boolean)this.gameSettings.overlayElements[i].value).booleanValue()) continue;
                            on = true;
                            break;
                        }
                        for (i = 0; i < this.gameSettings.overlayElements.length; ++i) {
                            this.gameSettings.overlayElements[i].value = !on;
                        }
                    }
                } else if (Keyboard.getEventKey() == 88) {
                    this.mouseInput.releaseCursor();
                } else if (Keyboard.getEventKey() == 1) {
                    this.displayInGameMenu();
                } else if (control && this.gameSettings.keyScreenshot.isEventKey()) {
                    if (Shaders.shadersCompatible) {
                        try {
                            this.screenshotHelper.takePanoramaScreenshot();
                            this.ingameGUI.addChatMessage("Saved Panorama Screenshot!");
                        }
                        catch (Exception e) {
                            this.ingameGUI.addChatMessage("Error taking screenshot: " + e.getClass().getName() + ": " + e.getMessage());
                        }
                    }
                } else if (this.gameSettings.keyHideGui.isEventKey()) {
                    this.gameSettings.immersiveMode.toggle();
                } else if (this.gameSettings.keySwitchPerspective.isEventKey()) {
                    this.gameSettings.thirdPersonView.value = ((Integer)this.gameSettings.thirdPersonView.value + 1) % 3;
                } else if (Keyboard.getEventKey() == 65 && Shaders.shadersCompatible && this.render != null && ((Boolean)this.gameSettings.customShaders.value).booleanValue()) {
                    if (control) {
                        this.displayGuiScreen(new GuiShaderSelect(this));
                    } else {
                        this.gameSettings.shaders.toggle();
                        System.out.println("Shaders: " + this.gameSettings.shaders.value);
                        if (((Boolean)this.gameSettings.shaders.value).booleanValue()) {
                            try {
                                this.render.reload();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            this.render.disableShader();
                        }
                    }
                } else if (this.gameSettings.keyCinematicCamera.isEventKey()) {
                    this.gameSettings.smoothCamera.value = (Boolean)this.gameSettings.smoothCamera.value == false;
                } else if (this.gameSettings.keyInventory.isEventKey()) {
                    this.displayGuiScreen(this.thePlayer.getGamemode().getInventoryGui(this.thePlayer));
                } else if (this.gameSettings.keyGuidebook.isEventKey()) {
                    this.thePlayer.displayGUIGuidebook();
                } else if (this.gameSettings.keyDrop.isEventKey()) {
                    this.thePlayer.dropCurrentItem();
                } else if (this.gameSettings.keyPhotoMode.isEventKey()) {
                    this.displayGuiScreen(new GuiPhotoMode());
                } else if ((this.isMultiplayerWorld() || this.theWorld.getWorldInfo().getCheatsEnabled()) && this.gameSettings.keyChat.isEventKey()) {
                    this.displayGuiScreen(new GuiChat());
                } else if (this.isMultiplayerWorld() && this.gameSettings.keyPlayerList.isEventKey()) {
                    if (control && ((Boolean)this.gameSettings.showPlayerList.value).booleanValue()) {
                        IntegerOption e = this.gameSettings.playerListPosition;
                        Integer n2 = (Integer)e.value;
                        e.value = (Integer)e.value + 1;
                        n = e.value;
                        e = this.gameSettings.playerListPosition;
                        Integer.valueOf((Integer)e.value % 3);
                        e.value = e.value;
                    } else {
                        this.gameSettings.showPlayerList.value = (Boolean)this.gameSettings.showPlayerList.value == false;
                    }
                } else if (this.gameSettings.keyFly.isEventKey() && this.thePlayer.getGamemode().canPlayerFly) {
                    if (!this.toggleFlyPressed) {
                        this.toggleFlyPressed = true;
                    }
                    this.flyPressedTime = System.currentTimeMillis();
                } else if (this.gameSettings.keyHotBarSwitch.isEventKey()) {
                    if (shift) {
                        this.thePlayer.setHotbarOffset((this.thePlayer.inventory.hotbarOffset + 27) % 36);
                        this.hotbarSwapAnimationProgress = -1.0f;
                    } else {
                        this.thePlayer.setHotbarOffset((this.thePlayer.inventory.hotbarOffset + 9) % 36);
                        this.hotbarSwapAnimationProgress = 1.0f;
                    }
                    this.thePlayer.inventory.changeCurrentItem(0);
                } else if (this.gameSettings.keyCenterView.isEventKey()) {
                    this.thePlayer.rotationPitch = 0.0f;
                } else if (this.gameSettings.keyLockRotation.isEventKey()) {
                    if (control && this.thePlayer.rotationLock != null) {
                        IntegerOption e = this.gameSettings.rotationOverlayMode;
                        Integer n3 = (Integer)e.value;
                        e.value = (Integer)e.value + 1;
                        n = e.value;
                        e = this.gameSettings.rotationOverlayMode;
                        Integer.valueOf((Integer)e.value % 4);
                        e.value = e.value;
                    } else {
                        if (this.thePlayer.rotationLock == null) {
                            this.thePlayer.rotationLock = Direction.getDirection(this.thePlayer);
                            this.thePlayer.rotationLockHorizontal = Direction.getHorizontalDirection(this.thePlayer);
                            this.thePlayer.rotationLockVertical = Direction.getVerticalDirection(this.thePlayer);
                        } else {
                            this.thePlayer.rotationLock = null;
                            this.thePlayer.rotationLockHorizontal = null;
                            this.thePlayer.rotationLockVertical = null;
                        }
                        this.thePlayer.syncPlacementMode();
                    }
                } else if (this.gameSettings.keyToggleFog.isEventKey()) {
                    this.gameSettings.renderDistance.value = ((Integer)this.gameSettings.renderDistance.value + (shift ? 4 : 1)) % 5;
                } else if (this.gameSettings.keyHotBarLeft.isEventKey()) {
                    this.thePlayer.inventory.changeCurrentItem(1);
                } else if (this.gameSettings.keyHotBarRight.isEventKey()) {
                    this.thePlayer.inventory.changeCurrentItem(-1);
                }
                for (int i = 0; i < 9; ++i) {
                    if (Keyboard.getEventKey() != 2 + i) continue;
                    this.thePlayer.inventory.currentItem = i + this.thePlayer.inventory.hotbarOffset;
                }
            }
            boolean click0 = Mouse.isButtonDown((int)0) || this.controllerInput != null && this.controllerInput.buttonZR.isPressed();
            boolean bl = click1 = Mouse.isButtonDown((int)1) || this.controllerInput != null && this.controllerInput.buttonZL.isPressed();
            if (this.currentScreen == null) {
                if (click0 && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 4.0f && this.inGameHasFocus) {
                    this.clickMouse(0, (Boolean)this.gameSettings.autoHit.value, true);
                }
                if (click1 && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 4.0f && this.inGameHasFocus) {
                    this.clickMouse(1, (Boolean)this.gameSettings.autoHit.value, true);
                }
            }
            this.mineBlocks(0, this.currentScreen == null && click0 && this.inGameHasFocus);
        }
        if (this.theWorld != null) {
            if (this.thePlayer != null) {
                ++this.joinPlayerCounter;
                if (this.joinPlayerCounter == 30) {
                    this.joinPlayerCounter = 0;
                    this.theWorld.joinEntityInSurroundings(this.thePlayer);
                }
            }
            this.theWorld.difficultySetting = (Integer)this.gameSettings.difficulty.value;
            if (this.theWorld.isMultiplayerAndNotHost) {
                this.theWorld.difficultySetting = 3;
            }
            if (!this.isGamePaused) {
                this.entityRenderer.updateRenderer();
            }
            if (!this.isGamePaused) {
                this.renderGlobal.updateClouds();
            }
            if (!this.isGamePaused) {
                if (this.theWorld.lightningFlicker > 0) {
                    --this.theWorld.lightningFlicker;
                }
                this.theWorld.updateEntities();
            }
            if (!this.isGamePaused || this.isMultiplayerWorld()) {
                this.theWorld.setAllowedMobSpawns((Integer)this.gameSettings.difficulty.value > 0, true);
                this.theWorld.tick();
            }
            if (!this.isGamePaused && this.theWorld != null) {
                this.theWorld.randomDisplayUpdates(MathHelper.floor_double(this.thePlayer.posX), MathHelper.floor_double(this.thePlayer.posY), MathHelper.floor_double(this.thePlayer.posZ));
            }
            if (!this.isGamePaused) {
                this.effectRenderer.updateEffects();
            }
        }
        this.systemTime = System.currentTimeMillis();
    }

    public void handleControllerInput() {
        try {
            this.controllerInput.update();
        }
        catch (Exception e) {
            e.printStackTrace();
            InputHandler.controllers.remove(this.controllerInput);
            this.controllerInput = null;
            this.setInputType(InputType.KEYBOARD);
            return;
        }
        for (Joystick joystick : this.controllerInput.joysticks) {
            if (!(joystick.getX() < -0.5f || joystick.getX() > 0.5f || joystick.getY() < -0.5f) && !(joystick.getY() > 0.5f)) continue;
            this.setInputType(InputType.CONTROLLER);
        }
        ControllerInput controller = this.controllerInput;
        if (this.currentScreen == null) {
            if (controller.buttonZR.pressedThisFrame()) {
                this.clickMouse(0, true, false);
                this.mouseTicksRan = this.ticksRan;
            }
            if (controller.buttonZL.pressedThisFrame()) {
                this.clickMouse(1, true, false);
                this.mouseTicksRan = this.ticksRan;
            }
            if (controller.buttonY.pressedThisFrame() || controller.buttonX.pressedThisFrame()) {
                this.displayGuiScreen(this.thePlayer.getGamemode().getInventoryGui(this.thePlayer));
            }
            if (controller.buttonMinus.pressedThisFrame()) {
                this.gameSettings.showPlayerList.value = (Boolean)this.gameSettings.showPlayerList.value == false;
            }
            if (controller.buttonPlus.pressedThisFrame()) {
                this.displayGuiScreen(new GuiIngameMenu());
            }
            if (controller.digitalPad.up.pressedThisFrame()) {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.hotbarOffset + 27) % 36);
                this.hotbarSwapAnimationProgress = -1.0f;
                this.thePlayer.inventory.changeCurrentItem(0);
            }
            if (controller.digitalPad.down.pressedThisFrame()) {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.hotbarOffset + 9) % 36);
                this.hotbarSwapAnimationProgress = 1.0f;
                this.thePlayer.inventory.changeCurrentItem(0);
            }
            if (controller.digitalPad.left.pressedThisFrame() && this.thePlayer.getGamemode().canPlayerFly) {
                this.thePlayer.setNoclip(!this.thePlayer.noClip);
            }
            if (controller.buttonL.pressedThisFrame()) {
                this.thePlayer.inventory.changeCurrentItem(1);
            }
            if (controller.buttonR.pressedThisFrame()) {
                this.thePlayer.inventory.changeCurrentItem(-1);
            }
            if (controller.joyLeft.getButton().pressedThisFrame()) {
                IntegerOption integerOption = this.gameSettings.thirdPersonView;
                Integer n = (Integer)integerOption.value;
                integerOption.value = (Integer)integerOption.value + 1;
                Integer n2 = integerOption.value;
                integerOption = this.gameSettings.thirdPersonView;
                integerOption.value = (Integer)integerOption.value % 3;
            }
        } else {
            GuiScreen currentScreen = this.currentScreen;
            if (controller.buttonB.pressedThisFrame()) {
                currentScreen.keyTyped('\u0000', 14);
            }
            if (controller.buttonPlus.pressedThisFrame()) {
                currentScreen.keyTyped('\u0000', 1);
            }
            if (controller.buttonA.pressedThisFrame()) {
                currentScreen.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 0);
            }
            if (controller.buttonA.releasedThisFrame()) {
                currentScreen.mouseMovedOrUp((int)controller.cursorX, (int)controller.cursorY, 0);
            }
            if (controller.buttonY.pressedThisFrame()) {
                currentScreen.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 1);
            }
            if (controller.buttonY.releasedThisFrame()) {
                currentScreen.mouseMovedOrUp((int)controller.cursorX, (int)controller.cursorY, 1);
            }
            if (controller.buttonX.pressedThisFrame()) {
                currentScreen.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 10);
            }
            if (currentScreen instanceof GuiContainer) {
                try {
                    controller.inventoryControls((GuiContainer)currentScreen);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (controller.digitalPad.up.pressedThisFrame()) {
                currentScreen.selectButtonUp();
            } else if (controller.digitalPad.down.pressedThisFrame()) {
                currentScreen.selectButtonDown();
            } else if (controller.digitalPad.left.pressedThisFrame()) {
                currentScreen.selectButtonLeft();
            } else if (controller.digitalPad.right.pressedThisFrame()) {
                currentScreen.selectButtonRight();
            }
        }
    }

    private void forceReload() {
        System.out.println("FORCING RELOAD!");
        this.sndManager = new SoundManager();
        this.sndManager.loadSoundSettings(this.gameSettings);
        this.downloadResourcesThread.reloadResources();
        this.renderEngine.refreshTextures();
        if (this.render != null) {
            this.render.reload();
        }
    }

    public boolean isMultiplayerWorld() {
        return this.theWorld != null && this.theWorld.isMultiplayerAndNotHost;
    }

    public void startWorld(String s, String s1, long l) {
        this.changeWorld1(null);
        System.gc();
        if (this.saveLoader.isOldMapFormat(s)) {
            this.convertMapFormat(s, s1);
        } else {
            ISaveHandler isavehandler = this.saveLoader.getSaveLoader(s, false);
            World world = null;
            world = new World(isavehandler, s1, l, null);
            if (world.isNewWorld) {
                this.statFileWriter.writeStat(StatList.createWorldStat, 1);
                this.statFileWriter.writeStat(StatList.startGameStat, 1);
                this.changeWorld2(world, "Generating level");
            } else {
                this.statFileWriter.writeStat(StatList.loadWorldStat, 1);
                this.statFileWriter.writeStat(StatList.startGameStat, 1);
                this.changeWorld2(world, "Loading level");
            }
        }
    }

    public void usePortal(int dim) {
        net.minecraft.src.Dimension lastDim = net.minecraft.src.Dimension.dimensionList[this.thePlayer.dimension];
        net.minecraft.src.Dimension newDim = net.minecraft.src.Dimension.dimensionList[dim];
        System.out.println("Switching to dimension \"" + newDim.getName() + "\"!!");
        this.thePlayer.dimension = dim;
        this.theWorld.setEntityDead(this.thePlayer);
        this.thePlayer.isDead = false;
        double d = this.thePlayer.posX;
        double d1 = this.thePlayer.posZ;
        double newY = this.thePlayer.posY;
        this.thePlayer.setLocationAndAngles(d *= (double)net.minecraft.src.Dimension.getCoordScale(lastDim, newDim), newY, d1 *= (double)net.minecraft.src.Dimension.getCoordScale(lastDim, newDim), this.thePlayer.rotationYaw, this.thePlayer.rotationPitch);
        if (this.thePlayer.isEntityAlive()) {
            this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
        }
        World world = null;
        world = new World(this.theWorld, newDim);
        if (newDim == lastDim.homeDim) {
            this.changeWorld(world, "Leaving " + lastDim.getName(), this.thePlayer);
        } else {
            this.changeWorld(world, "Entering " + newDim.getName(), this.thePlayer);
        }
        this.thePlayer.worldObj = this.theWorld;
        if (this.thePlayer.isEntityAlive()) {
            this.thePlayer.setLocationAndAngles(d, newY, d1, this.thePlayer.rotationYaw, this.thePlayer.rotationPitch);
            this.theWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            new Teleporter().func_4107_a(this.theWorld, this.thePlayer, lastDim, newDim);
        }
    }

    public void changeWorld1(World world) {
        this.changeWorld2(world, "");
    }

    public void changeWorld2(World world, String s) {
        this.changeWorld(world, s, null);
    }

    public void changeWorld(World world, String s, EntityPlayer entityplayer) {
        this.fullbright = false;
        this.statFileWriter.func_27175_b();
        this.statFileWriter.syncStats();
        this.renderViewEntity = null;
        this.loadingScreen.printText(s);
        this.loadingScreen.displayLoadingString("");
        this.sndManager.playStreaming(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.theWorld != null) {
            this.theWorld.saveWorldIndirectly(this.loadingScreen);
            if (world == null) {
                this.theWorld.getIChunkProvider().unloadAllChunks();
            }
        }
        this.theWorld = world;
        if (world != null) {
            IChunkProvider ichunkprovider;
            this.playerController.changeWorld(world);
            if (!this.isMultiplayerWorld()) {
                if (entityplayer == null) {
                    this.thePlayer = (EntityPlayerSP)world.func_4085_a(EntityPlayerSP.class);
                }
            } else if (this.thePlayer != null) {
                this.thePlayer.preparePlayerToSpawn();
                if (world != null) {
                    world.entityJoinedWorld(this.thePlayer);
                }
            }
            if (!world.isMultiplayerAndNotHost) {
                this.func_6255_d(s);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(world);
                this.thePlayer.preparePlayerToSpawn();
                this.playerController.flipPlayer(this.thePlayer);
            }
            this.thePlayer.movementInput = new MovementInputFromOptions(this.gameSettings);
            if (this.renderGlobal != null) {
                this.renderGlobal.changeWorld(world);
            }
            if (this.effectRenderer != null) {
                this.effectRenderer.clearEffects(world);
            }
            this.playerController.func_6473_b(this.thePlayer);
            if (entityplayer != null) {
                world.emptyMethod1();
            }
            if ((ichunkprovider = world.getIChunkProvider()) instanceof ChunkProviderLoadOrGenerate) {
                ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
                int i = MathHelper.floor_float((int)this.thePlayer.posX) >> 4;
                int j = MathHelper.floor_float((int)this.thePlayer.posZ) >> 4;
                chunkproviderloadorgenerate.setCurrentChunkOver(i, j);
            }
            world.spawnPlayerWithLoadedChunks(this.thePlayer);
            if (world.isNewWorld) {
                world.saveWorldIndirectly(this.loadingScreen);
            }
            this.renderViewEntity = this.thePlayer;
        } else {
            this.thePlayer = null;
        }
        System.gc();
        this.systemTime = 0L;
    }

    private void convertMapFormat(String s, String s1) {
        this.loadingScreen.printText("Converting World to " + this.saveLoader.getFormatName());
        this.loadingScreen.displayLoadingString("This may take a while :)");
        this.saveLoader.convertMapFormat(s, this.loadingScreen);
        this.startWorld(s, s1, 0L);
    }

    private void func_6255_d(String s) {
        this.loadingScreen.printText(s);
        this.loadingScreen.displayLoadingString("Building terrain");
        int c = 128;
        int i = 0;
        int j = c * 2 / 16 + 1;
        j *= j;
        IChunkProvider ichunkprovider = this.theWorld.getIChunkProvider();
        ChunkCoordinates chunkcoordinates = this.theWorld.getSpawnPoint();
        if (this.thePlayer != null) {
            chunkcoordinates.x = (int)this.thePlayer.posX;
            chunkcoordinates.z = (int)this.thePlayer.posZ;
        }
        if (ichunkprovider instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            chunkproviderloadorgenerate.setCurrentChunkOver(chunkcoordinates.x >> 4, chunkcoordinates.z >> 4);
        }
        for (int k = -c; k <= c; k += 16) {
            for (int l = -c; l <= c; l += 16) {
                this.loadingScreen.setLoadingProgress(i++ * 100 / j);
                this.theWorld.getBlockId(chunkcoordinates.x + k, 64, chunkcoordinates.z + l);
                while (this.theWorld.updatingLighting()) {
                }
            }
        }
        this.loadingScreen.displayLoadingString("Simulating world for a bit");
        j = 2000;
        this.theWorld.dropOldChunks();
    }

    public void installResource(String s, File file) {
        int i = s.indexOf("/");
        String s1 = s.substring(0, i);
        s = s.substring(i + 1);
        if (s1.equalsIgnoreCase("sound")) {
            this.sndManager.addSound(s, file);
        } else if (s1.equalsIgnoreCase("newsound")) {
            this.sndManager.addSound(s, file);
        } else if (s1.equalsIgnoreCase("streaming")) {
            this.sndManager.addStreaming(s, file);
        } else if (s1.equalsIgnoreCase("music")) {
            this.sndManager.addMusic(s, file);
        } else if (s1.equalsIgnoreCase("newmusic")) {
            this.sndManager.addMusic(s, file);
        }
    }

    public OpenGlCapsChecker getOpenGlCapsChecker() {
        return this.glCapabilities;
    }

    public String func_6241_m() {
        return this.renderGlobal.getDebugInfoRenders();
    }

    public String func_6262_n() {
        return this.renderGlobal.getDebugInfoEntities();
    }

    public String func_21002_o() {
        return this.theWorld.func_21119_g();
    }

    public String func_6245_o() {
        return "P: " + this.effectRenderer.getStatistics() + ". T: " + this.theWorld.func_687_d();
    }

    public void respawn(boolean flag, int i) {
        IChunkProvider ichunkprovider;
        if (!this.theWorld.isMultiplayerAndNotHost && !this.theWorld.dimension.worldType.worldProvider.canRespawnHere()) {
            this.usePortal(i);
        }
        ChunkCoordinates chunkcoordinates = null;
        ChunkCoordinates chunkcoordinates1 = null;
        boolean flag1 = true;
        if (this.thePlayer != null && !flag && (chunkcoordinates = this.thePlayer.getPlayerSpawnCoordinate()) != null && (chunkcoordinates1 = EntityPlayer.func_25060_a(this.theWorld, chunkcoordinates)) == null) {
            this.thePlayer.addChatMessage("bed.notValid");
        }
        if (chunkcoordinates1 == null) {
            chunkcoordinates1 = this.theWorld.getSpawnPoint();
            flag1 = false;
        }
        if ((ichunkprovider = this.theWorld.getIChunkProvider()) instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            chunkproviderloadorgenerate.setCurrentChunkOver(chunkcoordinates1.x >> 4, chunkcoordinates1.z >> 4);
        }
        this.theWorld.setSpawnLocation();
        this.theWorld.updateEntityList();
        int j = 0;
        if (this.thePlayer != null) {
            j = this.thePlayer.entityId;
            this.theWorld.setEntityDead(this.thePlayer);
        }
        this.renderViewEntity = null;
        Gamemode playerGamemode = this.thePlayer.getGamemode();
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.theWorld);
        this.thePlayer.dimension = i;
        this.thePlayer.setGamemode(playerGamemode);
        this.renderViewEntity = this.thePlayer;
        this.thePlayer.preparePlayerToSpawn();
        if (flag1) {
            this.thePlayer.setPlayerSpawnCoordinate(chunkcoordinates);
            this.thePlayer.setLocationAndAngles((float)chunkcoordinates1.x + 0.5f, (float)chunkcoordinates1.y + 0.1f, (float)chunkcoordinates1.z + 0.5f, 0.0f, 0.0f);
        }
        this.playerController.flipPlayer(this.thePlayer);
        this.theWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.movementInput = new MovementInputFromOptions(this.gameSettings);
        this.thePlayer.entityId = j;
        this.thePlayer.func_6420_o();
        this.playerController.func_6473_b(this.thePlayer);
        this.func_6255_d("Respawning");
        if (this.currentScreen instanceof GuiGameOver) {
            this.displayGuiScreen(null);
        }
    }

    public static void startMainThread(String s, String s1) {
        Minecraft.startMainThread(s, s1, null);
    }

    public static void startMainThread(String s, String s1, String s2) {
        boolean flag = false;
        String s3 = s;
        Frame frame = new Frame("Better Than Adventure");
        Canvas canvas = new Canvas();
        frame.setLayout(new BorderLayout());
        frame.add((Component)canvas, "Center");
        try {
            frame.setIconImage(ImageIO.read(Minecraft.class.getResourceAsStream("/icon.png")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        canvas.setPreferredSize(new Dimension(854, 480));
        frame.pack();
        frame.setLocationRelativeTo(null);
        MinecraftImpl minecraftimpl = new MinecraftImpl(frame, canvas, null, 854, 480, flag, frame);
        Thread thread = new Thread((Runnable)minecraftimpl, "Client-Main");
        thread.setPriority(10);
        minecraftimpl.minecraftUri = "www.minecraft.net";
        minecraftimpl.session = s3 != null && s1 != null ? new Session(s3, s1) : new Session("Player" + System.currentTimeMillis() % 1000L, "");
        if (s2 != null) {
            String[] as = s2.split(":");
            minecraftimpl.setServer(as[0], Integer.parseInt(as[1]));
        }
        frame.setVisible(true);
        frame.addWindowListener(new GameWindowListener(minecraftimpl, thread));
        thread.start();
    }

    public NetClientHandler getSendQueue() {
        if (this.thePlayer instanceof EntityClientPlayerMP) {
            return ((EntityClientPlayerMP)this.thePlayer).sendQueue;
        }
        return null;
    }

    public void setRenderer(IRenderer renderer) {
        if (this.render != null) {
            this.render.delete();
        }
        this.render = renderer;
        if (Shaders.shadersCompatible) {
            GL20.glUseProgram((int)0);
            ARBFramebufferObject.glBindFramebuffer((int)36160, (int)0);
            try {
                this.render.reload();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String s = null;
        String s1 = null;
        s = "Player" + System.currentTimeMillis() % 1000L;
        if (args.length > 0) {
            s = args[0];
        }
        s1 = "-";
        if (args.length > 1) {
            s1 = args[1];
        }
        Minecraft.startMainThread(s, s1);
    }

    public void setInputType(InputType inputType) {
        if (inputType != this.inputType) {
            System.out.println("Set input type to " + inputType.name());
        }
        this.inputType = inputType;
        if (inputType == InputType.CONTROLLER) {
            this.mouseInput.grabCursor();
        }
        if (inputType == InputType.KEYBOARD) {
            if (this.inGameHasFocus && !Mouse.isGrabbed()) {
                this.mouseInput.grabCursor();
            }
            if (!this.inGameHasFocus && Mouse.isGrabbed()) {
                this.mouseInput.releaseCursor();
            }
        }
    }

    public static boolean isFancyGraphicsEnabled() {
        return theMinecraft != null && (Boolean)Minecraft.theMinecraft.gameSettings.fancyGraphics.value != false;
    }

    public static boolean isAmbientOcclusionEnabled() {
        return theMinecraft != null && (Boolean)Minecraft.theMinecraft.gameSettings.ambientOcclusion.value != false;
    }

    public static boolean isTreeShadingEnabled() {
        return theMinecraft != null && (Boolean)Minecraft.theMinecraft.gameSettings.treeShadows.value != false;
    }

    public static boolean isChunkLoadingDynamic() {
        return theMinecraft != null && (Boolean)Minecraft.theMinecraft.gameSettings.chunkLoading.value != false;
    }

    public static boolean isDebugInfoEnabled() {
        return theMinecraft != null && (Boolean)Minecraft.theMinecraft.gameSettings.showDebugScreen.value != false;
    }

    public static boolean canRenderEntityLabel() {
        return Minecraft.isDebugInfoEnabled() && Minecraft.theMinecraft.thePlayer != null && Minecraft.theMinecraft.thePlayer.getGamemode() == Gamemode.creative;
    }

    public boolean lineIsCommand(String s) {
        if (!s.startsWith("/")) {
            // empty if block
        }
        return false;
    }

    public static Minecraft getMinecraft() {
        return theMinecraft;
    }

    static {
        frameTimes = new long[512];
        tickTimes = new long[512];
        numRecordedFrameTimes = 0;
        hasPaidCheckTime = 0L;
        minecraftDir = null;
    }
}

