/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AchievementList;
import net.minecraft.src.Block;
import net.minecraft.src.IStatStringFormat;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatStringTranslate;

public class Achievement
extends StatBase {
    public final int x;
    public final int y;
    public final Achievement parent;
    private final String description;
    private IStatStringFormat statStringFormatter;
    public final ItemStack item;
    private boolean isSpecial;

    public Achievement(int id, String name, int x, int y, Item item, Achievement parent) {
        this(id, name, x, y, new ItemStack(item), parent);
    }

    public Achievement(int i, String name, int x, int y, Block block, Achievement parent) {
        this(i, name, x, y, new ItemStack(block), parent);
    }

    public Achievement(int id, String name, int x, int y, ItemStack item, Achievement parent) {
        super(0x500000 + id, StatStringTranslate.translateToLocal("achievement." + name));
        this.item = item;
        this.description = StatStringTranslate.translateToLocal("achievement." + name + ".desc");
        this.x = x;
        this.y = y;
        if (x < AchievementList.minX) {
            AchievementList.minX = x;
        }
        if (y < AchievementList.minY) {
            AchievementList.minY = y;
        }
        if (x > AchievementList.maxX) {
            AchievementList.maxX = x;
        }
        if (y > AchievementList.maxY) {
            AchievementList.maxY = y;
        }
        this.parent = parent;
    }

    public Achievement setClientsideAchievement() {
        this.clientside = true;
        return this;
    }

    public Achievement setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public Achievement registerAchievement() {
        super.registerStat();
        AchievementList.achievementList.add(this);
        return this;
    }

    @Override
    public boolean isAchievement() {
        return true;
    }

    public String getDescription() {
        if (this.statStringFormatter != null) {
            return this.statStringFormatter.formatString(this.description);
        }
        return this.description;
    }

    public Achievement setStatStringFormatter(IStatStringFormat istatstringformat) {
        this.statStringFormatter = istatstringformat;
        return this;
    }

    public boolean getSpecial() {
        return this.isSpecial;
    }

    @Override
    public StatBase registerStat() {
        return this.registerAchievement();
    }

    @Override
    public StatBase setClientside() {
        return this.setClientsideAchievement();
    }
}

