/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import b100.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.AchievementList;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockAlgae;
import net.minecraft.src.BlockBed;
import net.minecraft.src.BlockBedrock;
import net.minecraft.src.BlockBlastFurnace;
import net.minecraft.src.BlockButton;
import net.minecraft.src.BlockCactus;
import net.minecraft.src.BlockCake;
import net.minecraft.src.BlockChest;
import net.minecraft.src.BlockChestPainted;
import net.minecraft.src.BlockClay;
import net.minecraft.src.BlockCrops;
import net.minecraft.src.BlockDeadBush;
import net.minecraft.src.BlockDetectorRail;
import net.minecraft.src.BlockDirtPath;
import net.minecraft.src.BlockDispenser;
import net.minecraft.src.BlockDoor;
import net.minecraft.src.BlockFarmland;
import net.minecraft.src.BlockFence;
import net.minecraft.src.BlockFenceGate;
import net.minecraft.src.BlockFenceGatePainted;
import net.minecraft.src.BlockFencePainted;
import net.minecraft.src.BlockFire;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.BlockFluidFlowing;
import net.minecraft.src.BlockFluidStill;
import net.minecraft.src.BlockFurnace;
import net.minecraft.src.BlockGlass;
import net.minecraft.src.BlockGlassTinted;
import net.minecraft.src.BlockGlowStone;
import net.minecraft.src.BlockGrass;
import net.minecraft.src.BlockGrassRetro;
import net.minecraft.src.BlockGravel;
import net.minecraft.src.BlockIce;
import net.minecraft.src.BlockIgneousNetherrack;
import net.minecraft.src.BlockJukeBox;
import net.minecraft.src.BlockLadder;
import net.minecraft.src.BlockLamp;
import net.minecraft.src.BlockLayerBase;
import net.minecraft.src.BlockLayerLeaves;
import net.minecraft.src.BlockLayerSlate;
import net.minecraft.src.BlockLayerSnow;
import net.minecraft.src.BlockLeavesBirch;
import net.minecraft.src.BlockLeavesCherry;
import net.minecraft.src.BlockLeavesCherryFlowering;
import net.minecraft.src.BlockLeavesEucalyptus;
import net.minecraft.src.BlockLeavesOak;
import net.minecraft.src.BlockLeavesPine;
import net.minecraft.src.BlockLeavesRetro;
import net.minecraft.src.BlockLeavesShrub;
import net.minecraft.src.BlockLever;
import net.minecraft.src.BlockLog;
import net.minecraft.src.BlockMesh;
import net.minecraft.src.BlockMobSpawner;
import net.minecraft.src.BlockMoss;
import net.minecraft.src.BlockMushroom;
import net.minecraft.src.BlockNetherCoal;
import net.minecraft.src.BlockNote;
import net.minecraft.src.BlockOreCoal;
import net.minecraft.src.BlockOreDiamond;
import net.minecraft.src.BlockOreLapis;
import net.minecraft.src.BlockOreNetherCoal;
import net.minecraft.src.BlockOreRedstone;
import net.minecraft.src.BlockPistonBase;
import net.minecraft.src.BlockPistonHead;
import net.minecraft.src.BlockPistonMoving;
import net.minecraft.src.BlockPlanksPainted;
import net.minecraft.src.BlockPortal;
import net.minecraft.src.BlockPressurePlate;
import net.minecraft.src.BlockPumpkin;
import net.minecraft.src.BlockRail;
import net.minecraft.src.BlockRedstone;
import net.minecraft.src.BlockRedstoneRepeater;
import net.minecraft.src.BlockRedstoneTorch;
import net.minecraft.src.BlockRedstoneWire;
import net.minecraft.src.BlockSand;
import net.minecraft.src.BlockSaplingBirch;
import net.minecraft.src.BlockSaplingCherry;
import net.minecraft.src.BlockSaplingEucalyptus;
import net.minecraft.src.BlockSaplingOak;
import net.minecraft.src.BlockSaplingPine;
import net.minecraft.src.BlockSaplingRetro;
import net.minecraft.src.BlockSaplingShrub;
import net.minecraft.src.BlockSensor;
import net.minecraft.src.BlockSign;
import net.minecraft.src.BlockSlab;
import net.minecraft.src.BlockSlabMarble;
import net.minecraft.src.BlockSlabPainted;
import net.minecraft.src.BlockSnow;
import net.minecraft.src.BlockSoulSand;
import net.minecraft.src.BlockSpikes;
import net.minecraft.src.BlockSpinifex;
import net.minecraft.src.BlockSponge;
import net.minecraft.src.BlockStairs;
import net.minecraft.src.BlockStairsPainted;
import net.minecraft.src.BlockStone;
import net.minecraft.src.BlockSugarcane;
import net.minecraft.src.BlockTNT;
import net.minecraft.src.BlockTallGrass;
import net.minecraft.src.BlockTorch;
import net.minecraft.src.BlockTrapDoor;
import net.minecraft.src.BlockTrommel;
import net.minecraft.src.BlockWeb;
import net.minecraft.src.BlockWool;
import net.minecraft.src.BlockWorkbench;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumDropCause;
import net.minecraft.src.EnumMobType;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemBlockAlgae;
import net.minecraft.src.ItemBlockLamp;
import net.minecraft.src.ItemBlockLayer;
import net.minecraft.src.ItemBlockPainted;
import net.minecraft.src.ItemBlockPiston;
import net.minecraft.src.ItemBlockSlab;
import net.minecraft.src.ItemBlockSlabPainted;
import net.minecraft.src.ItemBlockStairsPainted;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.StatList;
import net.minecraft.src.StatStringTranslate;
import net.minecraft.src.StepSound;
import net.minecraft.src.StepSoundSand;
import net.minecraft.src.StepSoundStone;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class Block {
    public static final StepSound soundPowderFootstep;
    public static final StepSound soundWoodFootstep;
    public static final StepSound soundGravelFootstep;
    public static final StepSound soundGrassFootstep;
    public static final StepSound soundStoneFootstep;
    public static final StepSound soundMetalFootstep;
    public static final StepSound soundGlassFootstep;
    public static final StepSound soundClothFootstep;
    public static final StepSound soundSandFootstep;
    public static final Block[] blocksList;
    public static final boolean[] tickOnLoad;
    public static final boolean[] opaqueCubeLookup;
    public static final boolean[] isBlockContainer;
    public static final int[] lightOpacity;
    public static final boolean[] canBlockGrass;
    public static final int[] lightValue;
    public static final boolean[] neighborNotifyOnMetadataChangeDisabled;
    public static final Map<String, Integer> nameToIdMap;
    public static final Block stone;
    public static final Block basalt;
    public static final Block limestone;
    public static final Block granite;
    public static final Block marble;
    public static final Block slate;
    public static final Block cobbleStone;
    public static final Block cobbleStoneMossy;
    public static final Block cobbleBasalt;
    public static final Block cobbleLimestone;
    public static final Block cobbleGranite;
    public static final Block pillarMarble;
    public static final Block capstoneMarble;
    public static final Block sandstone;
    public static final Block stoneCarved;
    public static final Block graniteCarved;
    public static final Block limestoneCarved;
    public static final Block basaltCarved;
    public static final Block planksOak;
    public static final Block planksOakPainted;
    public static final Block torchCoal;
    public static final Block ladderOak;
    public static final Block fencePlanksOak;
    public static final Block fencePlanksOakPainted;
    public static final Block fencegatePlanksOak;
    public static final Block fencegatePlanksOakPainted;
    public static final Block bookshelfPlanksOak;
    public static final Block wool;
    public static final Block brickClay;
    public static final Block brickStonePolished;
    public static final Block brickStonePolishedMossy;
    public static final Block brickSandstone;
    public static final Block brickGold;
    public static final Block brickLapis;
    public static final Block brickBasalt;
    public static final Block brickLimestone;
    public static final Block brickGranite;
    public static final Block brickMarble;
    public static final Block brickSlate;
    public static final Block brickStone;
    public static final Block slabPlanksOak;
    public static final Block slabCobbleStone;
    public static final Block slabSandstone;
    public static final Block slabBrickStonePolished;
    public static final Block slabStonePolished;
    public static final Block slabBrickMarble;
    public static final Block slabBrickClay;
    public static final Block slabCapstoneMarble;
    public static final Block slabCobbleBasalt;
    public static final Block slabCobbleLimestone;
    public static final Block slabCobbleGranite;
    public static final Block slabBrickBasalt;
    public static final Block slabBrickLimestone;
    public static final Block slabBrickGranite;
    public static final Block slabPlanksOakPainted;
    public static final Block slabBrickSlate;
    public static final Block slabBrickStone;
    public static final Block slabGranitePolished;
    public static final Block slabLimestonePolished;
    public static final Block slabBasaltPolished;
    public static final Block stairsPlanksOak;
    public static final Block stairsCobbleStone;
    public static final Block stairsBrickStonePolished;
    public static final Block stairsBrickMarble;
    public static final Block stairsCobbleBasalt;
    public static final Block stairsCobbleLimestone;
    public static final Block stairsCobbleGranite;
    public static final Block stairsBrickBasalt;
    public static final Block stairsBrickLimestone;
    public static final Block stairsBrickGranite;
    public static final Block stairsBrickClay;
    public static final Block stairsPlanksOakPainted;
    public static final Block stairsBrickSlate;
    public static final Block stairsBrickStone;
    public static final Block obsidian;
    public static final Block glass;
    public static final Block glassTinted;
    public static final Block grass;
    public static final Block grassRetro;
    public static final Block pathDirt;
    public static final Block dirt;
    public static final Block dirtScorched;
    public static final Block dirtScorchedRich;
    public static final Block spongeDry;
    public static final Block spongeWet;
    public static final Block mossStone;
    public static final Block mossBasalt;
    public static final Block mossLimestone;
    public static final Block mossGranite;
    public static final Block sand;
    public static final Block gravel;
    public static final Block bedrock;
    public static final Block fluidWaterFlowing;
    public static final Block fluidWaterStill;
    public static final Block fluidLavaFlowing;
    public static final Block fluidLavaStill;
    public static final Block logOak;
    public static final Block logPine;
    public static final Block logBirch;
    public static final Block logCherry;
    public static final Block logEucalyptus;
    public static final Block logOakMossy;
    public static final Block leavesOak;
    public static final Block leavesOakRetro;
    public static final Block leavesPine;
    public static final Block leavesBirch;
    public static final Block leavesCherry;
    public static final Block leavesEucalyptus;
    public static final Block leavesShrub;
    public static final Block leavesCherryFlowering;
    public static final Block saplingOak;
    public static final Block saplingOakRetro;
    public static final Block saplingPine;
    public static final Block saplingBirch;
    public static final Block saplingCherry;
    public static final Block saplingEucalyptus;
    public static final Block saplingShrub;
    public static final Block tallgrass;
    public static final Block tallgrassFern;
    public static final Block deadbush;
    public static final Block spinifex;
    public static final Block algae;
    public static final Block flowerYellow;
    public static final Block flowerRed;
    public static final Block mushroomBrown;
    public static final Block mushroomRed;
    public static final Block oreCoalStone;
    public static final Block oreCoalBasalt;
    public static final Block oreCoalLimestone;
    public static final Block oreCoalGranite;
    public static final Block oreIronStone;
    public static final Block oreIronBasalt;
    public static final Block oreIronLimestone;
    public static final Block oreIronGranite;
    public static final Block oreGoldStone;
    public static final Block oreGoldBasalt;
    public static final Block oreGoldLimestone;
    public static final Block oreGoldGranite;
    public static final Block oreLapisStone;
    public static final Block oreLapisBasalt;
    public static final Block oreLapisLimestone;
    public static final Block oreLapisGranite;
    public static final Block oreRedstoneStone;
    public static final Block oreRedstoneBasalt;
    public static final Block oreRedstoneLimestone;
    public static final Block oreRedstoneGranite;
    public static final Block oreRedstoneGlowingStone;
    public static final Block oreRedstoneGlowingBasalt;
    public static final Block oreRedstoneGlowingLimestone;
    public static final Block oreRedstoneGlowingGranite;
    public static final Block oreDiamondStone;
    public static final Block oreDiamondBasalt;
    public static final Block oreDiamondLimestone;
    public static final Block oreDiamondGranite;
    public static final Block oreNethercoalNetherrack;
    public static final Block blockCoal;
    public static final Block blockIron;
    public static final Block blockGold;
    public static final Block blockLapis;
    public static final Block blockRedstone;
    public static final Block blockDiamond;
    public static final Block blockNetherCoal;
    public static final Block blockSteel;
    public static final Block blockQuartz;
    public static final Block blockOlivine;
    public static final Block blockCharcoal;
    public static final Block wireRedstone;
    public static final Block torchRedstoneIdle;
    public static final Block torchRedstoneActive;
    public static final Block buttonStone;
    public static final Block leverCobbleStone;
    public static final Block pressureplateStone;
    public static final Block pressureplatePlanksOak;
    public static final Block pressureplateCobbleStone;
    public static final Block motionsensorIdle;
    public static final Block motionsensorActive;
    public static final Block repeaterIdle;
    public static final Block repeaterActive;
    public static final Block pistonBase;
    public static final Block pistonBaseSticky;
    public static final Block pistonHead;
    public static final Block pistonMoving;
    public static final Block noteblock;
    public static final Block rail;
    public static final Block railPowered;
    public static final Block railDetector;
    public static final Block spikes;
    public static final Block dispenserCobbleStone;
    public static final Block trapdoorPlanksOak;
    public static final Block trapdoorIron;
    public static final Block tnt;
    public static final Block doorPlanksOakBottom;
    public static final Block doorPlanksOakTop;
    public static final Block doorIronBottom;
    public static final Block doorIronTop;
    public static final Block mesh;
    public static final Block bed;
    public static final Block cobweb;
    public static final Block fire;
    public static final Block mobspawner;
    public static final Block workbench;
    public static final Block furnaceStoneIdle;
    public static final Block furnaceStoneActive;
    public static final Block furnaceBlastIdle;
    public static final Block furnaceBlastActive;
    public static final Block trommelIdle;
    public static final Block trommelActive;
    public static final Block chestPlanksOak;
    public static final Block chestPlanksOakPainted;
    public static final Block cropsWheat;
    public static final Block farmlandDirt;
    public static final Block signPostPlanksOak;
    public static final Block signWallPlanksOak;
    public static final Block layerSnow;
    public static final Block layerLeavesOak;
    public static final Block layerSlate;
    public static final Block ice;
    public static final Block blockSnow;
    public static final Block cactus;
    public static final Block blockClay;
    public static final Block sugarcane;
    public static final Block jukebox;
    public static final Block pumpkin;
    public static final Block pumpkinCarvedIdle;
    public static final Block pumpkinCarvedActive;
    public static final Block netherrack;
    public static final Block netherrackIgneous;
    public static final Block soulsand;
    public static final Block glowstone;
    public static final Block portalNether;
    public static final Block portalParadise;
    public static final Block cake;
    public static final Block lampIdle;
    public static final Block lampActive;
    public static final Block stonePolished;
    public static final Block granitePolished;
    public static final Block limestonePolished;
    public static final Block basaltPolished;
    public static final Block slatePolished;
    public int[] atlasIndices = new int[6];
    public final int blockID;
    protected float blockHardness;
    protected float blockResistance;
    protected boolean blockConstructorCalled = true;
    protected boolean enableStats = true;
    protected boolean isLitInteriorSurface;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    public StepSound stepSound = soundPowderFootstep;
    public float blockParticleGravity = 1.0f;
    public final Material blockMaterial;
    public float slipperiness = 0.6f;
    protected String blockName;
    public boolean hasOverbright = false;
    public Block dropOverride = null;
    public boolean notInCreativeMenu = false;
    public boolean canFenceConnectTo = false;
    public boolean plantable = false;
    public boolean mossGrowable = false;
    public boolean placeOverwrites = false;
    public boolean immovable = false;

    public Block(int i, Material material) {
        if (blocksList[i] != null) {
            throw new IllegalArgumentException("Slot " + i + " is already occupied by " + blocksList[i] + " when adding " + this);
        }
        this.blockMaterial = material;
        Block.blocksList[i] = this;
        this.blockID = i;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Block.opaqueCubeLookup[i] = this.isOpaqueCube();
        Block.lightOpacity[i] = this.isOpaqueCube() || this.blocksLight() ? 255 : 0;
        Block.canBlockGrass[i] = !material.getCanBlockGrass();
        Block.isBlockContainer[i] = false;
    }

    protected Block disableNeighborNotifyOnMetadataChange() {
        Block.neighborNotifyOnMetadataChangeDisabled[this.blockID] = true;
        return this;
    }

    protected void initializeBlock() {
    }

    protected Block setStepSound(StepSound stepsound) {
        this.stepSound = stepsound;
        return this;
    }

    protected Block setLightOpacity(int i) {
        Block.lightOpacity[this.blockID] = i;
        return this;
    }

    protected Block setLightValue(float f) {
        Block.lightValue[this.blockID] = (int)(15.0f * f);
        return this;
    }

    protected Block setLightValue(int i) {
        Block.lightValue[this.blockID] = i;
        return this;
    }

    protected Block setImmovable() {
        this.immovable = true;
        return this;
    }

    protected Block setResistance(float f) {
        this.blockResistance = f * 3.0f;
        return this;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public boolean canPlaceOnSurface() {
        return this.renderAsNormalBlock();
    }

    public boolean canPlaceOnSurfaceOnCondition(World world, int x, int y, int z) {
        return this.canPlaceOnSurface();
    }

    public boolean renderAsNormalBlockOnCondition(World world, int x, int y, int z) {
        return this.renderAsNormalBlock();
    }

    public boolean canPlaceOnSurfaceOfBlock(World world, int x, int y, int z) {
        return this.canPlaceOnSurface();
    }

    public int getRenderType() {
        return 0;
    }

    protected Block setHardness(float f) {
        this.blockHardness = f;
        if (this.blockResistance < f * 5.0f) {
            this.blockResistance = f * 5.0f;
        }
        return this;
    }

    protected Block setDropOverride(Block block) {
        this.dropOverride = block;
        return this;
    }

    protected Block setIsLitInteriorSurface(boolean isLit) {
        this.isLitInteriorSurface = isLit;
        return this;
    }

    protected Block setBlockUnbreakable() {
        this.setHardness(-1.0f);
        return this;
    }

    public float getHardness() {
        return this.blockHardness;
    }

    public ItemStack getBreakResult(World world, EntityPlayer player, int x, int y, int z, EnumDropCause dropCause, Random random) {
        return new ItemStack(this, 1);
    }

    public Block setTexCoords(int x, int y) {
        return this.setTexCoords(x, y, x, y, x, y, x, y, x, y, x, y);
    }

    public Block setTexCoords(int topBottomX, int topBottomY, int sidesX, int sidesY) {
        return this.setTexCoords(topBottomX, topBottomY, topBottomX, topBottomY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY);
    }

    public Block setTexCoords(int topX, int topY, int bottomX, int bottomY, int sidesX, int sidesY) {
        return this.setTexCoords(topX, topY, bottomX, bottomY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY);
    }

    public Block setTexCoords(int topX, int topY, int bottomX, int bottomY, int northX, int northY, int eastX, int eastY, int southX, int southY, int westX, int westY) {
        this.atlasIndices[1] = Block.texCoordToIndex(topX, topY);
        this.atlasIndices[0] = Block.texCoordToIndex(bottomX, bottomY);
        this.atlasIndices[4] = Block.texCoordToIndex(northX, northY);
        this.atlasIndices[2] = Block.texCoordToIndex(eastX, eastY);
        this.atlasIndices[5] = Block.texCoordToIndex(southX, southY);
        this.atlasIndices[3] = Block.texCoordToIndex(westX, westY);
        return this;
    }

    public static int texCoordToIndex(int x, int y) {
        if (x > net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES || y > net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES) {
            System.out.println("Errr!");
        }
        return x + y * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES;
    }

    protected Block setTickOnLoad(boolean flag) {
        Block.tickOnLoad[this.blockID] = flag;
        return this;
    }

    public void setBlockBounds(float f, float f1, float f2, float f3, float f4, float f5) {
        this.minX = f;
        this.minY = f1;
        this.minZ = f2;
        this.maxX = f3;
        this.maxY = f4;
        this.maxZ = f5;
    }

    public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
        if (Minecraft.getMinecraft().fullbright) {
            return 1.0f;
        }
        if (Minecraft.isTreeShadingEnabled() && Minecraft.isAmbientOcclusionEnabled() && iblockaccess.getBlockMaterial(i, j, k) == Material.leaves) {
            float brightness = iblockaccess.getBrightness(i, j, k, lightValue[this.blockID]);
            if (brightness > 0.2f) {
                brightness = 0.2f;
            }
            return brightness;
        }
        return iblockaccess.getBrightness(i, j, k, lightValue[this.blockID]);
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l == 0 && this.minY > 0.0) {
            return true;
        }
        if (l == 1 && this.maxY < 1.0) {
            return true;
        }
        if (l == 2 && this.minZ > 0.0) {
            return true;
        }
        if (l == 3 && this.maxZ < 1.0) {
            return true;
        }
        if (l == 4 && this.minX > 0.0) {
            return true;
        }
        if (l == 5 && this.maxX < 1.0) {
            return true;
        }
        return !iblockaccess.isBlockOpaqueCube(i, j, k);
    }

    public boolean getIsBlockSolid(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return iblockaccess.getBlockMaterial(i, j, k).isSolid();
    }

    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.getBlockTextureFromSideAndMetadata(l, iblockaccess.getBlockMetadata(i, j, k));
    }

    public int getBlockOverbright(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return -1;
    }

    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        return this.atlasIndices[side];
    }

    public int getBlockTextureFromSide(int i) {
        return this.getBlockTextureFromSideAndMetadata(i, 0);
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)i + this.minX, (double)j + this.minY, (double)k + this.minZ, (double)i + this.maxX, (double)j + this.maxY, (double)k + this.maxZ);
    }

    public void getCollidingBoundingBoxes(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        AxisAlignedBB axisalignedbb1 = this.getCollisionBoundingBoxFromPool(world, i, j, k);
        if (axisalignedbb1 != null && axisalignedbb.intersectsWith(axisalignedbb1)) {
            arraylist.add(axisalignedbb1);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)i + this.minX, (double)j + this.minY, (double)k + this.minZ, (double)i + this.maxX, (double)j + this.maxY, (double)k + this.maxZ);
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public boolean blocksLight() {
        return false;
    }

    public boolean canCollideCheck(int i, boolean flag) {
        return this.isCollidable();
    }

    public boolean isCollidable() {
        return true;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
    }

    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
    }

    public int tickRate() {
        return 10;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
    }

    public void onBlockAdded(EntityPlayer entityPlayer, World world, int x, int y, int z) {
    }

    public void onBlockRemoval(World world, int x, int y, int z) {
    }

    public int quantityDropped(int metadata, Random random) {
        return 1;
    }

    public int idDropped(int i, Random random) {
        return this.dropOverride != null ? this.dropOverride.blockID : this.blockID;
    }

    public float blockStrength(EntityPlayer entityplayer) {
        if (this.blockHardness < 0.0f) {
            return 0.0f;
        }
        if (!entityplayer.canHarvestBlock(this)) {
            return 1.0f / this.blockHardness / 100.0f;
        }
        return entityplayer.getCurrentPlayerStrVsBlock(this) / this.blockHardness / 30.0f;
    }

    public boolean getImmovable() {
        return this.immovable;
    }

    public final void dropBlockAsItem(World world, int x, int y, int z, int meta) {
        this.dropBlockAsItemWithChance(world, x, y, z, meta, 1.0f);
    }

    public void dropBlockWhenCrushed(World world, int x, int y, int z, int meta) {
        world.dropItem(x, y, z, new ItemStack(this.blockID, 1, meta));
    }

    public void dropBlockAsItemWithChance(World world, int x, int y, int z, int meta, float chance) {
        if (world.isMultiplayerAndNotHost) {
            return;
        }
        int i1 = this.quantityDropped(meta, world.rand);
        for (int j1 = 0; j1 < i1; ++j1) {
            int k1;
            if (world.rand.nextFloat() > chance || (k1 = this.idDropped(meta, world.rand)) <= 0) continue;
            world.dropItem(x, y, z, new ItemStack(k1, 1, this.damageDropped(meta)));
        }
    }

    protected int damageDropped(int i) {
        return 0;
    }

    public float getExplosionResistance(Entity entity) {
        return this.blockResistance / 5.0f;
    }

    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        vec3d = vec3d.addVector(-i, -j, -k);
        vec3d1 = vec3d1.addVector(-i, -j, -k);
        Vec3D vec3d2 = vec3d.getIntermediateWithXValue(vec3d1, this.minX);
        Vec3D vec3d3 = vec3d.getIntermediateWithXValue(vec3d1, this.maxX);
        Vec3D vec3d4 = vec3d.getIntermediateWithYValue(vec3d1, this.minY);
        Vec3D vec3d5 = vec3d.getIntermediateWithYValue(vec3d1, this.maxY);
        Vec3D vec3d6 = vec3d.getIntermediateWithZValue(vec3d1, this.minZ);
        Vec3D vec3d7 = vec3d.getIntermediateWithZValue(vec3d1, this.maxZ);
        if (!this.isVecInsideYZBounds(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.isVecInsideYZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d5)) {
            vec3d5 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d6)) {
            vec3d6 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d7)) {
            vec3d7 = null;
        }
        Vec3D vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || vec3d.distanceTo(vec3d2) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || vec3d.distanceTo(vec3d3) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || vec3d.distanceTo(vec3d4) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || vec3d.distanceTo(vec3d5) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || vec3d.distanceTo(vec3d6) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || vec3d.distanceTo(vec3d7) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d8 == vec3d2) {
            byte0 = 4;
        }
        if (vec3d8 == vec3d3) {
            byte0 = 5;
        }
        if (vec3d8 == vec3d4) {
            byte0 = 0;
        }
        if (vec3d8 == vec3d5) {
            byte0 = 1;
        }
        if (vec3d8 == vec3d6) {
            byte0 = 2;
        }
        if (vec3d8 == vec3d7) {
            byte0 = 3;
        }
        return new MovingObjectPosition(i, j, k, byte0, vec3d8.addVector(i, j, k));
    }

    private boolean isVecInsideYZBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXZBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXYBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY;
    }

    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public boolean canPlaceBlockOnSide(World world, int i, int j, int k, int l) {
        return this.canPlaceBlockAt(world, i, j, k);
    }

    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        return l == 0 || Block.blocksList[l].blockMaterial.getIsGroundCover();
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return false;
    }

    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
    }

    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
    }

    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
    }

    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
    }

    public int getRenderColor(int i) {
        return 0xFFFFFF;
    }

    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        return 0xFFFFFF;
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public boolean canProvidePower() {
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return false;
    }

    public void setBlockBoundsForItemRender() {
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int x, int y, int z, int meta) {
        Item currentItem;
        entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
        if (entityplayer.getStat(StatList.mineBlockStatArray[Block.basalt.blockID]) > 0 && entityplayer.getStat(StatList.mineBlockStatArray[Block.limestone.blockID]) > 0 && entityplayer.getStat(StatList.mineBlockStatArray[Block.granite.blockID]) > 0) {
            entityplayer.triggerAchievement(AchievementList.collectStone);
        }
        Item item = currentItem = entityplayer.inventory.getCurrentItem() != null ? Item.itemsList[entityplayer.inventory.getCurrentItem().itemID] : null;
        if (currentItem != null && currentItem.isSilkTouch()) {
            this.dropBlockWhenCrushed(world, x, y, z, meta);
        } else {
            this.dropBlockAsItem(world, x, y, z, meta);
        }
    }

    public boolean canBlockStay(World world, int i, int j, int k) {
        return true;
    }

    public Block setFenceCanConnectTo() {
        this.canFenceConnectTo = true;
        return this;
    }

    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
    }

    public Block setBlockName(String s) {
        this.blockName = "tile." + s;
        nameToIdMap.put(this.blockName, this.blockID);
        return this;
    }

    public String translateBlockName(int metadata) {
        return StatStringTranslate.translateToLocal(this.getBlockName(metadata) + ".name");
    }

    public String translateBlockDesc(int metadata) {
        return StatStringTranslate.translateToLocal(this.getBlockName(metadata) + ".desc");
    }

    public String getBlockName(int metadata) {
        return this.blockName;
    }

    public void playBlock(World world, int i, int j, int k, int l, int i1) {
    }

    public boolean getEnableStats() {
        return this.enableStats;
    }

    protected Block disableStats() {
        this.enableStats = false;
        return this;
    }

    public int getMobilityFlag() {
        return this.blockMaterial.getMaterialMobility();
    }

    public static boolean isBuried(World world, int x, int y, int z) {
        boolean buried = true;
        if (lightOpacity[world.getBlockId(x + 1, y, z)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x - 1, y, z)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x, y, z + 1)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x, y, z - 1)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x, y + 1, z)] <= 2) {
            buried = false;
        }
        if (lightOpacity[world.getBlockId(x, y - 1, z)] <= 2) {
            buried = false;
        }
        return buried;
    }

    public static boolean getIsLitInteriorSurface(World world, int x, int y, int z) {
        int l = world.getBlockId(x, y, z);
        return l != 0 && Block.blocksList[l].isLitInteriorSurface;
    }

    public Block setHasOverbright() {
        this.hasOverbright = true;
        return this;
    }

    public static boolean getHasOverbright(World world, int x, int y, int z) {
        int id = world.getBlockId(x, y, z);
        return id != 0 && Block.blocksList[id].hasOverbright;
    }

    public Block setNotInCreativeMenu() {
        this.notInCreativeMenu = true;
        return this;
    }

    public Block setPlantable() {
        this.plantable = true;
        return this;
    }

    public Block setMossGrowable() {
        this.mossGrowable = true;
        return this;
    }

    public Block setPlaceOverwrites() {
        this.placeOverwrites = true;
        return this;
    }

    public static Block getBlock(int i) {
        return blocksList[i];
    }

    public static Block getBlockByName(String name) {
        Utils.requireNonNull(name);
        if (name.startsWith("tile.")) {
            name = name.substring(5);
        }
        for (int i = 0; i < blocksList.length; ++i) {
            String name2;
            Block block = blocksList[i];
            if (block == null || !name.equalsIgnoreCase(name2 = block.blockName.substring(5))) continue;
            return block;
        }
        return null;
    }

    static {
        int i;
        soundPowderFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundWoodFootstep = new StepSound("wood", 1.0f, 1.0f);
        soundGravelFootstep = new StepSound("gravel", 1.0f, 1.0f);
        soundGrassFootstep = new StepSound("grass", 1.0f, 1.0f);
        soundStoneFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundMetalFootstep = new StepSound("stone", 1.0f, 1.5f);
        soundGlassFootstep = new StepSoundStone("stone", 1.0f, 1.0f);
        soundClothFootstep = new StepSound("cloth", 1.0f, 1.0f);
        soundSandFootstep = new StepSoundSand("sand", 1.0f, 1.0f);
        blocksList = new Block[16384];
        tickOnLoad = new boolean[blocksList.length];
        opaqueCubeLookup = new boolean[blocksList.length];
        isBlockContainer = new boolean[blocksList.length];
        lightOpacity = new int[blocksList.length];
        canBlockGrass = new boolean[blocksList.length];
        lightValue = new int[blocksList.length];
        neighborNotifyOnMetadataChangeDisabled = new boolean[blocksList.length];
        nameToIdMap = new HashMap<String, Integer>();
        stone = new BlockStone(1).setBlockName("stone").setTexCoords(1, 0).setHardness(1.5f).setResistance(10.0f).setStepSound(soundStoneFootstep).setMossGrowable();
        basalt = new BlockStone(2).setBlockName("basalt").setTexCoords(6, 10).setHardness(1.5f).setResistance(10.0f).setStepSound(soundStoneFootstep).setMossGrowable();
        limestone = new BlockStone(3).setBlockName("limestone").setTexCoords(9, 10).setHardness(1.5f).setResistance(10.0f).setStepSound(soundStoneFootstep).setMossGrowable();
        granite = new BlockStone(4).setBlockName("granite").setTexCoords(9, 11).setHardness(1.5f).setResistance(10.0f).setStepSound(soundStoneFootstep).setMossGrowable();
        marble = new Block(5, Material.rock).setBlockName("marble").setTexCoords(9, 12).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        slate = new Block(6, Material.rock).setBlockName("slate").setTexCoords(8, 13, 7, 13).setHardness(1.5f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        cobbleStone = new Block(10, Material.rock).setBlockName("cobble.stone").setTexCoords(0, 1).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setMossGrowable();
        cobbleStoneMossy = new Block(11, Material.rock).setBlockName("cobble.stone.mossy").setTexCoords(4, 2).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        cobbleBasalt = new Block(12, Material.rock).setBlockName("cobble.basalt").setTexCoords(7, 10).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        cobbleLimestone = new Block(13, Material.rock).setBlockName("cobble.limestone").setTexCoords(10, 10).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        cobbleGranite = new Block(14, Material.rock).setBlockName("cobble.granite").setTexCoords(10, 11).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        pillarMarble = new Block(20, Material.rock).setBlockName("pillar.marble").setTexCoords(11, 13, 11, 13, 11, 12).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        capstoneMarble = new Block(21, Material.rock).setBlockName("capstone.marble").setTexCoords(9, 14, 9, 14, 9, 13).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        sandstone = new Block(30, Material.rock).setBlockName("sandstone").setTexCoords(0, 11, 0, 13, 0, 12).setStepSound(soundStoneFootstep).setHardness(0.8f);
        stoneCarved = new Block(40, Material.rock).setBlockName("stone.carved").setTexCoords(6, 0, 5, 0).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setNotInCreativeMenu();
        graniteCarved = new Block(41, Material.rock).setBlockName("granite.carved").setTexCoords(4, 13, 4, 14).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setNotInCreativeMenu();
        limestoneCarved = new Block(42, Material.rock).setBlockName("limestone.carved").setTexCoords(3, 13, 3, 14).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setNotInCreativeMenu();
        basaltCarved = new Block(43, Material.rock).setBlockName("basalt.carved").setTexCoords(5, 13, 5, 14).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setNotInCreativeMenu();
        planksOak = new Block(50, Material.wood).setBlockName("planks.oak").setTexCoords(4, 0).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        planksOakPainted = new BlockPlanksPainted(51).setBlockName("planks.oak.painted").setTexCoords(2, 3).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        torchCoal = new BlockTorch(60).setBlockName("torch.coal").setTexCoords(0, 5).setHardness(0.0f).setLightValue(0.9375f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange();
        ladderOak = new BlockLadder(70).setBlockName("ladder.oak").setTexCoords(3, 5).setHardness(0.4f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange();
        fencePlanksOak = new BlockFence(80).setBlockName("fence.planks.oak").setTexCoords(4, 0).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        fencePlanksOakPainted = new BlockFencePainted(81).setBlockName("fence.planks.oak.painted").setTexCoords(2, 3).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        fencegatePlanksOak = new BlockFenceGate(90).setBlockName("fencegate.planks.oak").setTexCoords(4, 0).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        fencegatePlanksOakPainted = new BlockFenceGatePainted(91).setBlockName("fencegate.planks.oak.painted").setTexCoords(2, 3).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        bookshelfPlanksOak = new Block(100, Material.wood).setBlockName("bookshelf.planks.oak").setTexCoords(4, 0, 3, 2).setHardness(1.5f).setStepSound(soundWoodFootstep).setFenceCanConnectTo();
        wool = new BlockWool(110).setBlockName("wool").setTexCoords(0, 4).setHardness(0.8f).setStepSound(soundClothFootstep).disableNeighborNotifyOnMetadataChange();
        brickClay = new Block(120, Material.rock).setBlockName("brick.clay").setTexCoords(7, 0).setHardness(3.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        brickStonePolished = new Block(121, Material.rock).setBlockName("brick.stone.polished").setTexCoords(10, 8).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setMossGrowable();
        brickStonePolishedMossy = new Block(122, Material.rock).setBlockName("brick.stone.polished.mossy").setTexCoords(11, 8).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        brickSandstone = new Block(123, Material.rock).setBlockName("brick.sandstone").setTexCoords(0, 14).setStepSound(soundStoneFootstep).setHardness(0.8f).setResistance(10.0f);
        brickGold = new Block(124, Material.rock).setBlockName("brick.gold").setTexCoords(9, 9).setHardness(3.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        brickLapis = new Block(125, Material.rock).setBlockName("brick.lapis").setTexCoords(9, 8).setHardness(3.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        brickBasalt = new Block(126, Material.rock).setBlockName("brick.basalt").setTexCoords(8, 10).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        brickLimestone = new Block(127, Material.rock).setBlockName("brick.limestone").setTexCoords(11, 10).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        brickGranite = new Block(128, Material.rock).setBlockName("brick.granite").setTexCoords(11, 11).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        brickMarble = new Block(129, Material.rock).setBlockName("brick.marble").setTexCoords(10, 13).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        brickSlate = new Block(130, Material.rock).setBlockName("brick.slate").setTexCoords(6, 13).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        brickStone = new Block(131, Material.rock).setBlockName("brick.stone").setTexCoords(12, 9).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        slabPlanksOak = new BlockSlab(140, planksOak).setBlockName("slab.planks.oak").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabCobbleStone = new BlockSlab(141, cobbleStone).setBlockName("slab.cobble.stone").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabSandstone = new BlockSlab(142, sandstone).setBlockName("slab.sandstone").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabBrickStonePolished = new BlockSlab(143, brickStonePolished).setBlockName("slab.brick.stone.polished").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabStonePolished = new BlockSlab(144, stoneCarved).setBlockName("slab.stone.polished").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabBrickMarble = new BlockSlab(145, brickMarble).setBlockName("slab.brick.marble").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabBrickClay = new BlockSlab(146, brickClay).setBlockName("slab.brick.clay").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabCapstoneMarble = new BlockSlabMarble(147, capstoneMarble).setBlockName("slab.capstone.marble").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabCobbleBasalt = new BlockSlab(148, cobbleBasalt).setBlockName("slab.cobble.basalt").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabCobbleLimestone = new BlockSlab(149, cobbleLimestone).setBlockName("slab.cobble.limestone").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabCobbleGranite = new BlockSlab(150, cobbleGranite).setBlockName("slab.cobble.granite").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabBrickBasalt = new BlockSlab(151, brickBasalt).setBlockName("slab.brick.basalt").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabBrickLimestone = new BlockSlab(152, brickLimestone).setBlockName("slab.brick.limestone").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabBrickGranite = new BlockSlab(153, brickGranite).setBlockName("slab.brick.granite").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabPlanksOakPainted = new BlockSlabPainted(154, planksOakPainted).setBlockName("slab.planks.oak.painted").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabBrickSlate = new BlockSlab(155, brickSlate).setBlockName("slab.brick.slate").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabBrickStone = new BlockSlab(156, brickStone).setBlockName("slab.brick.stone").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabGranitePolished = new BlockSlab(157, graniteCarved).setBlockName("slab.granite.polished").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabLimestonePolished = new BlockSlab(158, limestoneCarved).setBlockName("slab.limestone.polished").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        slabBasaltPolished = new BlockSlab(159, basaltCarved).setBlockName("slab.basalt.polished").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsPlanksOak = new BlockStairs(160, planksOak).setBlockName("stairs.planks.oak").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsCobbleStone = new BlockStairs(161, cobbleStone).setBlockName("stairs.cobble.stone").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsBrickStonePolished = new BlockStairs(162, brickStonePolished).setBlockName("stairs.brick.stone.polished").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsBrickMarble = new BlockStairs(163, brickMarble).setBlockName("stairs.brick.marble").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsCobbleBasalt = new BlockStairs(164, cobbleBasalt).setBlockName("stairs.cobble.basalt").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsCobbleLimestone = new BlockStairs(165, cobbleLimestone).setBlockName("stairs.cobble.limestone").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsCobbleGranite = new BlockStairs(166, cobbleGranite).setBlockName("stairs.cobble.granite").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsBrickBasalt = new BlockStairs(167, brickBasalt).setBlockName("stairs.brick.basalt").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsBrickLimestone = new BlockStairs(168, brickLimestone).setBlockName("stairs.brick.limestone").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsBrickGranite = new BlockStairs(169, brickGranite).setBlockName("stairs.brick.granite").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsBrickClay = new BlockStairs(170, brickClay).setBlockName("stairs.brick.clay").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsPlanksOakPainted = new BlockStairsPainted(171, planksOakPainted).setBlockName("stairs.planks.oak.painted").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsBrickSlate = new BlockStairs(172, brickSlate).setBlockName("stairs.brick.slate").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        stairsBrickStone = new BlockStairs(173, brickStone).setBlockName("stairs.brick.stone").disableNeighborNotifyOnMetadataChange().setIsLitInteriorSurface(true);
        obsidian = new Block(180, Material.rock).setBlockName("obsidian").setTexCoords(5, 2).setHardness(10.0f).setResistance(2000.0f).setStepSound(soundStoneFootstep);
        glass = new BlockGlass(190, Material.glass, false).setBlockName("glass").setTexCoords(1, 3).setHardness(0.3f).setStepSound(soundGlassFootstep);
        glassTinted = new BlockGlassTinted(191).setTexCoords(6, 12).setBlockName("glass.tinted").setHardness(0.5f).setStepSound(soundGlassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        grass = new BlockGrass(200, Material.grass).setBlockName("grass").setTexCoords(0, 0, 2, 0, 3, 0).setHardness(0.6f).setStepSound(soundGrassFootstep).setPlantable();
        grassRetro = new BlockGrassRetro(201, Material.grass).setBlockName("grass.retro").setTexCoords(8, 1, 2, 0, 6, 3).setHardness(0.6f).setStepSound(soundGrassFootstep).setPlantable();
        pathDirt = new BlockDirtPath(210).setBlockName("path.dirt").setTexCoords(4, 6, 2, 0, 5, 6).setHardness(0.5f).setStepSound(soundGravelFootstep).setIsLitInteriorSurface(true);
        dirt = new Block(220, Material.ground).setBlockName("dirt").setTexCoords(2, 0).setHardness(0.5f).setStepSound(soundGravelFootstep).setPlantable();
        dirtScorched = new Block(221, Material.ground).setBlockName("dirt.scorched").setTexCoords(13, 8).setHardness(0.5f).setStepSound(soundGravelFootstep).setPlantable();
        dirtScorchedRich = new Block(222, Material.ground).setBlockName("dirt.scorched.rich").setTexCoords(12, 8).setHardness(0.6f).setStepSound(soundGravelFootstep).setPlantable();
        spongeDry = new BlockSponge(230, false).setBlockName("sponge.dry").setTexCoords(0, 3).setHardness(0.6f).setStepSound(soundGrassFootstep);
        spongeWet = new BlockSponge(231, true).setBlockName("sponge.wet").setTexCoords(11, 9).setHardness(1.0f).setStepSound(soundGrassFootstep);
        mossStone = new BlockMoss(240).setBlockName("moss.stone").setTexCoords(1, 0).setHardness(1.5f).setResistance(10.0f).setStepSound(soundGrassFootstep).setPlantable();
        mossBasalt = new BlockMoss(241).setBlockName("moss.basalt").setTexCoords(6, 10).setHardness(1.5f).setResistance(10.0f).setStepSound(soundGrassFootstep).setPlantable();
        mossLimestone = new BlockMoss(242).setBlockName("moss.limestone").setTexCoords(9, 10).setHardness(1.5f).setResistance(10.0f).setStepSound(soundGrassFootstep).setPlantable();
        mossGranite = new BlockMoss(243).setBlockName("moss.granite").setTexCoords(9, 11).setHardness(1.5f).setResistance(10.0f).setStepSound(soundGrassFootstep).setPlantable();
        sand = new BlockSand(250).setBlockName("sand").setTexCoords(2, 1).setHardness(0.5f).setStepSound(soundSandFootstep);
        gravel = new BlockGravel(251).setBlockName("gravel").setTexCoords(3, 1).setHardness(0.6f).setStepSound(soundGravelFootstep);
        bedrock = new BlockBedrock(260, Material.rock).setBlockName("bedrock").setTexCoords(1, 1).setBlockUnbreakable().setResistance(6000000.0f).setStepSound(soundStoneFootstep).disableStats();
        fluidWaterFlowing = new BlockFluidFlowing(270, Material.water).setBlockName("fluid.water.flowing").setTexCoords(14, 12, 13, 12, 14, 12).setHardness(100.0f).setLightOpacity(3).disableStats().disableNeighborNotifyOnMetadataChange().setPlaceOverwrites().setNotInCreativeMenu();
        fluidWaterStill = new BlockFluidStill(271, Material.water).setBlockName("fluid.water.still").setTexCoords(13, 12, 14, 12).setHardness(100.0f).setLightOpacity(3).disableStats().disableNeighborNotifyOnMetadataChange().setPlaceOverwrites().setNotInCreativeMenu();
        fluidLavaFlowing = new BlockFluidFlowing(272, Material.lava).setBlockName("fluid.lava.flowing").setTexCoords(14, 14, 13, 14, 14, 14).setHardness(0.0f).setLightValue(1.0f).setLightOpacity(255).disableStats().disableNeighborNotifyOnMetadataChange().setPlaceOverwrites().setNotInCreativeMenu();
        fluidLavaStill = new BlockFluidStill(273, Material.lava).setBlockName("fluid.lava.still").setTexCoords(13, 14, 14, 14).setHardness(100.0f).setLightValue(1.0f).setLightOpacity(255).disableStats().disableNeighborNotifyOnMetadataChange().setPlaceOverwrites().setNotInCreativeMenu();
        logOak = new BlockLog(280).setBlockName("log.oak").setTexCoords(1, 20, 0, 20).setHardness(2.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo().setMossGrowable();
        logPine = new BlockLog(281).setBlockName("log.pine").setTexCoords(1, 23, 0, 23).setHardness(2.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        logBirch = new BlockLog(282).setBlockName("log.birch").setTexCoords(1, 24, 0, 24).setHardness(2.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        logCherry = new BlockLog(283).setBlockName("log.cherry").setTexCoords(1, 25, 0, 25).setHardness(2.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        logEucalyptus = new BlockLog(284).setBlockName("log.eucalyptus").setTexCoords(1, 26, 0, 26).setHardness(2.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        logOakMossy = new BlockLog(285).setBlockName("log.oak.mossy").setTexCoords(1, 21, 0, 21).setHardness(2.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo();
        leavesOak = new BlockLeavesOak(290).setBlockName("leaves.oak").setTexCoords(2, 20).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        leavesOakRetro = new BlockLeavesRetro(291).setBlockName("leaves.oak.retro").setTexCoords(2, 22).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        leavesPine = new BlockLeavesPine(292).setBlockName("leaves.pine").setTexCoords(2, 23).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        leavesBirch = new BlockLeavesBirch(293).setBlockName("leaves.birch").setTexCoords(2, 24).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        leavesCherry = new BlockLeavesCherry(294).setBlockName("leaves.cherry").setTexCoords(2, 25).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        leavesEucalyptus = new BlockLeavesEucalyptus(295).setBlockName("leaves.eucalyptus").setTexCoords(2, 26).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        leavesShrub = new BlockLeavesShrub(296).setBlockName("leaves.shrub").setTexCoords(2, 27).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        leavesCherryFlowering = new BlockLeavesCherryFlowering(297).setBlockName("leaves.cherry.flowering").setTexCoords(2, 25).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        saplingOak = new BlockSaplingOak(310).setBlockName("sapling.oak").setTexCoords(4, 20).setHardness(0.0f).setStepSound(soundGrassFootstep).disableNeighborNotifyOnMetadataChange();
        saplingOakRetro = new BlockSaplingRetro(311).setBlockName("sapling.oak.retro").setTexCoords(4, 20).setHardness(0.0f).setStepSound(soundGrassFootstep).disableNeighborNotifyOnMetadataChange();
        saplingPine = new BlockSaplingPine(312).setBlockName("sapling.pine").setTexCoords(4, 23).setHardness(0.0f).setStepSound(soundGrassFootstep).disableNeighborNotifyOnMetadataChange();
        saplingBirch = new BlockSaplingBirch(313).setBlockName("sapling.birch").setTexCoords(4, 24).setHardness(0.0f).setStepSound(soundGrassFootstep).disableNeighborNotifyOnMetadataChange();
        saplingCherry = new BlockSaplingCherry(314).setBlockName("sapling.cherry").setTexCoords(4, 25).setHardness(0.0f).setStepSound(soundGrassFootstep).disableNeighborNotifyOnMetadataChange();
        saplingEucalyptus = new BlockSaplingEucalyptus(315).setBlockName("sapling.eucalyptus").setTexCoords(4, 26).setHardness(0.0f).setStepSound(soundGrassFootstep).disableNeighborNotifyOnMetadataChange();
        saplingShrub = new BlockSaplingShrub(316).setBlockName("sapling.shrub").setTexCoords(4, 27).setHardness(0.0f).setStepSound(soundGrassFootstep).disableNeighborNotifyOnMetadataChange();
        tallgrass = new BlockTallGrass(320).setKilledByWeather().setBlockName("tallgrass").setTexCoords(7, 2).setHardness(0.0f).setStepSound(soundGrassFootstep).setPlaceOverwrites();
        tallgrassFern = new BlockTallGrass(321).setKilledByWeather().setBlockName("tallgrass.fern").setTexCoords(8, 3).setHardness(0.0f).setStepSound(soundGrassFootstep).setPlaceOverwrites();
        deadbush = new BlockDeadBush(322).setBlockName("deadbush").setTexCoords(7, 3).setHardness(0.0f).setStepSound(soundGrassFootstep).setPlaceOverwrites();
        spinifex = new BlockSpinifex(323).setBlockName("spinifex").setTexCoords(12, 10).setHardness(0.0f).setStepSound(soundGrassFootstep).setPlaceOverwrites();
        algae = new BlockAlgae(324, Material.grass).setBlockName("algae").setTexCoords(6, 1).setHardness(0.0f).setStepSound(soundGrassFootstep).setPlaceOverwrites().setIsLitInteriorSurface(true);
        flowerYellow = new BlockFlower(330).setKilledByWeather().setBlockName("flower.yellow").setTexCoords(13, 0).setHardness(0.0f).setStepSound(soundGrassFootstep);
        flowerRed = new BlockFlower(331).setKilledByWeather().setBlockName("flower.red").setTexCoords(12, 0).setHardness(0.0f).setStepSound(soundGrassFootstep);
        mushroomBrown = new BlockMushroom(340).setBlockName("mushroom.brown").setTexCoords(13, 1).setHardness(0.0f).setStepSound(soundGrassFootstep).setLightValue(0.125f);
        mushroomRed = new BlockMushroom(341).setBlockName("mushroom.red").setTexCoords(12, 1).setHardness(0.0f).setStepSound(soundGrassFootstep);
        oreCoalStone = new BlockOreCoal(350).setBlockName("ore.coal.stone").setTexCoords(18, 0).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreCoalBasalt = new BlockOreCoal(351).setBlockName("ore.coal.basalt").setTexCoords(18, 1).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreCoalLimestone = new BlockOreCoal(352).setBlockName("ore.coal.limestone").setTexCoords(18, 2).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreCoalGranite = new BlockOreCoal(353).setBlockName("ore.coal.granite").setTexCoords(18, 3).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreIronStone = new Block(360, Material.rock).setBlockName("ore.iron.stone").setTexCoords(17, 0).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreIronBasalt = new Block(361, Material.rock).setBlockName("ore.iron.basalt").setTexCoords(17, 1).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setDropOverride(oreIronStone);
        oreIronLimestone = new Block(362, Material.rock).setBlockName("ore.iron.limestone").setTexCoords(17, 2).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setDropOverride(oreIronStone);
        oreIronGranite = new Block(363, Material.rock).setBlockName("ore.iron.granite").setTexCoords(17, 3).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setDropOverride(oreIronStone);
        oreGoldStone = new Block(370, Material.rock).setBlockName("ore.gold.stone").setTexCoords(16, 0).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreGoldBasalt = new Block(371, Material.rock).setBlockName("ore.gold.basalt").setTexCoords(16, 1).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setDropOverride(oreGoldStone);
        oreGoldLimestone = new Block(372, Material.rock).setBlockName("ore.gold.limestone").setTexCoords(16, 2).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setDropOverride(oreGoldStone);
        oreGoldGranite = new Block(373, Material.rock).setBlockName("ore.gold.granite").setTexCoords(16, 3).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setDropOverride(oreGoldStone);
        oreLapisStone = new BlockOreLapis(380).setBlockName("ore.lapis.stone").setTexCoords(19, 0).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreLapisBasalt = new BlockOreLapis(381).setBlockName("ore.lapis.basalt").setTexCoords(19, 1).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreLapisLimestone = new BlockOreLapis(382).setBlockName("ore.lapis.limestone").setTexCoords(19, 2).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreLapisGranite = new BlockOreLapis(383).setBlockName("ore.lapis.granite").setTexCoords(19, 3).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreRedstoneStone = new BlockOreRedstone(390, false).setBlockName("ore.redstone.stone").setTexCoords(21, 0).setHardness(3.0f).setResistance(2.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        oreRedstoneBasalt = new BlockOreRedstone(391, false).setBlockName("ore.redstone.basalt").setTexCoords(21, 1).setHardness(3.0f).setResistance(2.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        oreRedstoneLimestone = new BlockOreRedstone(392, false).setBlockName("ore.redstone.limestone").setTexCoords(21, 2).setHardness(3.0f).setResistance(2.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        oreRedstoneGranite = new BlockOreRedstone(393, false).setBlockName("ore.redstone.granite").setTexCoords(21, 3).setHardness(3.0f).setResistance(2.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        oreRedstoneGlowingStone = new BlockOreRedstone(400, true).setBlockName("ore.redstone.glowing.stone").setTexCoords(21, 0).setHasOverbright().setLightValue(0.2f).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        oreRedstoneGlowingBasalt = new BlockOreRedstone(401, true).setBlockName("ore.redstone.glowing.basalt").setTexCoords(21, 1).setHasOverbright().setLightValue(0.2f).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        oreRedstoneGlowingLimestone = new BlockOreRedstone(402, true).setBlockName("ore.redstone.glowing.limestone").setTexCoords(21, 2).setHasOverbright().setLightValue(0.2f).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        oreRedstoneGlowingGranite = new BlockOreRedstone(403, true).setBlockName("ore.redstone.glowing.granite").setTexCoords(21, 3).setHasOverbright().setLightValue(0.2f).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        oreDiamondStone = new BlockOreDiamond(410).setBlockName("ore.diamond.stone").setTexCoords(20, 0).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreDiamondBasalt = new BlockOreDiamond(411).setBlockName("ore.diamond.basalt").setTexCoords(20, 1).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreDiamondLimestone = new BlockOreDiamond(412).setBlockName("ore.diamond.limestone").setTexCoords(20, 2).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreDiamondGranite = new BlockOreDiamond(413).setBlockName("ore.diamond.granite").setTexCoords(20, 3).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreNethercoalNetherrack = new BlockOreNetherCoal(420).setBlockName("ore.nethercoal.netherrack").setTexCoords(10, 9).setHasOverbright().setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setLightValue(0.625f);
        blockCoal = new Block(430, Material.rock).setBlockName("block.coal").setTexCoords(16, 7).setHardness(3.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        blockIron = new Block(431, Material.iron).setBlockName("block.iron").setTexCoords(16, 4, 16, 6, 16, 5).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        blockGold = new Block(432, Material.iron).setBlockName("block.gold").setTexCoords(17, 4, 17, 6, 17, 5).setHardness(3.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        blockLapis = new Block(433, Material.rock).setBlockName("block.lapis").setTexCoords(0, 9).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        blockRedstone = new BlockRedstone(434, Material.rock).setBlockName("block.redstone").setTexCoords(0, 10).setHardness(5.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        blockDiamond = new Block(435, Material.rock).setBlockName("block.diamond").setTexCoords(18, 4, 18, 6, 18, 5).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        blockNetherCoal = new BlockNetherCoal(436).setBlockName("block.nethercoal").setTexCoords(17, 7).setHardness(3.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setHasOverbright();
        blockSteel = new Block(437, Material.iron).setBlockName("block.steel").setTexCoords(19, 4, 19, 6, 19, 5).setHardness(5.0f).setResistance(2000.0f).setStepSound(soundMetalFootstep);
        blockQuartz = new Block(438, Material.rock).setBlockName("block.quartz").setTexCoords(12, 12).setHardness(3.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setHasOverbright();
        blockOlivine = new Block(439, Material.rock).setBlockName("block.olivine").setTexCoords(12, 11).setHardness(3.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        blockCharcoal = new Block(440, Material.rock).setBlockName("block.charcoal").setTexCoords(15, 7).setHardness(3.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        wireRedstone = new BlockRedstoneWire(450).setBlockName("wire.redstone").setTexCoords(4, 10).setHardness(0.0f).setStepSound(soundPowderFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        torchRedstoneIdle = new BlockRedstoneTorch(460, false).setBlockName("torch.redstone.idle").setTexCoords(3, 7).setHardness(0.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        torchRedstoneActive = new BlockRedstoneTorch(461, true).setBlockName("torch.redstone.active").setTexCoords(3, 6).setHardness(0.0f).setLightValue(0.5f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange();
        buttonStone = new BlockButton(470).setBlockName("button.stone").setTexCoords(1, 0).setHardness(0.5f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        leverCobbleStone = new BlockLever(480).setBlockName("lever.cobble.stone").setTexCoords(0, 6).setHardness(0.5f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        pressureplateStone = new BlockPressurePlate(490, EnumMobType.mobs, Material.rock).setBlockName("pressureplate.stone").setTexCoords(1, 0).setHardness(0.5f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        pressureplatePlanksOak = new BlockPressurePlate(491, EnumMobType.everything, Material.wood).setBlockName("pressureplate.planks.oak").setTexCoords(4, 0).setHardness(0.5f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange();
        pressureplateCobbleStone = new BlockPressurePlate(492, EnumMobType.players, Material.rock).setBlockName("pressureplate.cobble.stone").setTexCoords(0, 1).setHardness(0.5f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        motionsensorIdle = new BlockSensor(500, false).setBlockName("motionsensor.idle").setTexCoords(10, 12, 10, 12, 7, 12, 10, 12, 10, 12, 10, 12).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setImmovable();
        motionsensorActive = new BlockSensor(501, true).setBlockName("motionsensor.active").setTexCoords(10, 12, 10, 12, 8, 12, 10, 12, 10, 12, 10, 12).setHasOverbright().setLightValue(0.3f).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setNotInCreativeMenu().setImmovable();
        repeaterIdle = new BlockRedstoneRepeater(510, false).setBlockName("repeater.idle").setHardness(0.0f).setStepSound(soundWoodFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        repeaterActive = new BlockRedstoneRepeater(511, true).setBlockName("repeater.active").setHardness(0.0f).setLightValue(0.625f).setStepSound(soundWoodFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        pistonBase = new BlockPistonBase(520, false).setBlockName("piston.base").setTexCoords(11, 6).disableNeighborNotifyOnMetadataChange();
        pistonBaseSticky = new BlockPistonBase(521, true).setBlockName("piston.base.sticky").setTexCoords(10, 6).disableNeighborNotifyOnMetadataChange();
        pistonHead = new BlockPistonHead(522).setBlockName("piston.head").setTexCoords(11, 6).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        pistonMoving = new BlockPistonMoving(523).setBlockName("piston.moving").setNotInCreativeMenu();
        noteblock = new BlockNote(530).setBlockName("noteblock").setTexCoords(10, 4).setHardness(0.8f).disableNeighborNotifyOnMetadataChange().setStepSound(soundWoodFootstep);
        rail = new BlockRail(540, false).setBlockName("rail").setHardness(0.7f).setStepSound(soundMetalFootstep).disableNeighborNotifyOnMetadataChange();
        railPowered = new BlockRail(541, true).setBlockName("rail.powered").setHardness(0.7f).setHasOverbright().setStepSound(soundMetalFootstep).disableNeighborNotifyOnMetadataChange();
        railDetector = new BlockDetectorRail(542).setBlockName("rail.detector").setTexCoords(3, 12).setHardness(0.7f).setStepSound(soundMetalFootstep).disableNeighborNotifyOnMetadataChange();
        spikes = new BlockSpikes(550, Material.iron).setBlockName("spikes").setTexCoords(7, 11, 14, 3, 6, 11).setLightOpacity(3).setHardness(2.0f).disableNeighborNotifyOnMetadataChange();
        dispenserCobbleStone = new BlockDispenser(560).setBlockName("dispenser.cobble.stone").setTexCoords(14, 3, 14, 3, 14, 2, 13, 2, 13, 2, 13, 2).setHardness(3.5f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setImmovable();
        trapdoorPlanksOak = new BlockTrapDoor(570, Material.wood).setBlockName("trapdoor.planks.oak").setTexCoords(4, 5).setHardness(3.0f).setStepSound(soundWoodFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        trapdoorIron = new BlockTrapDoor(571, Material.iron).setBlockName("trapdoor.iron").setTexCoords(4, 7).setHardness(5.0f).setStepSound(soundMetalFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        tnt = new BlockTNT(580).setBlockName("tnt").setTexCoords(9, 0, 10, 0, 8, 0).setHardness(0.0f).setStepSound(soundGrassFootstep);
        doorPlanksOakBottom = new BlockDoor(590, false, Material.wood).setBlockName("door.planks.oak.bottom").setTexCoords(1, 6).setHardness(3.0f).setStepSound(soundWoodFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        doorPlanksOakTop = new BlockDoor(591, true, Material.wood).setBlockName("door.planks.oak.top").setTexCoords(1, 5).setHardness(3.0f).setStepSound(soundWoodFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        doorIronBottom = new BlockDoor(592, false, Material.iron).setBlockName("door.iron.bottom").setTexCoords(2, 6).setHardness(5.0f).setStepSound(soundMetalFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        doorIronTop = new BlockDoor(593, true, Material.iron).setBlockName("door.iron.top").setTexCoords(2, 5).setHardness(5.0f).setStepSound(soundMetalFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        mesh = new BlockMesh(600).setBlockName("mesh").setTexCoords(8, 11).setHardness(1.5f).setStepSound(soundStoneFootstep);
        bed = new BlockBed(610).setBlockName("bed").setHardness(0.2f).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu().setStepSound(soundWoodFootstep);
        cobweb = new BlockWeb(620, Material.web).setBlockName("cobweb").setTexCoords(11, 0).setLightOpacity(1).setHardness(4.0f);
        fire = new BlockFire(630).setBlockName("fire").setTexCoords(15, 1).setHardness(0.0f).setLightValue(1.0f).setStepSound(soundWoodFootstep).setPlaceOverwrites().disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        mobspawner = new BlockMobSpawner(640).setBlockName("mobspawner").setTexCoords(1, 4).setHardness(5.0f).setStepSound(soundMetalFootstep).disableStats();
        workbench = new BlockWorkbench(650).setBlockName("workbench").setTexCoords(11, 2, 4, 0, 11, 3, 12, 3, 11, 3, 12, 3).setHardness(2.5f).setStepSound(soundWoodFootstep).setFenceCanConnectTo();
        furnaceStoneIdle = new BlockFurnace(660, false).setBlockName("furnace.stone.idle").setTexCoords(14, 3, 14, 3, 12, 2, 13, 2, 13, 2, 13, 2).setHardness(3.5f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setImmovable();
        furnaceStoneActive = new BlockFurnace(661, true).setBlockName("furnace.stone.active").setTexCoords(14, 3, 14, 3, 13, 3, 13, 2, 13, 2, 13, 2).setHardness(3.5f).setStepSound(soundStoneFootstep).setLightValue(0.875f).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu().setImmovable();
        furnaceBlastIdle = new BlockBlastFurnace(662, false).setBlockName("furnace.blast.idle").setTexCoords(15, 8, 14, 9, 13, 7, 14, 7, 14, 7, 14, 7).setHardness(3.5f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setImmovable();
        furnaceBlastActive = new BlockBlastFurnace(663, true).setBlockName("furnace.blast.active").setTexCoords(15, 8, 14, 9, 14, 8, 14, 7, 14, 7, 14, 7).setHardness(3.5f).setStepSound(soundStoneFootstep).setLightValue(0.875f).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu().setImmovable();
        trommelIdle = new BlockTrommel(670, Material.rock, false).setBlockName("trommel.idle").setTexCoords(1, 10, 1, 10, 2, 10, 2, 8, 2, 10, 1, 8).setHardness(3.5f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setImmovable();
        trommelActive = new BlockTrommel(671, Material.rock, true).setBlockName("trommel.active").setTexCoords(1, 10, 1, 10, 2, 7, 2, 8, 1, 7, 1, 11).setHardness(3.5f).setLightValue(0.875f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu().setImmovable();
        chestPlanksOak = new BlockChest(680).setBlockName("chest.planks.oak").setTexCoords(9, 1, 9, 1, 11, 1, 10, 1, 10, 1, 10, 1).setHardness(2.5f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo().setImmovable();
        chestPlanksOakPainted = new BlockChestPainted(681).setBlockName("chest.planks.oak.painted").setHardness(2.5f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange().setFenceCanConnectTo().setImmovable();
        cropsWheat = new BlockCrops(690).setBlockName("crops.wheat").setHardness(0.0f).setStepSound(soundGrassFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        farmlandDirt = new BlockFarmland(700).setBlockName("farmland.dirt").setTexCoords(2, 0).setHardness(0.6f).setStepSound(soundGravelFootstep).setBlockName("farmland.dirt").setIsLitInteriorSurface(true);
        signPostPlanksOak = new BlockSign(710, TileEntitySign.class, true).setBlockName("sign.post.planks.oak").setTexCoords(4, 0).setHardness(1.0f).setStepSound(soundWoodFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        signWallPlanksOak = new BlockSign(711, TileEntitySign.class, false).setBlockName("sign.wall.planks.oak").setTexCoords(4, 0).setHardness(1.0f).setStepSound(soundWoodFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        layerSnow = new BlockLayerSnow(720, Material.snow).setBlockName("layer.snow").setTexCoords(2, 4).setHardness(0.1f).setStepSound(soundClothFootstep).setPlaceOverwrites().setIsLitInteriorSurface(true);
        layerLeavesOak = new BlockLayerLeaves(721, Material.leaves).setBlockName("layer.leaves.oak").setTexCoords(2, 20).setStepSound(soundGrassFootstep).setPlaceOverwrites().setIsLitInteriorSurface(true);
        layerSlate = new BlockLayerSlate(722, Material.rock).setBlockName("layer.slate").setTexCoords(8, 13, 7, 13).setHardness(1.5f).setResistance(10.0f).setStepSound(soundMetalFootstep).setIsLitInteriorSurface(true);
        ice = new BlockIce(730).setBlockName("ice").setTexCoords(3, 4).setHardness(0.5f).setLightOpacity(3).setStepSound(soundGlassFootstep);
        blockSnow = new BlockSnow(740).setBlockName("block.snow").setTexCoords(2, 4).setHardness(0.2f).setStepSound(soundClothFootstep);
        cactus = new BlockCactus(750).setBlockName("cactus").setTexCoords(5, 4, 7, 4, 6, 4).setHardness(0.4f).setStepSound(soundClothFootstep);
        blockClay = new BlockClay(760).setBlockName("block.clay").setTexCoords(8, 4).setHardness(0.6f).setStepSound(soundGravelFootstep);
        sugarcane = new BlockSugarcane(770).setBlockName("sugarcane").setTexCoords(9, 4).setHardness(0.0f).setStepSound(soundGrassFootstep).disableStats().setNotInCreativeMenu();
        jukebox = new BlockJukeBox(780).setBlockName("jukebox").setTexCoords(11, 4, 10, 4, 10, 4).setHardness(2.0f).setResistance(10.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange();
        pumpkin = new BlockPumpkin(790).setBlockName("pumpkin").setTexCoords(6, 6, 5, 5, 6, 7).setHardness(1.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange();
        pumpkinCarvedIdle = new BlockPumpkin(791).setBlockName("pumpkin.carved.idle").setTexCoords(6, 6, 5, 5, 7, 7, 6, 7, 6, 7, 6, 7).setHardness(1.0f).setStepSound(soundWoodFootstep).disableNeighborNotifyOnMetadataChange();
        pumpkinCarvedActive = new BlockPumpkin(792).setBlockName("pumpkin.carved.active").setTexCoords(6, 6, 5, 5, 8, 7, 6, 7, 6, 7, 6, 7).setHardness(1.0f).setStepSound(soundWoodFootstep).setLightValue(1.0f).disableNeighborNotifyOnMetadataChange();
        netherrack = new Block(800, Material.rock).setBlockName("netherrack").setTexCoords(7, 6).setHardness(0.4f).setStepSound(soundStoneFootstep);
        netherrackIgneous = new BlockIgneousNetherrack(801, Material.rock).setBlockName("netherrack.igneous").setTexCoords(12, 4).setHasOverbright().setHardness(1.25f).setResistance(7.0f).setLightValue(10).setStepSound(soundStoneFootstep);
        soulsand = new BlockSoulSand(810).setBlockName("soulsand").setTexCoords(8, 6).setHardness(0.5f).setStepSound(soundSandFootstep);
        glowstone = new BlockGlowStone(820, Material.rock).setBlockName("glowstone").setTexCoords(9, 6).setHardness(0.3f).setStepSound(soundGlassFootstep).setLightValue(1.0f);
        portalNether = new BlockPortal(830, 1, Block.obsidian.blockID, Block.fire.blockID).setBlockName("portal.nether").setTexCoords(14, 0).setHardness(-1.0f).setStepSound(soundGlassFootstep).setLightValue(0.75f).setNotInCreativeMenu();
        portalParadise = new BlockPortal(831, 2, Block.glowstone.blockID, Block.bedrock.blockID).setBlockName("portal.paradise").setTexCoords(14, 0).setHardness(-1.0f).setStepSound(soundGlassFootstep).setLightValue(0.75f).setNotInCreativeMenu();
        cake = new BlockCake(840).setBlockName("cake").setTexCoords(9, 7, 12, 7, 10, 7).setHardness(0.5f).setStepSound(soundClothFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        lampIdle = new BlockLamp(850, false).setBlockName("lamp.idle").setTexCoords(4, 12).setHardness(0.5f).setStepSound(soundGlassFootstep).disableStats().disableNeighborNotifyOnMetadataChange();
        lampActive = new BlockLamp(851, true).setBlockName("lamp.active").setLightValue(0.9375f).setTexCoords(5, 12).setHardness(0.5f).setStepSound(soundGlassFootstep).disableStats().disableNeighborNotifyOnMetadataChange().setNotInCreativeMenu();
        stonePolished = new Block(860, Material.rock).setBlockName("stone.polished").setTexCoords(6, 0, 5, 1).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        granitePolished = new Block(861, Material.rock).setBlockName("granite.polished").setTexCoords(4, 13, 2, 13).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        limestonePolished = new Block(862, Material.rock).setBlockName("limestone.polished").setTexCoords(3, 13, 2, 12).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        basaltPolished = new Block(863, Material.rock).setBlockName("basalt.polished").setTexCoords(5, 13, 2, 14).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        slatePolished = new Block(864, Material.rock).setBlockName("slate.polished").setTexCoords(8, 14, 7, 14).setHardness(1.0f).setStepSound(soundStoneFootstep).disableNeighborNotifyOnMetadataChange();
        stone.setDropOverride(cobbleStone);
        basalt.setDropOverride(cobbleBasalt);
        limestone.setDropOverride(cobbleLimestone);
        granite.setDropOverride(cobbleGranite);
        BlockMoss.initMossMap();
        ((BlockLayerBase)layerSnow).setFullBlockID(Block.blockSnow.blockID);
        ((BlockLayerBase)layerLeavesOak).setFullBlockID(Block.leavesOak.blockID);
        ((BlockLayerBase)layerSlate).setFullBlockID(Block.slate.blockID);
        Item.itemsList[Block.wool.blockID] = new ItemBlockPainted(Block.wool.blockID - blocksList.length, false);
        Item.itemsList[Block.pistonBase.blockID] = new ItemBlockPiston(Block.pistonBase.blockID - blocksList.length);
        Item.itemsList[Block.pistonBaseSticky.blockID] = new ItemBlockPiston(Block.pistonBaseSticky.blockID - blocksList.length);
        Item.itemsList[Block.planksOakPainted.blockID] = new ItemBlockPainted(Block.planksOakPainted.blockID - blocksList.length, false);
        Item.itemsList[Block.chestPlanksOakPainted.blockID] = new ItemBlockPainted(Block.chestPlanksOakPainted.blockID - blocksList.length, true);
        Item.itemsList[Block.fencePlanksOakPainted.blockID] = new ItemBlockPainted(Block.fencePlanksOakPainted.blockID - blocksList.length, false);
        Item.itemsList[Block.fencegatePlanksOakPainted.blockID] = new ItemBlockPainted(Block.fencegatePlanksOakPainted.blockID - blocksList.length, true);
        Item.itemsList[Block.lampIdle.blockID] = new ItemBlockLamp(Block.lampIdle.blockID - blocksList.length);
        Item.itemsList[Block.algae.blockID] = new ItemBlockAlgae(Block.algae.blockID - blocksList.length);
        for (i = 140; i < 160; ++i) {
            if (blocksList[i] == null || i == Block.slabPlanksOakPainted.blockID) continue;
            Item.itemsList[i] = new ItemBlockSlab(i - blocksList.length);
        }
        Item.itemsList[Block.slabPlanksOakPainted.blockID] = new ItemBlockSlabPainted(Block.slabPlanksOakPainted.blockID - blocksList.length);
        Item.itemsList[Block.stairsPlanksOakPainted.blockID] = new ItemBlockStairsPainted(Block.stairsPlanksOakPainted.blockID - blocksList.length);
        for (i = 720; i < 730; ++i) {
            if (blocksList[i] == null) continue;
            Item.itemsList[i] = new ItemBlockLayer(i - blocksList.length);
        }
        for (i = 0; i < blocksList.length; ++i) {
            if (blocksList[i] == null || Item.itemsList[i] != null) continue;
            Item.itemsList[i] = new ItemBlock(i - blocksList.length);
            blocksList[i].initializeBlock();
        }
        Block.canBlockGrass[0] = true;
        StatList.onBlockInit();
    }
}

