/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFurnace;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityBlastFurnace;
import net.minecraft.src.World;

public class BlockBlastFurnace
extends BlockFurnace {
    public BlockBlastFurnace(int i, boolean flag) {
        super(i, flag);
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.furnaceBlastIdle.blockID;
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (world.isMultiplayerAndNotHost) {
            return true;
        }
        TileEntityBlastFurnace tileentityblastfurnace = (TileEntityBlastFurnace)world.getBlockTileEntity(i, j, k);
        entityplayer.displayGUIFurnace(tileentityblastfurnace);
        return true;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (!this.isActive) {
            return;
        }
        int l = world.getBlockMetadata(i, j, k);
        float f = (float)i + 0.5f;
        float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)k + 0.5f;
        float f3 = 0.52f;
        float f4 = random.nextFloat() * 0.6f - 0.3f;
        if (l == 4) {
            world.spawnParticle("smoke", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("largeSmoke", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (l == 5) {
            world.spawnParticle("smoke", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            world.spawnParticle("largeSmoke", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (l == 2) {
            world.spawnParticle("smoke", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
            world.spawnParticle("largeSmoke", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
        } else if (l == 3) {
            world.spawnParticle("smoke", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
            world.spawnParticle("largeSmoke", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
        }
    }

    public static void updateFurnaceBlockState(boolean flag, World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        TileEntity tileentity = world.getBlockTileEntity(i, j, k);
        keepFurnaceInventory = true;
        if (flag) {
            world.setBlockWithNotify(i, j, k, Block.furnaceBlastActive.blockID);
        } else {
            world.setBlockWithNotify(i, j, k, Block.furnaceBlastIdle.blockID);
        }
        keepFurnaceInventory = false;
        world.setBlockMetadataWithNotify(i, j, k, l);
        tileentity.validate();
        world.setBlockTileEntity(i, j, k, tileentity);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityBlastFurnace();
    }
}

