/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.EntityItem;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class BlockCrops
extends BlockFlower {
    public final int[] growthStageTextures = new int[]{BlockCrops.texCoordToIndex(8, 5), BlockCrops.texCoordToIndex(9, 5), BlockCrops.texCoordToIndex(10, 5), BlockCrops.texCoordToIndex(11, 5), BlockCrops.texCoordToIndex(12, 5), BlockCrops.texCoordToIndex(13, 5), BlockCrops.texCoordToIndex(14, 5), BlockCrops.texCoordToIndex(15, 5)};

    public BlockCrops(int i) {
        super(i);
        this.setTickOnLoad(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
    }

    @Override
    public boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Block.farmlandDirt.blockID;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        float f;
        int l;
        super.updateTick(world, i, j, k, random);
        if (world.getBlockLightValue(i, j + 1, k) >= 9 && (l = world.getBlockMetadata(i, j, k)) < 7 && random.nextInt((int)(100.0f / (f = this.getGrowthRate(world, i, j, k)))) == 0) {
            world.setBlockMetadataWithNotify(i, j, k, ++l);
        }
    }

    public void fertilize(World world, int i, int j, int k) {
        world.setBlockMetadataWithNotify(i, j, k, 7);
    }

    private float getGrowthRate(World world, int i, int j, int k) {
        float f = 1.0f;
        int l = world.getBlockId(i, j, k - 1);
        int i1 = world.getBlockId(i, j, k + 1);
        int j1 = world.getBlockId(i - 1, j, k);
        int k1 = world.getBlockId(i + 1, j, k);
        int l1 = world.getBlockId(i - 1, j, k - 1);
        int i2 = world.getBlockId(i + 1, j, k - 1);
        int j2 = world.getBlockId(i + 1, j, k + 1);
        int k2 = world.getBlockId(i - 1, j, k + 1);
        boolean flag = j1 == this.blockID || k1 == this.blockID;
        boolean flag1 = l == this.blockID || i1 == this.blockID;
        boolean flag2 = l1 == this.blockID || i2 == this.blockID || j2 == this.blockID || k2 == this.blockID;
        for (int l2 = i - 1; l2 <= i + 1; ++l2) {
            for (int i3 = k - 1; i3 <= k + 1; ++i3) {
                int j3 = world.getBlockId(l2, j - 1, i3);
                float f1 = 0.0f;
                if (j3 == Block.farmlandDirt.blockID) {
                    f1 = 1.0f;
                    if (world.getBlockMetadata(l2, j - 1, i3) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (l2 != i || i3 != k) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        if (world.getCurrentSeason() != null) {
            f *= world.getCurrentSeason().cropGrowthFactor;
        }
        return f;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (j < 0 || j > 7) {
            j = 7;
        }
        return this.growthStageTextures[j];
    }

    @Override
    public int getRenderType() {
        return 6;
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        super.dropBlockAsItemWithChance(world, i, j, k, l, f);
        if (world.isMultiplayerAndNotHost || l != 7) {
            return;
        }
        int amount = world.rand.nextInt(3) + 1;
        for (int i1 = 0; i1 < amount; ++i1) {
            float f1 = 0.7f;
            float f2 = world.rand.nextFloat() * f1 + (1.0f - f1) * 0.5f;
            float f3 = world.rand.nextFloat() * f1 + (1.0f - f1) * 0.5f;
            float f4 = world.rand.nextFloat() * f1 + (1.0f - f1) * 0.5f;
            EntityItem entityitem = new EntityItem(world, (float)i + f2, (float)j + f3, (float)k + f4, new ItemStack(Item.seedsWheat));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        if (i == 7) {
            return Item.wheat.itemID;
        }
        return Item.seedsWheat.itemID;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 1;
    }
}

