/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockDirtPath
extends Block {
    public BlockDirtPath(int i) {
        super(i, Material.ground);
        this.setTickOnLoad(true);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.setLightOpacity(255);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool(i + 0, j + 0, k + 0, i + 1, j + 1, k + 1);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        super.onNeighborBlockChange(world, i, j, k, l);
        Material material = world.getBlockMaterial(i, j + 1, k);
        int id = world.getBlockId(i, j + 1, k);
        if (material.isSolid() && id != Block.fencegatePlanksOak.blockID && id != Block.fencegatePlanksOakPainted.blockID && id != Block.signWallPlanksOak.blockID) {
            world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.dirt.idDropped(0, random);
    }
}

