/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockMoss;
import net.minecraft.src.BlockPortal;
import net.minecraft.src.BlockTNT;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockFire
extends Block {
    private int[] chanceToEncourageFire = new int[Block.blocksList.length];
    private int[] abilityToCatchFire = new int[Block.blocksList.length];

    public BlockFire(int i) {
        super(i, Material.fire);
        this.setTickOnLoad(true);
    }

    @Override
    public void initializeBlock() {
        this.setBurnRate(Block.planksOak.blockID, 5, 20);
        this.setBurnRate(Block.planksOakPainted.blockID, 5, 20);
        this.setBurnRate(Block.fencePlanksOak.blockID, 5, 20);
        this.setBurnRate(Block.fencePlanksOakPainted.blockID, 5, 20);
        this.setBurnRate(Block.slabPlanksOak.blockID, 5, 20);
        this.setBurnRate(Block.slabPlanksOakPainted.blockID, 5, 20);
        this.setBurnRate(Block.stairsPlanksOak.blockID, 5, 20);
        this.setBurnRate(Block.logOak.blockID, 5, 5);
        this.setBurnRate(Block.logPine.blockID, 5, 5);
        this.setBurnRate(Block.logBirch.blockID, 5, 5);
        this.setBurnRate(Block.logCherry.blockID, 5, 5);
        this.setBurnRate(Block.logOakMossy.blockID, 5, 5);
        this.setBurnRate(Block.logEucalyptus.blockID, 5, 5);
        this.setBurnRate(Block.leavesOak.blockID, 30, 60);
        this.setBurnRate(Block.leavesPine.blockID, 30, 60);
        this.setBurnRate(Block.leavesBirch.blockID, 30, 60);
        this.setBurnRate(Block.leavesCherry.blockID, 30, 60);
        this.setBurnRate(Block.leavesCherryFlowering.blockID, 30, 60);
        this.setBurnRate(Block.leavesOakRetro.blockID, 30, 60);
        this.setBurnRate(Block.leavesShrub.blockID, 30, 60);
        this.setBurnRate(Block.leavesEucalyptus.blockID, 30, 60);
        this.setBurnRate(Block.bookshelfPlanksOak.blockID, 30, 20);
        this.setBurnRate(Block.tnt.blockID, 15, 100);
        this.setBurnRate(Block.wool.blockID, 30, 60);
        this.setBurnRate(Block.mossStone.blockID, 100, 30);
        this.setBurnRate(Block.mossBasalt.blockID, 100, 30);
        this.setBurnRate(Block.mossLimestone.blockID, 100, 30);
        this.setBurnRate(Block.mossGranite.blockID, 100, 30);
    }

    private void setBurnRate(int id, int chanceToEncourageFire, int abilityToCatchFire) {
        this.chanceToEncourageFire[id] = chanceToEncourageFire;
        this.abilityToCatchFire[id] = abilityToCatchFire;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 3;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public int tickRate() {
        return 40;
    }

    public void setBurnResult(World world, int x, int y, int z) {
        world.setBlockWithNotify(x, y, z, this.getBurnResultId(world, x, y, z));
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random random) {
        boolean infiniBurn;
        boolean bl = infiniBurn = world.getBlockId(x, y - 1, z) == Block.netherrack.blockID;
        if (!this.canFirePersist(world, x, y, z)) {
            this.setBurnResult(world, x, y, z);
        }
        if (!infiniBurn && world.currentWeather != null && world.currentWeather.isPrecipitation && (world.canBlockBeRainedOn(x, y, z) || world.canBlockBeRainedOn(x - 1, y, z) || world.canBlockBeRainedOn(x + 1, y, z) || world.canBlockBeRainedOn(x, y, z - 1) || world.canBlockBeRainedOn(x, y, z + 1))) {
            this.setBurnResult(world, x, y, z);
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (meta < 15) {
            world.setBlockMetadata(x, y, z, meta + random.nextInt(3) / 2);
        }
        world.scheduleBlockUpdate(x, y, z, this.blockID, this.tickRate());
        if (!infiniBurn && !this.canNeighborCatchFire(world, x, y, z)) {
            if (!world.isBlockNormalCube(x, y - 1, z) || meta > 3) {
                this.setBurnResult(world, x, y, z);
            }
            return;
        }
        if (!infiniBurn && !this.canBlockCatchFire(world, x, y - 1, z) && meta == 15 && random.nextInt(4) == 0) {
            this.setBurnResult(world, x, y, z);
            return;
        }
        this.tryToCatchBlockOnFire(world, x + 1, y, z, 300, random, meta);
        this.tryToCatchBlockOnFire(world, x - 1, y, z, 300, random, meta);
        this.tryToCatchBlockOnFire(world, x, y - 1, z, 250, random, meta);
        this.tryToCatchBlockOnFire(world, x, y + 1, z, 250, random, meta);
        this.tryToCatchBlockOnFire(world, x, y, z - 1, 300, random, meta);
        this.tryToCatchBlockOnFire(world, x, y, z + 1, 300, random, meta);
        for (int x1 = x - 1; x1 <= x + 1; ++x1) {
            for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                for (int y1 = y - 1; y1 <= y + 4; ++y1) {
                    int c;
                    int b;
                    if (x1 == x && y1 == y && z1 == z) continue;
                    int a = 100;
                    if (y1 > y + 1) {
                        a += (y1 - (y + 1)) * 100;
                    }
                    if ((b = this.getChanceOfNeighborsEncouragingFire(world, x1, y1, z1)) <= 0 || (c = (b + 40) / (meta + 30)) <= 0 || random.nextInt(a) > c || world.currentWeather != null && world.currentWeather.isPrecipitation && world.canBlockBeRainedOn(x1, y1, z1) || world.canBlockBeRainedOn(x1 - 1, y1, z) || world.canBlockBeRainedOn(x1 + 1, y1, z1) || world.canBlockBeRainedOn(x1, y1, z1 - 1) || world.canBlockBeRainedOn(x1, y1, z1 + 1) || this.getBurnResultId(world, x1, y1, z1) != 0) continue;
                    world.setBlockAndMetadataWithNotify(x1, y1, z1, this.blockID, Math.min(meta + random.nextInt(5) / 4, 15));
                }
            }
        }
    }

    private void tryToCatchBlockOnFire(World world, int x, int y, int z, int chance, Random random, int meta) {
        if (random.nextInt(chance) < this.abilityToCatchFire[world.getBlockId(x, y, z)]) {
            boolean isTNT;
            boolean bl = isTNT = world.getBlockId(x, y, z) == Block.tnt.blockID;
            if (random.nextInt(meta + 10) < 5 && !world.canBlockBeRainedOn(x, y, z)) {
                if (this.getBurnResultId(world, x, y, z) == 0) {
                    world.setBlockAndMetadataWithNotify(x, y, z, this.blockID, Math.min(meta + random.nextInt(5) / 4, 15));
                }
            } else {
                this.setBurnResult(world, x, y, z);
            }
            if (isTNT) {
                BlockTNT blockTNT = (BlockTNT)Block.tnt;
                blockTNT.ignite(world, x, y, z, true);
            }
        }
    }

    private boolean canNeighborCatchFire(World world, int x, int y, int z) {
        if (this.canBlockCatchFire(world, x + 1, y, z)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x - 1, y, z)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x, y - 1, z)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x, y + 1, z)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x, y, z - 1)) {
            return true;
        }
        return this.canBlockCatchFire(world, x, y, z + 1);
    }

    private int getChanceOfNeighborsEncouragingFire(World world, int i, int j, int k) {
        int l = 0;
        if (!world.isAirBlock(i, j, k)) {
            return 0;
        }
        l = this.getChanceToEncourageFire(world, i + 1, j, k, l);
        l = this.getChanceToEncourageFire(world, i - 1, j, k, l);
        l = this.getChanceToEncourageFire(world, i, j - 1, k, l);
        l = this.getChanceToEncourageFire(world, i, j + 1, k, l);
        l = this.getChanceToEncourageFire(world, i, j, k - 1, l);
        l = this.getChanceToEncourageFire(world, i, j, k + 1, l);
        return l;
    }

    @Override
    public boolean isCollidable() {
        return false;
    }

    public boolean canBlockCatchFire(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.chanceToEncourageFire[iblockaccess.getBlockId(i, j, k)] > 0;
    }

    public int getChanceToEncourageFire(World world, int i, int j, int k, int l) {
        int i1 = this.chanceToEncourageFire[world.getBlockId(i, j, k)];
        if (i1 > l) {
            return i1;
        }
        return l;
    }

    public boolean canFirePersist(World world, int x, int y, int z) {
        return world.isBlockNormalCube(x, y - 1, z) || this.canNeighborCatchFire(world, x, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return this.canFirePersist(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (!world.isBlockNormalCube(i, j - 1, k) && !this.canNeighborCatchFire(world, i, j, k)) {
            world.setBlockWithNotify(i, j, k, this.getBurnResultId(world, i, j, k));
            return;
        }
    }

    protected int getBurnResultId(World world, int x, int y, int z) {
        int id = world.getBlockId(x, y, z);
        Block stoneBlock = BlockMoss.getStoneBlock(id);
        if (stoneBlock != null) {
            return stoneBlock.blockID;
        }
        return 0;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (world.getBlockId(i, j - 1, k) == Block.obsidian.blockID && ((BlockPortal)Block.portalNether).tryToCreatePortal(world, i, j, k)) {
            return;
        }
        if (!world.isBlockNormalCube(i, j - 1, k) && !this.canNeighborCatchFire(world, i, j, k)) {
            world.setBlockWithNotify(i, j, k, this.getBurnResultId(world, i, j, k));
        } else {
            world.scheduleBlockUpdate(i, j, k, this.blockID, this.tickRate());
        }
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        block12: {
            block11: {
                if (random.nextInt(24) == 0) {
                    world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "fire.fire", 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f);
                }
                if (!world.isBlockNormalCube(i, j - 1, k) && !((BlockFire)Block.fire).canBlockCatchFire(world, i, j - 1, k)) break block11;
                for (int l = 0; l < 3; ++l) {
                    float f = (float)i + random.nextFloat();
                    float f6 = (float)j + random.nextFloat() * 0.5f + 0.5f;
                    float f12 = (float)k + random.nextFloat();
                    world.spawnParticle("largesmoke", f, f6, f12, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, i - 1, j, k)) {
                for (int i1 = 0; i1 < 2; ++i1) {
                    float f1 = (float)i + random.nextFloat() * 0.1f;
                    float f7 = (float)j + random.nextFloat();
                    float f13 = (float)k + random.nextFloat();
                    world.spawnParticle("largesmoke", f1, f7, f13, 0.0, 0.0, 0.0);
                }
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, i + 1, j, k)) {
                for (int j1 = 0; j1 < 2; ++j1) {
                    float f2 = (float)(i + 1) - random.nextFloat() * 0.1f;
                    float f8 = (float)j + random.nextFloat();
                    float f14 = (float)k + random.nextFloat();
                    world.spawnParticle("largesmoke", f2, f8, f14, 0.0, 0.0, 0.0);
                }
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, i, j, k - 1)) {
                for (int k1 = 0; k1 < 2; ++k1) {
                    float f3 = (float)i + random.nextFloat();
                    float f9 = (float)j + random.nextFloat();
                    float f15 = (float)k + random.nextFloat() * 0.1f;
                    world.spawnParticle("largesmoke", f3, f9, f15, 0.0, 0.0, 0.0);
                }
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, i, j, k + 1)) {
                for (int l1 = 0; l1 < 2; ++l1) {
                    float f4 = (float)i + random.nextFloat();
                    float f10 = (float)j + random.nextFloat();
                    float f16 = (float)(k + 1) - random.nextFloat() * 0.1f;
                    world.spawnParticle("largesmoke", f4, f10, f16, 0.0, 0.0, 0.0);
                }
            }
            if (!((BlockFire)Block.fire).canBlockCatchFire(world, i, j + 1, k)) break block12;
            for (int i2 = 0; i2 < 2; ++i2) {
                float f5 = (float)i + random.nextFloat();
                float f11 = (float)(j + 1) - random.nextFloat() * 0.1f;
                float f17 = (float)k + random.nextFloat();
                world.spawnParticle("largesmoke", f5, f11, f17, 0.0, 0.0, 0.0);
            }
        }
    }
}

